/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.rest.parameters;

import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.IValidatingParameterWrapper;
import com.ibm.team.filesystem.client.internal.rest.ParmValidation;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.patch.PageDescriptorDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IPageDescriptor;
import com.ibm.team.scm.common.internal.dto2.impl.PageDescriptorImpl;

public class ParmsIndexedPageDescriptor
implements IValidatingParameterWrapper {
    public ParmsWorkspace workspace;
    public String componentId;
    public Integer pageSize;
    public Long startingIndex = 0L;
    public Long totalSize = 0L;
    public Long syncTime = 0L;

    public ParmsIndexedPageDescriptor(ParmsWorkspace workspace, String componentId, int pageSize) {
        this.workspace = workspace;
        this.componentId = componentId;
        this.pageSize = pageSize;
    }

    public ParmsIndexedPageDescriptor(ParmsWorkspace workspace, IPageDescriptor pageDescriptor) {
        this.workspace = workspace;
        this.componentId = pageDescriptor.getComponent().getItemId().getUuidValue();
        this.startingIndex = pageDescriptor.getStartIndex();
        this.pageSize = pageDescriptor.getMaxPageSize();
        this.syncTime = pageDescriptor.getSyncTime();
    }

    public ParmsIndexedPageDescriptor(PageDescriptorDTO pageDescriptorDTO) {
        this.workspace = new ParmsWorkspace(pageDescriptorDTO.getRepositoryURI(), pageDescriptorDTO.getWorkspaceID());
        this.componentId = pageDescriptorDTO.getComponentID();
        this.pageSize = pageDescriptorDTO.getMaxPageSize();
        this.startingIndex = pageDescriptorDTO.getStartIndex();
        this.totalSize = pageDescriptorDTO.getTotalSize();
        this.syncTime = pageDescriptorDTO.getSyncTime();
    }

    public ParmsIndexedPageDescriptor() {
    }

    @Override
    public void validate(String requestName, Object ... path) {
        ParmValidation.requiredValue(this.workspace, requestName, path, "workspace");
        ParmValidation.requiredValue(this.componentId, requestName, path, "componentId");
        ParmValidation.requiredValue(this.pageSize, requestName, path, "pageSize");
        if (this.pageSize < 1) {
            throw new IllegalArgumentException(NLS.bind((String)"{0} must be 1 or more for request {1}", (Object)"pageSize", (Object[])new Object[]{requestName}));
        }
        if (this.startingIndex < 0L) {
            throw new IllegalArgumentException(NLS.bind((String)"{0} must be 0 or more for request {1}", (Object)"startingIndex", (Object[])new Object[]{requestName}));
        }
    }

    public IPageDescriptor getPageDescriptor() throws TeamRepositoryException {
        ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
        IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.componentId), null);
        PageDescriptorImpl pageDescriptor = (PageDescriptorImpl)IPageDescriptor.FACTORY.initialize(this.workspace.getWorkspaceHandle(), componentHandle, this.startingIndex.longValue(), this.pageSize.intValue());
        pageDescriptor.setSyncTime(this.syncTime.longValue());
        return pageDescriptor;
    }

    public boolean hasNextPage() {
        if (this.startingIndex != null && this.totalSize != null) {
            return this.startingIndex < this.totalSize;
        }
        return false;
    }
}

