/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.TeamServiceException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;

public interface ITeamRestServiceClient {
    public IRestClientConnection getConnection(Location var1);

    public IRestClientConnection getConnection(URI var1);

    public static interface IRestClientConnection {
        public void addRequestHeader(String var1, String var2);

        public Response doGet() throws TeamServiceException, TeamRepositoryException;

        public Response doOptions() throws TeamServiceException, TeamRepositoryException;

        public Response doPost(InputStream var1, long var2, String var4) throws TeamServiceException, TeamRepositoryException;

        public Response doPut(InputStream var1, long var2, String var4) throws TeamServiceException, TeamRepositoryException;

        public Response doDelete() throws TeamServiceException, TeamRepositoryException;

        public IItem unmarshall(InputStream var1) throws TeamRepositoryException;

        @Deprecated
        public void release();

        public URI boundAbsoluteUri() throws TeamRepositoryException;

        public String getServiceUri();

        public Response getResponse();

        public static class Response {
            private final InputStream _responseStream;
            private final Map<String, String> _headers;
            private final StatusCode _statusCode;
            private final int _httpStatusCode;
            private final String _httpStatusText;

            public Response(InputStream responseStream, Map<String, String> headers, int httpStatusCode, String httpStatusText, StatusCode statusCode) {
                this._responseStream = responseStream;
                this._headers = headers;
                this._statusCode = statusCode;
                this._httpStatusCode = httpStatusCode;
                this._httpStatusText = httpStatusText;
            }

            public InputStream getResponseStream() {
                return this._responseStream;
            }

            public String getResponseHeader(String header) {
                return this._headers.get(header);
            }

            public Map<String, String> getAllResponseHeaders() {
                return this._headers;
            }

            public StatusCode getStatusCode() {
                return this._statusCode;
            }

            public int getHttpStatusCode() {
                return this._httpStatusCode;
            }

            public String getHttpStatusText() {
                return this._httpStatusText;
            }

            public static enum StatusCode {
                OK,
                CREATED,
                NOT_FOUND,
                NOT_MODIFIED,
                ERROR;

            }
        }
    }
}

