/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.transport.TeamServiceCallContextImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import org.apache.commons.httpclient.params.HttpConnectionParams;

public class InterruptableSocket
extends Socket {
    private Socket _socket;
    private SocketChannel _socketChannel;
    private int receiveBufferSize = 8192;
    private int sendBufferSize = 8192;

    public static Socket getSocketForThread(Thread thread) {
        return TeamServiceCallContextImpl.getSocketForThread((Thread)thread);
    }

    private static void setSocketForCurrentThread(Socket socket) {
        TeamServiceCallContextImpl.setSocketForCurrentThread((Socket)socket);
    }

    public static Socket newInterruptableSocket(Socket socket, SocketChannel socketChannel, HttpConnectionParams params) {
        return new InterruptableSocket(socket, socketChannel, params);
    }

    private InterruptableSocket(Socket socket, SocketChannel socketChannel, HttpConnectionParams params) {
        this._socket = socket;
        this._socketChannel = socketChannel;
        if (params != null) {
            if (params.isParameterSet("http.socket.sendbuffer")) {
                this.sendBufferSize = params.getSendBufferSize();
            }
            if (params.isParameterSet("http.socket.receivebuffer")) {
                this.receiveBufferSize = params.getReceiveBufferSize();
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this._socketChannel.close();
        this._socket.close();
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        try {
            InterruptableSocket.setSocketForCurrentThread(this);
            this._socket.connect(endpoint, timeout);
        }
        finally {
            InterruptableSocket.setSocketForCurrentThread(null);
        }
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        try {
            InterruptableSocket.setSocketForCurrentThread(this);
            this._socket.connect(endpoint);
        }
        finally {
            InterruptableSocket.setSocketForCurrentThread(null);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new InterruptableSocketInputStream(this, this._socket.getInputStream());
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new InterruptableSocketOutputStream(this, this._socket.getOutputStream());
    }

    public boolean isChannelClosed() {
        return !this._socketChannel.isOpen();
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        this._socket.bind(bindpoint);
    }

    public boolean equals(Object obj) {
        return this._socket.equals(obj);
    }

    @Override
    public SocketChannel getChannel() {
        return this._socket.getChannel();
    }

    @Override
    public InetAddress getInetAddress() {
        return this._socket.getInetAddress();
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this._socket.getKeepAlive();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this._socket.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this._socket.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this._socket.getLocalSocketAddress();
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this._socket.getOOBInline();
    }

    @Override
    public int getPort() {
        return this._socket.getPort();
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        try {
            int receiveBufferSize = this._socket.getReceiveBufferSize();
            return receiveBufferSize;
        }
        catch (SocketException e) {
            InetAddress remoteAddress = this._socket.getInetAddress();
            if (remoteAddress instanceof Inet6Address) {
                return this.receiveBufferSize;
            }
            throw e;
        }
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this._socket.getRemoteSocketAddress();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this._socket.getReuseAddress();
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        try {
            int sendBufferSize = this._socket.getSendBufferSize();
            return sendBufferSize;
        }
        catch (SocketException e) {
            InetAddress remoteAddress = this._socket.getInetAddress();
            if (remoteAddress instanceof Inet6Address) {
                return this.sendBufferSize;
            }
            throw e;
        }
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this._socket.getSoLinger();
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this._socket.getSoTimeout();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this._socket.getTcpNoDelay();
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this._socket.getTrafficClass();
    }

    public int hashCode() {
        return this._socket.hashCode();
    }

    @Override
    public boolean isBound() {
        return this._socket.isBound();
    }

    @Override
    public boolean isClosed() {
        return this._socket.isClosed();
    }

    @Override
    public boolean isConnected() {
        return this._socket.isConnected();
    }

    @Override
    public boolean isInputShutdown() {
        return this._socket.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this._socket.isOutputShutdown();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this._socket.sendUrgentData(data);
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this._socket.setKeepAlive(on);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this._socket.setOOBInline(on);
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this._socket.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this._socket.setReceiveBufferSize(size);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this._socket.setReuseAddress(on);
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        this._socket.setSendBufferSize(size);
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this._socket.setSoLinger(on, linger);
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this._socket.setSoTimeout(timeout);
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this._socket.setTcpNoDelay(on);
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this._socket.setTrafficClass(tc);
    }

    @Override
    public void shutdownInput() throws IOException {
        this._socket.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this._socket.shutdownOutput();
    }

    private static class InterruptableSocketInputStream
    extends InputStream {
        private InputStream _iStream;
        private InterruptableSocket _socket;

        public InterruptableSocketInputStream(InterruptableSocket socket, InputStream iStream) {
            this._socket = socket;
            this._iStream = iStream;
        }

        @Override
        public int available() throws IOException {
            if (this._socket.isChannelClosed()) {
                throw new IOException("socket channel closed");
            }
            try {
                InterruptableSocket.setSocketForCurrentThread(this._socket);
                int n = this._iStream.available();
                return n;
            }
            finally {
                InterruptableSocket.setSocketForCurrentThread(null);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                InterruptableSocket.setSocketForCurrentThread(this._socket);
                this._iStream.close();
            }
            finally {
                InterruptableSocket.setSocketForCurrentThread(null);
            }
        }

        @Override
        public synchronized void mark(int readlimit) {
            if (this._socket.isChannelClosed()) {
                return;
            }
            try {
                InterruptableSocket.setSocketForCurrentThread(this._socket);
                this._iStream.mark(readlimit);
            }
            finally {
                InterruptableSocket.setSocketForCurrentThread(null);
            }
        }

        @Override
        public boolean markSupported() {
            try {
                InterruptableSocket.setSocketForCurrentThread(this._socket);
                boolean bl = this._iStream.markSupported();
                return bl;
            }
            finally {
                InterruptableSocket.setSocketForCurrentThread(null);
            }
        }

        @Override
        public int read() throws IOException {
            if (this._socket.isChannelClosed()) {
                throw new IOException("socket channel closed");
            }
            try {
                InterruptableSocket.setSocketForCurrentThread(this._socket);
                int n = this._iStream.read();
                return n;
            }
            finally {
                InterruptableSocket.setSocketForCurrentThread(null);
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this._socket.isChannelClosed()) {
                throw new IOException("socket channel closed");
            }
            try {
                InterruptableSocket.setSocketForCurrentThread(this._socket);
                int n = this._iStream.read(b, off, len);
                return n;
            }
            finally {
                InterruptableSocket.setSocketForCurrentThread(null);
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (this._socket.isChannelClosed()) {
                throw new IOException("socket channel closed");
            }
            try {
                InterruptableSocket.setSocketForCurrentThread(this._socket);
                int n = this._iStream.read(b);
                return n;
            }
            finally {
                InterruptableSocket.setSocketForCurrentThread(null);
            }
        }

        @Override
        public synchronized void reset() throws IOException {
            if (this._socket.isChannelClosed()) {
                throw new IOException("socket channel closed");
            }
            try {
                InterruptableSocket.setSocketForCurrentThread(this._socket);
                this._iStream.reset();
            }
            finally {
                InterruptableSocket.setSocketForCurrentThread(null);
            }
        }

        @Override
        public long skip(long n) throws IOException {
            if (this._socket.isChannelClosed()) {
                throw new IOException("socket channel closed");
            }
            try {
                InterruptableSocket.setSocketForCurrentThread(this._socket);
                long l = this._iStream.skip(n);
                return l;
            }
            finally {
                InterruptableSocket.setSocketForCurrentThread(null);
            }
        }
    }

    private static class InterruptableSocketOutputStream
    extends OutputStream {
        private OutputStream _oStream;
        private InterruptableSocket _socket;

        public InterruptableSocketOutputStream(InterruptableSocket socket, OutputStream oStream) {
            this._socket = socket;
            this._oStream = oStream;
        }

        @Override
        public void close() throws IOException {
            try {
                InterruptableSocket.setSocketForCurrentThread(this._socket);
                this._oStream.close();
            }
            finally {
                InterruptableSocket.setSocketForCurrentThread(null);
            }
        }

        @Override
        public void flush() throws IOException {
            if (this._socket.isChannelClosed()) {
                throw new IOException("socket channel closed");
            }
            try {
                InterruptableSocket.setSocketForCurrentThread(this._socket);
                this._oStream.flush();
            }
            finally {
                InterruptableSocket.setSocketForCurrentThread(null);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this._socket.isChannelClosed()) {
                throw new IOException("socket channel closed");
            }
            try {
                InterruptableSocket.setSocketForCurrentThread(this._socket);
                this._oStream.write(b, off, len);
            }
            finally {
                InterruptableSocket.setSocketForCurrentThread(null);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (this._socket.isChannelClosed()) {
                throw new IOException("socket channel closed");
            }
            try {
                InterruptableSocket.setSocketForCurrentThread(this._socket);
                this._oStream.write(b);
            }
            finally {
                InterruptableSocket.setSocketForCurrentThread(null);
            }
        }

        @Override
        public void write(int b) throws IOException {
            if (this._socket.isChannelClosed()) {
                throw new IOException("socket channel closed");
            }
            try {
                InterruptableSocket.setSocketForCurrentThread(this._socket);
                this._oStream.write(b);
            }
            finally {
                InterruptableSocket.setSocketForCurrentThread(null);
            }
        }
    }
}

