/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.marshal.MarshalFactory;
import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.internal.marshal.impl.WebServicesMarshaller;
import com.ibm.team.repository.common.internal.marshal.util.MarshallerUtil;
import com.ibm.team.repository.common.transport.AbstractTeamService;
import com.ibm.team.repository.common.transport.ComponentConfiguration;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.repository.common.transport.ITeamContentService;
import com.ibm.team.repository.common.transport.ITeamModelledRestService;
import com.ibm.team.repository.common.transport.ITeamService;
import com.ibm.team.repository.common.transport.ParameterWrapperHandler;
import com.ibm.team.repository.common.transport.ServiceMethodInvocationError;
import com.ibm.team.repository.common.transport.TeamContent;
import com.ibm.team.repository.common.transport.TeamServiceCallContextImpl;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.common.transport.internal.services.Response;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.client.AuthenticationException;
import com.ibm.team.repository.transport.client.BufferedRequestEntity;
import com.ibm.team.repository.transport.client.CachingRetryableRequestEntity;
import com.ibm.team.repository.transport.client.ClientHttpUtil;
import com.ibm.team.repository.transport.client.OAuthUtil;
import com.ibm.team.repository.transport.client.ReleasingAndAbortingInputStream;
import com.ibm.team.repository.transport.client.RemoteTeamServer;
import com.ibm.team.repository.transport.client.ServiceInvocationHandler;
import com.ibm.team.repository.transport.internal.nls.Messages;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.OperationCanceledException;
import org.xmlsoap.schemas.soap.envelope.Envelope;
import org.xmlsoap.schemas.soap.envelope.Fault;

public class RemoteTeamService
extends AbstractTeamService {
    private static final Log logger = LogFactory.getLog((String)RemoteTeamService.class.getName());
    private static final String UserAgent = RemoteTeamService.class.getName();
    private static final String UTF8_CHARSET_NAME = "UTF-8";
    private static final String UseGzipProperty = "com.ibm.team.repository.common.services.UseGzip";
    private static final String ContentUploadCachingMaximum = "com.ibm.team.repository.transport.client.contentUploadCacheMaximum";
    private static final boolean UseGzip = RemoteTeamService.getUseGzip("com.ibm.team.repository.common.services.UseGzip");
    private static Method objectEquals;
    private static Method objectHashCode;
    private static Method objectToString;
    private final RemoteTeamServer remoteTeamServer;
    private final Object implementation;
    private final InvocationHandler invocationHandler;
    private final String serviceClassName;
    private final boolean isContentService;
    private final boolean isModelledRestService;
    private final String charsetEncoding = HttpUtil.CharsetEncoding.UTF8.toString();
    private static volatile String lastCheckedUrlString;

    static {
        RemoteTeamService.initialize();
        lastCheckedUrlString = null;
    }

    private static boolean getUseGzip(String property) {
        String value = System.getProperty(property, "true");
        return Boolean.valueOf(value);
    }

    private static void initialize() {
        try {
            objectEquals = Object.class.getMethod("equals", Object.class);
            objectHashCode = Object.class.getMethod("hashCode", new Class[0]);
            objectToString = Object.class.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public RemoteTeamService(RemoteTeamServer server, Class<?> serviceClass, ClassLoader serviceClassLoader, String version, List<ComponentConfiguration> componentConfigurations) {
        super(serviceClass, serviceClassLoader, version, componentConfigurations);
        this.remoteTeamServer = server;
        this.invocationHandler = new ServiceInvocationHandler((ITeamService)this);
        this.implementation = Proxy.newProxyInstance(this.getServiceClassLoader(), new Class[]{this.getServiceClass()}, this.invocationHandler);
        this.isContentService = this.implementation instanceof ITeamContentService;
        this.isModelledRestService = this.implementation instanceof ITeamModelledRestService;
        this.serviceClassName = this.getServiceClass().getName();
        RemoteTeamService.validateURL(server.getRepositoryURL());
    }

    public Object getImplementation() {
        return this.implementation;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.remoteTeamServer == null) {
            throw new IllegalStateException("ITeamServer is disposed");
        }
        if (method.equals(objectEquals)) {
            return this.handleEquals(args[0]);
        }
        if (method.equals(objectHashCode)) {
            return this.handleHashCode();
        }
        if (method.equals(objectToString)) {
            return this.handleToString();
        }
        if (this.isContentService) {
            if (method.getName().equals("get")) {
                return this.invokeContentGet((String)args[0]);
            }
            if (method.getName().equals("put")) {
                this.invokeContentPut((TeamContent)args[0]);
                return null;
            }
            throw new RuntimeException(NLS.bind((String)"Method \"{0}\" is not supported because content services only support get and put.", (Object)method.getName(), (Object[])new Object[0]));
        }
        if (this.isModelledRestService) {
            Object arg = args.length == 0 ? null : args[0];
            return this.invokeModelledRestService(method, arg);
        }
        Method testMethod = this.getMethod(method.getName());
        if (testMethod == null) {
            throw new RuntimeException(NLS.bind((String)"Method \"{0}\" is not supported because it was not found.", (Object)method.getName(), (Object[])new Object[0]));
        }
        if (!method.toString().equals(testMethod.toString())) {
            throw new RuntimeException(NLS.bind((String)"Method is not supported: {0}", (Object)method.getName(), (Object[])new Object[0]));
        }
        return this.executeMethod(method, args);
    }

    private String getURL() {
        String repoPath = this.remoteTeamServer.getRepositoryPath();
        return String.valueOf(repoPath) + "service/" + this.serviceClassName;
    }

    private Object invokeModelledRestService(Method method, Object argument) throws Throwable {
        Response serviceResponse;
        WebServicesMarshaller webServicesMarshaller;
        Throwable throwable;
        GetMethod httpMethod;
        block20: {
            Envelope envelope;
            block19: {
                if (argument != null && !(argument instanceof IParameterWrapper)) {
                    throw new RuntimeException("parameter to method should be an instance of IParameterWrapper");
                }
                String methodName = method.getName();
                httpMethod = null;
                boolean isPost = false;
                if (methodName.startsWith("get")) {
                    methodName = this.lowerFirst(methodName.substring(3));
                    httpMethod = new GetMethod(String.valueOf(this.getURL()) + "/" + methodName);
                } else if (methodName.startsWith("put")) {
                    methodName = this.lowerFirst(methodName.substring(3));
                    httpMethod = new PutMethod(String.valueOf(this.getURL()) + "/" + methodName);
                } else if (methodName.startsWith("post")) {
                    methodName = this.lowerFirst(methodName.substring(4));
                    httpMethod = new PostMethod(String.valueOf(this.getURL()) + "/" + methodName);
                    isPost = true;
                } else {
                    throw new RuntimeException("method should start with 'get', 'put' or 'post'");
                }
                httpMethod.setRequestHeader("http.useragent", UserAgent);
                httpMethod.setRequestHeader("Accept", HttpUtil.MediaType.XML.toString());
                httpMethod.setRequestHeader("Accept-Charset", this.charsetEncoding);
                ClientHttpUtil.setAcceptLanguageHeader((HttpMethod)httpMethod);
                this.addUseridHeader((HttpMethod)httpMethod);
                this.addServiceVersionHeader((HttpMethod)httpMethod, this.serviceClassName);
                Class<?> parameterType = method.getParameterTypes().length > 0 ? method.getParameterTypes()[0] : null;
                String queryString = ParameterWrapperHandler.createQueryString(parameterType, (IParameterWrapper)((IParameterWrapper)argument), (boolean)isPost);
                if (!isPost) {
                    httpMethod.setQueryString(queryString);
                } else {
                    ByteArrayRequestEntity requestEntity = new ByteArrayRequestEntity(queryString.getBytes(this.charsetEncoding), HttpUtil.MediaType.FORM_URLENCODED.toString());
                    ((PostMethod)httpMethod).setRequestEntity((RequestEntity)requestEntity);
                }
                throwable = null;
                try {
                    this.executeCancelableHttpMethod(this.remoteTeamServer.getHttpClient(), (HttpMethod)httpMethod, true, true);
                }
                catch (Throwable e) {
                    throwable = e instanceof TeamServiceException && ((TeamServiceException)e).getCause() != null && ((TeamServiceException)e).isFromServer() ? e.getCause() : e;
                }
                if (throwable != null) {
                    httpMethod.releaseConnection();
                    throw this.getAppropriateException(throwable, method.getExceptionTypes());
                }
                webServicesMarshaller = (WebServicesMarshaller)MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.WEB_SERVICES_LITERAL);
                serviceResponse = null;
                InputStream responseStream = httpMethod.getResponseBodyAsStream();
                envelope = (Envelope)webServicesMarshaller.demarshalInputStreamToObject(responseStream);
                if (envelope != null) break block19;
                Object object = this.thrownAwayResult(method.getReturnType());
                httpMethod.releaseConnection();
                return object;
            }
            try {
                try {
                    serviceResponse = envelope.getBody().getResponse();
                    Fault fault = envelope.getBody().getFault();
                    if (fault != null) {
                        throwable = this.constructExceptionFromFault(fault);
                        break block20;
                    }
                    if (serviceResponse != null) break block20;
                    throwable = new TeamServiceException("no SOAP response received");
                }
                catch (Throwable e) {
                    throwable = e;
                    httpMethod.releaseConnection();
                }
            }
            catch (Throwable throwable2) {
                httpMethod.releaseConnection();
                throw throwable2;
            }
        }
        httpMethod.releaseConnection();
        if (throwable != null) {
            throw this.getAppropriateException(throwable, method.getExceptionTypes());
        }
        return webServicesMarshaller.getResponseReturnValue(serviceResponse, method.getReturnType());
    }

    private TeamContent invokeContentGet(String uri) throws IOException, TeamRepositoryException {
        GetMethod method = new GetMethod(String.valueOf(this.getURL()) + "/" + uri);
        method.setRequestHeader("http.useragent", UserAgent);
        method.setRequestHeader("Accept-Charset", this.charsetEncoding);
        ClientHttpUtil.setAcceptLanguageHeader((HttpMethod)method);
        this.addUseridHeader((HttpMethod)method);
        this.addServiceVersionHeader((HttpMethod)method, this.serviceClassName);
        boolean releaseConnection = true;
        try {
            int status = this.executeCancelableHttpMethod(this.remoteTeamServer.getHttpClient(), (HttpMethod)method, false, true);
            if (status == 404) {
                this.throwNotFoundException(method);
            }
            if (method.getResponseContentLength() > Integer.MAX_VALUE) {
                throw new IOException(NLS.bind((String)Messages.getServerString("RemoteTeamService.ExceedsMaximumLength"), (Object)method.getResponseContentLength(), (Object[])new Object[0]));
            }
            Header header = method.getResponseHeader("Content-Type");
            if (header == null) {
                throw new IOException(NLS.bind((String)Messages.getServerString("RemoteTeamService.MissingHeader"), (Object)"Content-Type", (Object[])new Object[0]));
            }
            String contentType = header.getValue();
            header = method.getResponseHeader("Last-Modified");
            if (header == null) {
                throw new IOException(NLS.bind((String)Messages.getServerString("RemoteTeamService.MissingHeader"), (Object)"Last-Modified", (Object[])new Object[0]));
            }
            Timestamp lastModified = null;
            try {
                lastModified = new Timestamp(DateUtil.parseDate((String)header.getValue()).getTime());
            }
            catch (DateParseException e) {
                IOException exception = new IOException(NLS.bind((String)Messages.getServerString("RemoteTeamService.UnparseableHeader"), (Object)"Last-Modified", (Object[])new Object[0]));
                exception.initCause(e);
                throw exception;
            }
            ReleasingAndAbortingInputStream in = new ReleasingAndAbortingInputStream((HttpMethod)method);
            TeamContent result = new TeamContent(uri).setInputStream((InputStream)in).setSize((int)method.getResponseContentLength()).setContentType(contentType).setLastModified(lastModified);
            releaseConnection = false;
            TeamContent teamContent = result;
            return teamContent;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (releaseConnection) {
                method.releaseConnection();
            }
        }
    }

    private void throwNotFoundException(GetMethod method) throws IOException, ItemNotFoundException {
        WebServicesMarshaller webServicesMarshaller = (WebServicesMarshaller)MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.WEB_SERVICES_LITERAL);
        InputStream responseStream = method.getResponseBodyAsStream();
        Envelope envelope = null;
        try {
            envelope = (Envelope)webServicesMarshaller.demarshalInputStreamToObject(responseStream);
        }
        catch (MarshallingException marshallingException) {}
        if (envelope == null) {
            throw new ItemNotFoundException(method.getPath());
        }
        Throwable throwable = null;
        Fault fault = envelope.getBody().getFault();
        if (fault != null) {
            throwable = this.constructExceptionFromFault(fault);
        }
        if (throwable == null) {
            throw new ItemNotFoundException(method.getPath());
        }
        if (throwable instanceof ItemNotFoundException) {
            throw (ItemNotFoundException)throwable;
        }
        throw new ItemNotFoundException(method.getPath(), throwable);
    }

    private int getCachedContentUploadSize() {
        return Integer.getInteger(ContentUploadCachingMaximum, 1000000);
    }

    private void invokeContentPut(TeamContent teamContent) throws IOException, TeamRepositoryException {
        Object requestEntity;
        PutMethod method = new PutMethod(String.valueOf(this.getURL()) + "/" + teamContent.getURI());
        this.addUseridHeader((HttpMethod)method);
        this.addServiceVersionHeader((HttpMethod)method, this.serviceClassName);
        method.setRequestHeader("http.useragent", UserAgent);
        ClientHttpUtil.setAcceptLanguageHeader((HttpMethod)method);
        int contentSize = teamContent.getSize();
        if (contentSize > 0 && contentSize < this.getCachedContentUploadSize()) {
            requestEntity = new CachingRetryableRequestEntity(teamContent.getInputStream(), contentSize, teamContent.getContentType(), (HttpMethod)method);
        } else {
            final BufferedRequestEntity finalEntity = new BufferedRequestEntity(new BufferedInputStream(teamContent.getInputStream(), 16384), contentSize, teamContent.getContentType(), 16384, (HttpMethod)method);
            requestEntity = finalEntity;
            method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(){

                public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
                    return super.retryMethod(method, exception, executionCount) && finalEntity.canRepeat();
                }
            });
        }
        method.setRequestEntity((RequestEntity)requestEntity);
        String lastModified = DateUtil.formatDate((Date)teamContent.getLastModified());
        method.addRequestHeader("Last-Modified", lastModified);
        try {
            this.executeCancelableHttpMethod(this.remoteTeamServer.getHttpClient(), (HttpMethod)method, true, false);
        }
        finally {
            method.releaseConnection();
        }
    }

    private Object executeMethod(Method method, Object[] parameters) throws Throwable {
        String methodName = method.getName();
        String interfaceName = method.getDeclaringClass().getName();
        Class[] parameterTypes = method.getParameterTypes();
        WebServicesMarshaller webServicesMarshaller = (WebServicesMarshaller)MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.WEB_SERVICES_LITERAL);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Response serviceResponse = null;
        Throwable throwable = null;
        try {
            webServicesMarshaller.marshalServiceRequest(methodName, interfaceName, parameterTypes, parameters, 0, (OutputStream)byteArrayOutputStream);
            Envelope envelope = this.invokePost(webServicesMarshaller, byteArrayOutputStream, interfaceName);
            if (envelope == null) {
                return this.thrownAwayResult(method.getReturnType());
            }
            serviceResponse = envelope.getBody().getResponse();
            Fault fault = envelope.getBody().getFault();
            if (fault != null) {
                throwable = this.constructExceptionFromFault(fault);
            } else if (serviceResponse == null) {
                throwable = new TeamServiceException(Messages.getServerString("RemoteTeamService.NoResponse"));
            } else if (!serviceResponse.getMethod().equals(methodName)) {
                throwable = new TeamServiceException(NLS.bind((String)Messages.getServerString("RemoteTeamService.UnexpectedResponse"), (Object)methodName, (Object[])new Object[]{serviceResponse.getMethod()}));
            }
        }
        catch (Throwable e) {
            throwable = e;
        }
        if (throwable != null) {
            throw this.getAppropriateException(throwable, method.getExceptionTypes());
        }
        return webServicesMarshaller.getResponseReturnValue(serviceResponse, method.getReturnType());
    }

    private Envelope invokePost(WebServicesMarshaller webServicesMarshaller, ByteArrayOutputStream byteArrayOutputStream, String interfaceName) throws Throwable {
        ByteArrayRequestEntity requestEntity = new ByteArrayRequestEntity(byteArrayOutputStream.toByteArray(), HttpUtil.MediaType.XML.toString());
        PostMethod postMethod = new PostMethod(this.getURL());
        postMethod.getParams().setCredentialCharset(UTF8_CHARSET_NAME);
        postMethod.setRequestHeader("http.useragent", UserAgent);
        ClientHttpUtil.setAcceptLanguageHeader((HttpMethod)postMethod);
        if (postMethod.getRequestHeader("Accept") == null) {
            postMethod.setRequestHeader("Accept", HttpUtil.MediaType.XML.toString());
        }
        if (postMethod.getRequestHeader("Accept-Charset") == null) {
            postMethod.setRequestHeader("Accept-Charset", this.charsetEncoding);
        }
        this.addUseridHeader((HttpMethod)postMethod);
        this.addMarshallingHeader((HttpMethod)postMethod);
        this.addServiceVersionHeader((HttpMethod)postMethod, interfaceName);
        if (UseGzip) {
            postMethod.setRequestHeader("Accept-Encoding", "gzip");
        }
        postMethod.setRequestEntity((RequestEntity)requestEntity);
        try {
            this.executeCancelableHttpMethod(this.remoteTeamServer.getHttpClient(), (HttpMethod)postMethod, true, true);
            Envelope envelope = this.demarshallEnvelope(webServicesMarshaller, (HttpMethod)postMethod);
            return envelope;
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    private int executeCancelableHttpMethod(HttpClient httpClient, HttpMethod method, boolean handle404, boolean wrapIOException) throws IOException, TeamServiceException {
        AuthenticationException authEx;
        int status;
        block10: {
            status = 500;
            authEx = null;
            TeamServiceCallContextImpl.setUpCall((HttpMethod)method);
            try {
                try {
                    status = ClientHttpUtil.executeHttpMethod(this.remoteTeamServer, this, method, handle404, wrapIOException);
                }
                catch (AuthenticationException e) {
                    status = 401;
                    try {
                        status = OAuthUtil.handleOAuthChallenge(status, this.remoteTeamServer, method, this.remoteTeamServer.getOAuthHandler());
                        if (status == 401) {
                            authEx = e;
                        }
                    }
                    catch (Exception ex) {
                        int statusCode = -1;
                        if (ex instanceof TeamServiceException) {
                            statusCode = ((TeamServiceException)((Object)ex)).getStatusCode();
                        }
                        throw new TeamServiceException(ex.getMessage(), (Throwable)ex, statusCode);
                    }
                    TeamServiceCallContextImpl.tearDownCall();
                    break block10;
                }
            }
            catch (Throwable throwable) {
                TeamServiceCallContextImpl.tearDownCall();
                throw throwable;
            }
            TeamServiceCallContextImpl.tearDownCall();
        }
        if (status == 401 && authEx != null) {
            throw authEx;
        }
        return status;
    }

    private Envelope demarshallEnvelope(WebServicesMarshaller webServicesMarshaller, HttpMethod postMethod) throws IOException, MarshallingException {
        Header[] headers = postMethod.getResponseHeaders("Content-Encoding");
        if (headers == null) {
            headers = new Header[]{};
        }
        boolean gzipped = false;
        int i = 0;
        while (i < headers.length) {
            if (headers[i].getValue().equalsIgnoreCase("gzip")) {
                gzipped = true;
            }
            ++i;
        }
        InputStream responseStream = postMethod.getResponseBodyAsStream();
        if (gzipped) {
            responseStream = new GZIPInputStream(responseStream, 8192);
        }
        return (Envelope)webServicesMarshaller.demarshalInputStreamToObject(responseStream);
    }

    private Throwable constructExceptionFromFault(Fault fault) {
        Throwable result = MarshallerUtil.decodeFault((Fault)fault, (ClassLoader)this.getServiceClassLoader());
        return result;
    }

    private Throwable getAppropriateException(Throwable exception, Class<?>[] declaredExceptionTypes) {
        Class<?> exceptionClass = exception.getClass();
        if (declaredExceptionTypes == null) {
            declaredExceptionTypes = new Class[]{};
        }
        if (OperationCanceledException.class.isAssignableFrom(exceptionClass)) {
            return exception;
        }
        if (ConnectionException.class.isAssignableFrom(exceptionClass)) {
            return exception;
        }
        if (IllegalArgumentException.class.isAssignableFrom(exceptionClass)) {
            return exception;
        }
        if (Error.class.isAssignableFrom(exceptionClass)) {
            return new ServiceMethodInvocationError(exception);
        }
        if (RuntimeException.class.isAssignableFrom(exceptionClass)) {
            return new ServiceMethodInvocationError(exception);
        }
        int i = 0;
        while (i < declaredExceptionTypes.length) {
            if (declaredExceptionTypes[i].isAssignableFrom(exceptionClass)) {
                return exception;
            }
            ++i;
        }
        if (declaredExceptionTypes.length == 0) {
            String rteMessage = exception instanceof TeamServiceException ? Messages.getServerString("RemoteTeamService.CommError") : Messages.getServerString("RemoteTeamService.UndeclaredException");
            return this.rte(rteMessage, exception);
        }
        exceptionClass = declaredExceptionTypes[0];
        Constructor<?> exceptionConstructor = null;
        Object[] exceptionArgs = null;
        try {
            exceptionConstructor = exceptionClass.getConstructor(String.class, Throwable.class);
            exceptionArgs = new Object[]{exception.getMessage(), exception};
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (exceptionConstructor == null) {
            try {
                exceptionConstructor = exceptionClass.getConstructor(Throwable.class);
                exceptionArgs = new Object[]{exception};
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (exceptionConstructor == null) {
            try {
                exceptionConstructor = exceptionClass.getConstructor(String.class);
                exceptionArgs = new Object[]{exception.getMessage()};
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (exceptionConstructor == null) {
            try {
                exceptionConstructor = exceptionClass.getConstructor(new Class[0]);
                exceptionArgs = new Object[]{};
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (exceptionConstructor == null) {
            return this.rte(NLS.bind((String)Messages.getServerString("RemoteTeamService.MissingConstructor"), (Object)exceptionClass.getName(), (Object[])new Object[0]), exception);
        }
        Exception throwable = null;
        try {
            return (Throwable)exceptionConstructor.newInstance(exceptionArgs);
        }
        catch (IllegalArgumentException e) {
            throwable = e;
        }
        catch (InstantiationException e) {
            throwable = e;
        }
        catch (IllegalAccessException e) {
            throwable = e;
        }
        catch (InvocationTargetException e) {
            throwable = e;
        }
        return this.rte(NLS.bind((String)Messages.getServerString("RemoteTeamService.ExceptionError"), (Object)exception, (Object[])new Object[0]), throwable);
    }

    private void addMarshallingHeader(HttpMethod method) {
        method.addRequestHeader("X-com-ibm-team-marshaller-version", "0.2");
    }

    private void addUseridHeader(HttpMethod method) {
        String userid = this.remoteTeamServer.getUserid();
        ClientHttpUtil.addUseridHeader(userid, method);
    }

    private void addServiceVersionHeader(HttpMethod method, String serviceName) {
        String version = this.getVersion();
        if (version != null && !version.equals("")) {
            method.addRequestHeader("X-com-ibm-team-service-version", version);
        }
    }

    private RuntimeException rte(String message, Throwable cause) {
        return new RuntimeException(message, cause);
    }

    private String lowerFirst(String string) {
        return String.valueOf(string.substring(0, 1).toLowerCase(Locale.ENGLISH)) + string.substring(1);
    }

    private Object handleEquals(Object argument) {
        return this == argument ? Boolean.TRUE : Boolean.FALSE;
    }

    private Object handleHashCode() {
        return ((Object)((Object)this)).hashCode();
    }

    private Object handleToString() {
        return String.format("%s{%s}", ((Object)((Object)this)).getClass().getName(), this.getURL());
    }

    public String toString() {
        return String.format("%s{%s}", this.getServiceClass().getName(), this.getURL());
    }

    private static void validateURL(String urlString) {
        Throwable t;
        String msg;
        if (urlString.equals(lastCheckedUrlString)) {
            return;
        }
        lastCheckedUrlString = urlString;
        URL urlObject = null;
        try {
            urlObject = new URL(urlString);
        }
        catch (MalformedURLException e) {
            String msg2 = NLS.bind((String)Messages.getServerString("RemoteTeamService.UnparseableUri"), (Object)urlString, (Object[])new Object[0]);
            logger.warn((Object)msg2, (Throwable)e);
            return;
        }
        String protocol = urlObject.getProtocol();
        String host = urlObject.getHost();
        int port = urlObject.getPort();
        if (protocol == null || protocol.length() == 0) {
            msg = NLS.bind((String)Messages.getServerString("RemoteTeamService.MissingProtocol"), (Object)urlString, (Object[])new Object[0]);
            t = new Throwable(msg);
            logger.warn((Object)msg, t);
        }
        if (host == null || host.length() == 0) {
            msg = NLS.bind((String)Messages.getServerString("RemoteTeamService.MissingHost"), (Object)urlString, (Object[])new Object[0]);
            t = new Throwable(msg);
            logger.warn((Object)msg, t);
        }
        if (port != -1) {
            return;
        }
        int defaultPort = urlObject.getDefaultPort();
        if (defaultPort == -1) {
            String msg3 = NLS.bind((String)Messages.getServerString("RemoteTeamService.MissingPort"), (Object)urlString, (Object[])new Object[0]);
            Throwable t2 = new Throwable(msg3);
            logger.warn((Object)msg3, t2);
        }
    }
}

