/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.IServerContainerProvider;
import com.ibm.team.repository.common.transport.ICertificateValidator;
import com.ibm.team.repository.common.transport.IServerContainerDescriptor;
import com.ibm.team.repository.common.transport.ITeamServer;
import com.ibm.team.repository.common.transport.ServerContainerProviderRegistry;
import com.ibm.team.repository.transport.client.RemoteTeamServer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public class TeamServerFactoryImpl {
    public static final TeamServerFactoryImpl INSTANCE = new TeamServerFactoryImpl();
    public static final String URL_LOCAL = "local-server:/";
    public static final String URL_LOCAL_PROXY = "local:/";
    public static final int URL_VALID = 0;
    public static final int URL_INVALID_UNKNOWN = 1;
    public static final int URL_INVALID_PROTOCOL = 2;
    public static final int URL_INVALID_HOST = 3;
    public static final int URL_INVALID_PORT = 4;
    public static final String SERVER_PORT = System.getProperty("server.port", "9080");
    public static final String SERVER_PORT_SECURE = System.getProperty("server.port.secure", "9443");

    private TeamServerFactoryImpl() {
    }

    public int validateURL(String urlString) {
        URL url;
        if (urlString == null) {
            return 1;
        }
        if (urlString.length() == 0) {
            return 1;
        }
        if (!urlString.endsWith("/")) {
            urlString = String.valueOf(urlString) + "/";
        }
        if (urlString.startsWith(URL_LOCAL)) {
            return 0;
        }
        if (urlString.startsWith(URL_LOCAL_PROXY)) {
            return 0;
        }
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            return 1;
        }
        String urlProtocol = url.getProtocol();
        String urlHost = url.getHost();
        if (urlProtocol == null || urlProtocol.length() == 0) {
            return 2;
        }
        if (!urlProtocol.equals("http") && !urlProtocol.equals("https")) {
            return 2;
        }
        if (urlHost == null || urlHost.length() == 0) {
            return 3;
        }
        return 0;
    }

    public String startLocalServer(boolean secure) {
        List descriptors = ServerContainerProviderRegistry.INSTANCE.getDescriptors();
        boolean empty = descriptors.isEmpty();
        if (empty) {
            throw new RuntimeException("No Server Container Descriptors were found on the classpath.  Please check that the Jetty bundles are included in your launch or packaging.");
        }
        for (IServerContainerDescriptor descriptor : descriptors) {
            try {
                IServerContainerProvider provider = descriptor.getProvider();
                provider.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (secure) {
            return "https://localhost:" + SERVER_PORT_SECURE + "/jazz/secure/";
        }
        return "http://localhost:" + SERVER_PORT + "/jazz/";
    }

    public String startLocalServer() {
        return this.startLocalServer(false);
    }

    public ITeamServer newTeamServerFromURL(String url, ICertificateValidator handler) {
        if (this.validateURL(url) != 0) {
            return null;
        }
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        if (url.startsWith(URL_LOCAL_PROXY)) {
            url = this.startLocalServer(url.endsWith("/secure/"));
        }
        return new RemoteTeamServer(url, handler);
    }
}

