/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.expression.variables;

import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.workitem.common.expression.SerializationException;
import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.common.internal.expression.IPersistableElement;
import com.ibm.team.workitem.common.internal.expression.ISerializationContext;

public abstract class AbstractAttributeVariable<T>
implements IAttributeVariable<T> {
    private String fName;
    private String fArguments;

    public AbstractAttributeVariable() {
    }

    public AbstractAttributeVariable(String variableName) {
        this.fName = variableName;
    }

    @Override
    public void setArguments(String arguments) {
        this.fArguments = arguments;
    }

    @Override
    public String getArguments() {
        return this.fArguments;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public Object getValue() {
        return this;
    }

    @Override
    public void init(IPersistableElement variable, ISerializationContext context) throws SerializationException {
        if (variable.hasAttribute("arguments")) {
            this.setArguments(variable.getAttribute("arguments"));
        }
        if (variable.hasAttribute("name")) {
            this.fName = variable.getAttribute("name");
        }
    }

    @Override
    public void saveState(IPersistableElement variable) {
        String arguments = this.getArguments();
        if (arguments != null) {
            variable.setAttribute("arguments", arguments);
        }
        if (this.fName != null) {
            variable.setAttribute("name", this.fName);
        }
    }

    @Override
    public boolean isParameter() {
        return false;
    }

    @Override
    public JSONObject toJson() {
        JSONObject result = new JSONObject();
        if (this.isValid(this.getId())) {
            result.put((Object)IAttributeVariable.Identifiers.id.name(), (Object)this.getId());
        }
        if (this.isValid(this.getName())) {
            result.put((Object)IAttributeVariable.Identifiers.name.name(), (Object)this.getName());
        }
        if (this.isValid(this.getArguments())) {
            result.put((Object)IAttributeVariable.Identifiers.arguments.name(), (Object)this.getArguments());
        }
        return result;
    }

    private boolean isValid(String str) {
        return str != null && str.length() > 0;
    }
}

