/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.internal.Messages;
import com.ibm.team.workitem.common.internal.workflow.WorkflowInfo;
import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.Identifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public class StateGroups {
    public static final String PLAN_ITEMS_READY_FOR_TESTING = "com.ibm.team.rqm.stateGroup.readyForTesting";
    public static final String DEFECTS_READY_FOR_TESTING = "com.ibm.team.rqm.stateGroup.readyForTesting.defect";
    public static final String CFG_ID = "com.ibm.team.workitem.configuration.stateGroups";
    private static final String STATE_GROUP = "stateGroup";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String STATE = "state";
    private static final String RESOLUTION = "resolution";
    private static final String READY_FOR_TESTING_LABEL = Messages.getString("StateGroups.READY_FOR_TESTING");
    private List<StateGroup> fStateGroups = new ArrayList<StateGroup>();

    public static StateGroups readFromModelElement(ModelElement modelElement) {
        return StateGroups.readUsingAccessor(modelElement, new ModelElementAccessor());
    }

    public static StateGroups readFromProcessConfiguration(IProcessConfigurationElement processElement) {
        return StateGroups.readUsingAccessor(processElement, new ProcessConfigurationElementAccessor());
    }

    private static StateGroups readUsingAccessor(Object processObject, IProcessAccessor accessor) {
        StateGroups stateGroups = new StateGroups();
        Object[] objectArray = accessor.getChildren(processObject);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (STATE_GROUP.equals(accessor.getName(element))) {
                String id = accessor.getAttribute(element, ID);
                String name = accessor.getAttribute(element, NAME);
                if (id != null && id.length() > 0) {
                    StateGroup stateGroup = new StateGroup(id, name);
                    Object[] objectArray2 = accessor.getChildren(element);
                    int n3 = objectArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object childElement = objectArray2[n4];
                        if (STATE.equals(accessor.getName(childElement))) {
                            String stateId = accessor.getAttribute(childElement, ID);
                            stateGroup.addState(stateId);
                        } else if (RESOLUTION.equals(accessor.getName(childElement))) {
                            String resolutionId = accessor.getAttribute(childElement, ID);
                            stateGroup.addResolution(resolutionId);
                        }
                        ++n4;
                    }
                    stateGroups.add(stateGroup);
                }
            }
            ++n2;
        }
        return stateGroups;
    }

    public void storeToMemento(IMemento memento) {
        for (StateGroup stateGroup : this.fStateGroups) {
            IMemento stateMemento;
            if (stateGroup.isEmpty()) continue;
            IMemento stateGroupMemento = memento.createChild(STATE_GROUP);
            stateGroupMemento.putString(ID, stateGroup.getIdentifier());
            if (stateGroup.hasExplicitName()) {
                stateGroupMemento.putString(NAME, stateGroup.getName());
            }
            for (Identifier<IState> identifier : stateGroup.getStateIds()) {
                stateMemento = stateGroupMemento.createChild(STATE);
                stateMemento.putString(ID, identifier.getStringIdentifier());
            }
            for (Identifier<Comparable<IState>> identifier : stateGroup.getResolutionIds()) {
                stateMemento = stateGroupMemento.createChild(RESOLUTION);
                stateMemento.putString(ID, identifier.getStringIdentifier());
            }
        }
    }

    public boolean isEmpty() {
        return this.fStateGroups.isEmpty();
    }

    public StateGroup getStateGroup(String identifier) {
        for (StateGroup stateGroup : this.fStateGroups) {
            if (!identifier.equals(stateGroup.getIdentifier())) continue;
            return stateGroup;
        }
        return null;
    }

    public void add(StateGroup stateGroup) {
        if (stateGroup != null && this.getStateGroup(stateGroup.getIdentifier()) == null) {
            this.fStateGroups.add(stateGroup);
        }
    }

    public List<StateGroup> getStateGroups() {
        return Collections.unmodifiableList(this.fStateGroups);
    }

    public static String getMissingConfigurationMessage(String stateGroupId) {
        return NLS.bind((String)Messages.getString("StateGroups.MISSING_STATE_GROUP_CFG"), (Object)stateGroupId, (Object[])new Object[0]);
    }

    private static interface IProcessAccessor {
        public Object[] getChildren(Object var1);

        public String getAttribute(Object var1, String var2);

        public String getName(Object var1);
    }

    private static class ModelElementAccessor
    implements IProcessAccessor {
        private ModelElementAccessor() {
        }

        @Override
        public String getAttribute(Object object, String attributeId) {
            ModelElement element = (ModelElement)object;
            return element.getAttribute(attributeId);
        }

        @Override
        public Object[] getChildren(Object object) {
            ModelElement element = (ModelElement)object;
            return element.getChildElements().toArray();
        }

        @Override
        public String getName(Object object) {
            ModelElement element = (ModelElement)object;
            return element.getName();
        }
    }

    private static class ProcessConfigurationElementAccessor
    implements IProcessAccessor {
        private ProcessConfigurationElementAccessor() {
        }

        @Override
        public String getAttribute(Object object, String attributeId) {
            IProcessConfigurationElement element = (IProcessConfigurationElement)object;
            return element.getAttribute(attributeId);
        }

        @Override
        public Object[] getChildren(Object object) {
            IProcessConfigurationElement element = (IProcessConfigurationElement)object;
            return element.getChildren();
        }

        @Override
        public String getName(Object object) {
            IProcessConfigurationElement element = (IProcessConfigurationElement)object;
            return element.getName();
        }
    }

    public static class StateGroup {
        private final String fId;
        private final List<Identifier<IState>> fStates;
        private final List<Identifier<IResolution>> fResolutions;
        private String fName;

        public StateGroup(String id, String name) {
            Assert.isNotNull((Object)id);
            this.fId = id;
            this.fName = name;
            this.fStates = new ArrayList<Identifier<IState>>();
            this.fResolutions = new ArrayList<Identifier<IResolution>>();
        }

        public String getIdentifier() {
            return this.fId;
        }

        public String getName() {
            if (!this.hasExplicitName()) {
                if (StateGroups.PLAN_ITEMS_READY_FOR_TESTING.equals(this.fId) || StateGroups.DEFECTS_READY_FOR_TESTING.equals(this.fId)) {
                    return READY_FOR_TESTING_LABEL;
                }
                return this.fId;
            }
            return this.fName;
        }

        public boolean isEmpty() {
            return this.fStates.isEmpty() && this.fResolutions.isEmpty();
        }

        public List<Identifier<IState>> getStateIds() {
            return this.fStates;
        }

        public List<Identifier<IState>> getRepositoryStateIds() {
            ArrayList<Identifier<IState>> compatibility = new ArrayList<Identifier<IState>>(this.fStates.size());
            for (Identifier<IState> identifier : this.fStates) {
                String stripped = WorkflowInfo.stripOffPrefix(identifier.getStringIdentifier(), 's');
                compatibility.add(Identifier.create(IState.class, stripped));
            }
            return compatibility;
        }

        public List<Identifier<IResolution>> getResolutionIds() {
            return this.fResolutions;
        }

        public List<Identifier<IResolution>> getRepositoryResolutionIds() {
            ArrayList<Identifier<IResolution>> compatibility = new ArrayList<Identifier<IResolution>>(this.fResolutions.size());
            for (Identifier<IResolution> identifier : this.fResolutions) {
                String stripped = WorkflowInfo.stripOffPrefix(identifier.getStringIdentifier(), 'r');
                compatibility.add(Identifier.create(IResolution.class, stripped));
            }
            return compatibility;
        }

        public void addState(String stateId) {
            if (stateId != null && stateId.length() > 0) {
                this.fStates.add(Identifier.create(IState.class, stateId));
            }
        }

        public void addResolution(String resolutionId) {
            if (resolutionId != null && resolutionId.length() > 0) {
                this.fResolutions.add(Identifier.create(IResolution.class, resolutionId));
            }
        }

        public void clearStates() {
            this.fStates.clear();
        }

        public void clearResolutions() {
            this.fResolutions.clear();
        }

        private boolean hasExplicitName() {
            return this.fName != null && this.fName.length() > 0;
        }
    }
}

