/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.workitem.common.internal.FallbackValueSetProvider;
import com.ibm.team.workitem.common.internal.ValueSetProvider;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ValueSetProviderRegistry {
    private static final String VALUE_SET_PROVIDER_EXTENSION_POINT = "com.ibm.team.workitem.common.valueSetProvider";
    public static final String VALUE_SET_PROVIDER = "valueSetProvider";
    private static final String ID = "id";
    private static final String CLASS = "class";
    private static boolean fgInitialized = false;
    private static final Object LOCK = new Object();
    private static Map<String, IConfigurationElement> fgRegistry = new HashMap<String, IConfigurationElement>();

    public static ValueSetProvider getValueSetProvider(String providerId) {
        ValueSetProviderRegistry.initialize();
        IConfigurationElement element = fgRegistry.get(providerId);
        if (element != null) {
            try {
                Object provider = element.createExecutableExtension(CLASS);
                if (provider instanceof ValueSetProvider) {
                    return (ValueSetProvider)provider;
                }
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }

    public static ValueSetProvider getFallBackValueSetProvider() {
        return new FallbackValueSetProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize() {
        Object object = LOCK;
        synchronized (object) {
            if (!fgInitialized) {
                IConfigurationElement[] elements;
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(VALUE_SET_PROVIDER_EXTENSION_POINT);
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    String id;
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    if (VALUE_SET_PROVIDER.equals(element.getName()) && (id = element.getAttribute(ID)) != null) {
                        fgRegistry.put(id, element);
                    }
                    ++n2;
                }
                fgInitialized = true;
            }
        }
    }
}

