/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IQuery;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.query.ast.IStringField;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.internal.expression.ITransformationContext;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.workflow.IStateGroup;
import com.ibm.team.workitem.common.workflow.StateResolutionPair;
import org.eclipse.core.runtime.IProgressMonitor;

public class StateGroupEqualsOperation
extends AttributeOperation {
    private final boolean fInvert;

    public StateGroupEqualsOperation(String identifier, String displayName, boolean invert) {
        super(identifier, displayName);
        this.fInvert = invert;
    }

    @Override
    public boolean evaluate(Object left, Object right, IEvaluationContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean result;
        if (left instanceof IStateGroup && right instanceof IStateGroup) {
            String identifier1 = ((IStateGroup)left).getIdentifier();
            String identifier2 = ((IStateGroup)right).getIdentifier();
            boolean result2 = identifier1.equals(identifier2);
            return this.fInvert ? !result2 : result2;
        }
        boolean bl = result = left == null && right == null;
        return this.fInvert ? !result : result;
    }

    @Override
    public IPredicate getPredicate(ITransformationContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        Object value = context.getValue();
        if (value instanceof IStateGroup) {
            IQuery query = context.getQuery();
            IStringField stateField = (IStringField)context.getField(IWorkItem.STATE_PROPERTY);
            IStringField resolutionField = (IStringField)context.getField(IWorkItem.RESOLUTION_PROPERTY);
            IStateGroup group = (IStateGroup)value;
            IPredicate stateGroupPredicate = null;
            for (StateResolutionPair pair : group.getStateResolutionPairs()) {
                IPredicate predicate = stateField._eq((IString)query.newStringArg());
                context.addParameter(pair.getStateId().getStringIdentifier());
                if (pair.getResolutionId() != null) {
                    predicate = predicate._and(resolutionField._eq((IString)query.newStringArg()));
                    context.addParameter(pair.getResolutionId().getStringIdentifier());
                }
                stateGroupPredicate = stateGroupPredicate == null ? predicate : stateGroupPredicate._or(predicate);
            }
            if (stateGroupPredicate != null) {
                return this.fInvert ? stateGroupPredicate._not() : stateGroupPredicate;
            }
        }
        return null;
    }

    @Override
    public boolean isNegation() {
        return this.fInvert;
    }
}

