/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.model;

import com.ibm.team.repository.common.FileLocator;
import com.ibm.team.workitem.common.internal.model.ApprovalState;
import com.ibm.team.workitem.common.internal.model.ApprovalType;
import com.ibm.team.workitem.common.internal.model.impl.ApprovalDescriptorImpl;
import com.ibm.team.workitem.common.model.IApproval;
import com.ibm.team.workitem.common.model.IApprovalDescriptor;
import com.ibm.team.workitem.common.model.IApprovalState;
import com.ibm.team.workitem.common.model.IApprovalType;
import com.ibm.team.workitem.common.model.IApprovals;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class WorkItemApprovals {
    public static final IApprovalType APPROVAL_TYPE = new ApprovalType("com.ibm.team.workitem.approvalType.approval", "ApprovalType.APPROVAL_TYPE", WorkItemApprovals.createURL("icons/obj16/appr_generic.gif"));
    public static final IApprovalType REVIEW_TYPE = new ApprovalType("com.ibm.team.workitem.approvalType.review", "ApprovalType.REVIEW_TYPE", WorkItemApprovals.createURL("icons/obj16/appr_review.gif"));
    public static final IApprovalType VERIFICATION_TYPE = new ApprovalType("com.ibm.team.workitem.approvalType.verification", "ApprovalType.VERIFICATION_TYPE", WorkItemApprovals.createURL("icons/obj16/appr_verification.gif"));
    public static final IApprovalState PENDING_STATE = new ApprovalState("com.ibm.team.workitem.approvalState.pending", "ApprovalState.PENDING_STATE", WorkItemApprovals.createURL("icons/obj16/appr_pending.gif"));
    public static final IApprovalState APPROVED_STATE = new ApprovalState("com.ibm.team.workitem.approvalState.approved", "ApprovalState.APPROVED_STATE", WorkItemApprovals.createURL("icons/obj16/appr_approved.gif"));
    public static final IApprovalState REJECTED_STATE = new ApprovalState("com.ibm.team.workitem.approvalState.rejected", "ApprovalState.REJECTED_STATE", WorkItemApprovals.createURL("icons/obj16/appr_rejected.gif"));
    private static Map<String, IApprovalType> fgTypesMap = new HashMap<String, IApprovalType>();
    private static List<IApprovalType> fgTypes = new ArrayList<IApprovalType>();
    private static Map<String, IApprovalState> fgStatesMap = new HashMap<String, IApprovalState>();
    private static List<IApprovalState> fgStates = new ArrayList<IApprovalState>();

    static {
        WorkItemApprovals.add(APPROVAL_TYPE.getIdentifier(), APPROVAL_TYPE);
        WorkItemApprovals.add(REVIEW_TYPE.getIdentifier(), REVIEW_TYPE);
        WorkItemApprovals.add(VERIFICATION_TYPE.getIdentifier(), VERIFICATION_TYPE);
        WorkItemApprovals.add(APPROVED_STATE.getIdentifier(), APPROVED_STATE);
        WorkItemApprovals.add(REJECTED_STATE.getIdentifier(), REJECTED_STATE);
        WorkItemApprovals.add(PENDING_STATE.getIdentifier(), PENDING_STATE);
    }

    public static Map<IApprovalDescriptor, Collection<IApproval>> groupByApprovalDescriptors(IApprovals approvalsObj) {
        if (approvalsObj == null) {
            return null;
        }
        List<IApproval> approvals = approvalsObj.getContents();
        List<IApprovalDescriptor> descriptors = approvalsObj.getDescriptors();
        if (approvals == null || descriptors == null) {
            return null;
        }
        TreeMap<IApprovalDescriptor, Collection<IApproval>> results = new TreeMap<IApprovalDescriptor, Collection<IApproval>>(new Comparator<IApprovalDescriptor>(){

            @Override
            public int compare(IApprovalDescriptor o1, IApprovalDescriptor o2) {
                ApprovalDescriptorImpl descriptor1 = (ApprovalDescriptorImpl)o1;
                ApprovalDescriptorImpl descriptor2 = (ApprovalDescriptorImpl)o2;
                return descriptor1.getId() - descriptor2.getId();
            }
        });
        for (IApproval approval : approvals) {
            LinkedList<IApproval> currDescriptorList = (LinkedList<IApproval>)results.get(approval.getDescriptor());
            if (currDescriptorList == null) {
                currDescriptorList = new LinkedList<IApproval>();
                currDescriptorList.add(approval);
                results.put(approval.getDescriptor(), currDescriptorList);
                continue;
            }
            currDescriptorList.add(approval);
        }
        for (IApprovalDescriptor descriptor : descriptors) {
            if (results.containsKey(descriptor)) continue;
            results.put(descriptor, Collections.emptyList());
        }
        return results;
    }

    public static IApprovalType getType(String identifier) {
        return fgTypesMap.get(identifier);
    }

    public static List<IApprovalType> getTypes() {
        return Collections.unmodifiableList(fgTypes);
    }

    public static IApprovalState getState(String identifier) {
        return fgStatesMap.get(identifier);
    }

    public static List<IApprovalState> getStates() {
        return Collections.unmodifiableList(fgStates);
    }

    private static void add(String identifier, IApprovalType approvalType) {
        fgTypesMap.put(identifier, approvalType);
        fgTypes.add(approvalType);
    }

    private static void add(String identifier, IApprovalState approvalState) {
        fgStatesMap.put(identifier, approvalState);
        fgStates.add(approvalState);
    }

    private static URL createURL(String path) {
        return FileLocator.find((String)"com.ibm.team.workitem.common", (IPath)new Path(path));
    }
}

