/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.linking;

import com.ibm.team.calm.foundation.common.CALMDocument;
import com.ibm.team.calm.foundation.common.IHttpClient;
import com.ibm.team.calm.foundation.common.Property;
import com.ibm.team.calm.foundation.common.UnsupportedVersionException;
import com.ibm.team.calm.foundation.common.XMLHelper;
import com.ibm.team.calm.foundation.common.internal.CALMFoundationCommonPlugin;
import com.ibm.team.calm.foundation.common.internal.Messages;
import com.ibm.team.calm.foundation.common.internal.OSLCResource;
import com.ibm.team.calm.foundation.common.internal.OSLCResourceAccess;
import com.ibm.team.calm.foundation.common.internal.RDFUtils;
import com.ibm.team.calm.foundation.common.internal.linking.CALMBackLinkOperation;
import com.ibm.team.calm.foundation.common.internal.linking.HttpClientWrapper;
import com.ibm.team.calm.foundation.common.internal.linking.IHttpAccess;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.calm.foundation.common.linking.FilterDescription;
import com.ibm.team.calm.foundation.common.linking.PickerDescription;
import com.ibm.team.calm.foundation.common.linking.ResourceUpdater;
import com.ibm.team.calm.foundation.common.oslc.OSLCCoreIdentifiers;
import com.ibm.team.calm.foundation.common.oslc.Version;
import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OSLCResourceDescription {
    public static String ID_CM_CHANGE_REQUEST = "cmChangeRequest";
    public static String ID_CM_PLAN = "cmPlan";
    public static String ID_RM_REQUIREMENT = "rmRequirement";
    public static String ID_RM_REQUIREMENT_COLLECTION = "rmRequirementCollection";
    public static String ID_QM_TEST_CASE = "qmTestCase";
    public static String ID_QM_TEST_SCRIPT = "qmTestScript";
    public static String ID_QM_TEST_SUITE = "qmTestSuite";
    public static String ID_QM_TEST_PLAN = "qmTestPlan";
    public static String ID_QM_TEST_EXECUTION_RECORD = "qmTestExecutionRecord";
    public static String ID_QM_TEST_EXECUTION_RESULT = "qmTestExecutionResult";
    public static String ID_AM_ARCHITECHTURE_ELEMENT = "amArchitectureElement";
    public static String ID_SCM_CHANGE_SET = "scmChangeSet";
    private final String fResourceId;
    private final String fResourceLabel;
    private final String fOslcDomain;
    private final List<ServiceDescription> fServiceDescriptions;
    private final List<ResourceVersion> fResourceVersions;
    private final NamespaceContext fNamespaceContext;

    OSLCResourceDescription(String resourceId, String resourceLabel, String oslcDomain, List<ServiceDescription> serviceDescriptions, List<ResourceVersion> resourceVersions, NamespaceContext namespaceContext) {
        Assert.isNotNull((Object)resourceId);
        Assert.isNotNull((Object)resourceLabel);
        Assert.isNotNull((Object)oslcDomain);
        Assert.isNotNull(serviceDescriptions);
        Assert.isNotNull(resourceVersions);
        Assert.isNotNull((Object)namespaceContext);
        this.fResourceId = resourceId;
        this.fResourceLabel = resourceLabel;
        this.fOslcDomain = oslcDomain;
        this.fNamespaceContext = namespaceContext;
        this.fServiceDescriptions = serviceDescriptions;
        this.fResourceVersions = resourceVersions;
    }

    public String getOSLCDomain() {
        return this.fOslcDomain;
    }

    String getResourceId() {
        return this.fResourceId;
    }

    public String getResourceLabel() {
        return this.fResourceLabel;
    }

    public NamespaceContext getNamespaceContext() {
        return this.fNamespaceContext;
    }

    public ServiceDocument loadServiceDocument(String serviceProviderUrl, IHttpAccess httpAccess) throws TeamRepositoryException {
        return this.loadServiceDocument(serviceProviderUrl, new HttpClientWrapper(httpAccess));
    }

    public ServiceDocument loadServiceDocument(String serviceProviderUrl, IHttpClient httpClient) throws TeamRepositoryException {
        List<ServiceDescription> available = this.getServiceDescriptions();
        Iterator<ServiceDescription> it = available.iterator();
        while (it.hasNext()) {
            ServiceDescription serviceDesc = it.next();
            try {
                String content;
                block7: {
                    OSLCResource resource = OSLCResource.loadResource(httpClient, serviceProviderUrl, null, serviceDesc);
                    if (serviceDesc.isOSLCCoreVersion(OSLCCoreIdentifiers.VERSION_OSLC_CORE_20)) {
                        try {
                            content = RDFUtils.toXML(resource.getContentStream(), resource.getURL());
                            break block7;
                        }
                        catch (XMLHelper.XMLSerializeException e) {
                            CALMFoundationCommonPlugin.log("Problem parsing RDF document:" + resource.getURL(), e);
                            continue;
                        }
                        catch (RDFUtils.RDFParseException e) {
                            CALMFoundationCommonPlugin.log("Problem parsing RDF document:" + resource.getURL(), e);
                            continue;
                        }
                    }
                    content = resource.getContent();
                }
                return new ServiceDocument(new CALMDocument(content), serviceDesc, this.getNamespaceContext());
            }
            catch (UnsupportedVersionException unsupportedVersionException) {
                if (!it.hasNext()) continue;
            }
        }
        throw new TeamRepositoryException(Messages.getString("OSLCResourceAccess.ERROR_FAILED_TO_LOAD_SERVICE_DOCUMENT"));
    }

    public OSLCResource loadResource(String resourceUrl, String preferredVersion, IHttpAccess httpAccess) throws TeamRepositoryException {
        return this.loadResource(resourceUrl, preferredVersion, new HttpClientWrapper(httpAccess));
    }

    public OSLCResource loadResource(String resourceUrl, String preferredVersion, IHttpClient httpAccess) throws TeamRepositoryException {
        List<ResourceVersion> available = this.getResourceVersions();
        for (ResourceVersion desc : available) {
            if (preferredVersion != null && !preferredVersion.equals(desc.getVersion())) continue;
            try {
                return OSLCResource.loadResource(httpAccess, resourceUrl, null, desc);
            }
            catch (UnsupportedVersionException unsupportedVersionException) {}
        }
        return null;
    }

    public OSLCResource loadResourceWithUpdater(String resourceUrl, String preferredVersion, IHttpAccess httpAccess) throws TeamRepositoryException {
        return this.loadResource(resourceUrl, preferredVersion, new HttpClientWrapper(httpAccess));
    }

    public ResourceUpdater loadResourceWithUpdater(String resourceUrl, String preferredVersion, IHttpClient httpAccess, String ... requiredProperties) throws TeamRepositoryException {
        List<ResourceVersion> available = this.getResourceVersions();
        for (ResourceVersion desc : available) {
            if (preferredVersion != null && !preferredVersion.equals(desc.getVersion()) || !desc.supportsProperties(requiredProperties)) continue;
            try {
                ResourceUpdater resourceUpdater = desc.createResourceUpdater(resourceUrl, httpAccess);
                if (resourceUpdater == null) continue;
                resourceUpdater.load(requiredProperties);
                return resourceUpdater;
            }
            catch (UnsupportedVersionException unsupportedVersionException) {}
        }
        return null;
    }

    private <T extends AbstractResourceVersion> List<T> limitToV1AndOlder(List<T> result) {
        int i = 0;
        while (i < result.size()) {
            if ("1.0".equals(((AbstractResourceVersion)result.get(i)).getVersion())) {
                return result.subList(i, result.size());
            }
            ++i;
        }
        return Collections.emptyList();
    }

    public List<ServiceDescription> getServiceDescriptions() {
        List<ServiceDescription> descriptions = Collections.unmodifiableList(this.fServiceDescriptions);
        if (OSLCResourceAccess.useOslcVersion1(this)) {
            return this.limitToV1AndOlder(descriptions);
        }
        return descriptions;
    }

    public ServiceDescription getServiceDescription(String version) {
        for (ServiceDescription curr : this.getServiceDescriptions()) {
            if (!curr.getVersion().equals(version)) continue;
            return curr;
        }
        return null;
    }

    public ResourceVersion getResourceVersion(String version) {
        for (ResourceVersion curr : this.getResourceVersions()) {
            if (!curr.getVersion().equals(version)) continue;
            return curr;
        }
        return null;
    }

    public List<ResourceVersion> getResourceVersions() {
        List<ResourceVersion> resourceVersions = Collections.unmodifiableList(this.fResourceVersions);
        if (OSLCResourceAccess.useOslcVersion1(this)) {
            return this.limitToV1AndOlder(resourceVersions);
        }
        return resourceVersions;
    }

    public boolean hasPickerServiceDescription() {
        for (ServiceDescription cur : this.fServiceDescriptions) {
            if (!cur.hasPickerDescription()) continue;
            return true;
        }
        return false;
    }

    public boolean hasPickerServiceDescription(PickerType pickerType) {
        for (ServiceDescription cur : this.fServiceDescriptions) {
            if (cur.getPickerDescription(pickerType) == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasLinkUpdater(CALMLinkTypeInformation linkType) {
        if (linkType != null) {
            for (ResourceVersion curr : this.fResourceVersions) {
                if (!linkType.hasBackLinkElement(curr.getVersion()) || !curr.hasCALMBackLinkOperation()) continue;
                return true;
            }
        }
        return false;
    }

    public CALMBackLinkOperation getLinkUpdater(CALMLinkTypeInformation linkType, String version) {
        if (linkType != null && linkType.hasBackLinkElement(version)) {
            for (ResourceVersion curr : this.fResourceVersions) {
                if (!curr.getVersion().equals(version)) continue;
                return curr.createCALMBackLinkOperation();
            }
        }
        return null;
    }

    public static abstract class AbstractResourceVersion {
        private final String fVersion;
        private final Map<String, String> fHttpHeaders;
        private final String fContentType;
        private final OSLCResourceDescription fOslcResource;

        AbstractResourceVersion(OSLCResourceDescription oslcResource, String version, String contentType, Map<String, String> headers) {
            this.fOslcResource = oslcResource;
            this.fVersion = version;
            this.fContentType = contentType;
            this.fHttpHeaders = headers;
        }

        public OSLCResourceDescription getOslcResource() {
            return this.fOslcResource;
        }

        public String getVersion() {
            return this.fVersion;
        }

        public String getContentType() {
            return this.fContentType;
        }

        public Map<String, String> getHttpHeaders() {
            return this.fHttpHeaders;
        }

        public boolean isOSLCCoreVersion(Version version) {
            return this.fHttpHeaders != null && version.getIdentifier().equals(this.fHttpHeaders.get("OSLC-Core-Version"));
        }
    }

    static class FilterServiceDescription {
        private final String fId;
        private final String fBasePath;
        private final String fFilterURLPath;
        private final String fTitlePath;

        public FilterServiceDescription(String id, String basePath, String filterURLPath, String titlePath) {
            this.fId = id;
            this.fBasePath = basePath;
            this.fFilterURLPath = filterURLPath;
            this.fTitlePath = titlePath;
        }

        public String getId() {
            return this.fId;
        }

        public String getBasePath() {
            return this.fBasePath;
        }

        public String getFilterURLPath() {
            return this.fFilterURLPath;
        }

        public String getTitlePath() {
            return this.fTitlePath;
        }
    }

    static class PickerServiceDescription {
        private final String fHeightHintPath;
        private final String fPickerURLPath;
        private final String fResultNamespace;
        private final String fTitlePath;
        private final String fWidthHintPath;
        private final String fBasePath;
        private final String fIdentifierPath;
        private final String fIsDefaultPath;
        private final String fUsagePath;
        private final String fLabelPath;

        PickerServiceDescription(String basePath, String pickerURLPath, String titlePath, String labelPath, String widthHintPath, String heightHintPath, String resultNamespace, String identifierPath, String isDefaultPath, String usagePath) {
            this.fBasePath = basePath;
            this.fPickerURLPath = pickerURLPath;
            this.fTitlePath = titlePath;
            this.fLabelPath = labelPath;
            this.fWidthHintPath = widthHintPath;
            this.fHeightHintPath = heightHintPath;
            this.fResultNamespace = resultNamespace;
            this.fIdentifierPath = identifierPath;
            this.fIsDefaultPath = isDefaultPath;
            this.fUsagePath = usagePath;
        }

        public String getBasePath() {
            return this.fBasePath;
        }

        public String getPickerURLPath() {
            return this.fPickerURLPath;
        }

        public String getResultNamespace() {
            return this.fResultNamespace;
        }

        public String getTitlePath() {
            return this.fTitlePath;
        }

        public String getLabelPath() {
            return this.fLabelPath;
        }

        public String getHeightHintPath() {
            return this.fHeightHintPath;
        }

        public String getWidthHintPath() {
            return this.fWidthHintPath;
        }

        public String getIdentifierPath() {
            return this.fIdentifierPath;
        }

        public String getUsagePath() {
            return this.fUsagePath;
        }

        public String getIsDefaultPath() {
            return this.fIsDefaultPath;
        }
    }

    public static enum PickerType {
        SELECTION,
        CREATION;

    }

    public static enum PropertyType {
        LINK,
        SIMPLE;

    }

    public static class ResourcePropertyDescription {
        private final String fId;
        private final Property fProperty;
        private final String fPreferredNSPrefix;
        private final PropertyType fType;

        ResourcePropertyDescription(String id, PropertyType type, Property property, String preferredNSPrefix) {
            this.fId = id;
            this.fType = type;
            this.fProperty = property;
            this.fPreferredNSPrefix = preferredNSPrefix;
        }

        public String getId() {
            return this.fId;
        }

        public PropertyType getType() {
            return this.fType;
        }

        public Property getProperty() {
            return this.fProperty;
        }

        public String getPreferredNamespacePrefix() {
            return this.fPreferredNSPrefix;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.fId == null ? 0 : this.fId.hashCode());
            result = 31 * result + (this.fProperty == null ? 0 : this.fProperty.hashCode());
            result = 31 * result + (this.fPreferredNSPrefix == null ? 0 : this.fPreferredNSPrefix.hashCode());
            result = 31 * result + (this.fType == null ? 0 : this.fType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResourcePropertyDescription other = (ResourcePropertyDescription)obj;
            if (!this.fId.equals(other.fId)) {
                return false;
            }
            if (!this.fProperty.equals(other.fProperty)) {
                return false;
            }
            if (!this.fPreferredNSPrefix.equals(other.fPreferredNSPrefix)) {
                return false;
            }
            return this.fType.equals((Object)other.fType);
        }
    }

    public static class ResourceVersion
    extends AbstractResourceVersion {
        private static final String ATTR_CLASS = "class";
        private final IConfigurationElement fBackLinkOperationConfig;
        private final QName fElementName;
        private final IConfigurationElement fResourceUpdaterConfig;
        private final List<ResourcePropertyDescription> fResourceProperties;

        ResourceVersion(OSLCResourceDescription oslcResource, String version, String contentType, Map<String, String> headers, QName elementName, IConfigurationElement backLinkOperationConfig, IConfigurationElement resourceUpdaterConfig, List<ResourcePropertyDescription> resourceProperties) {
            super(oslcResource, version, contentType, headers);
            this.fBackLinkOperationConfig = backLinkOperationConfig;
            this.fElementName = elementName;
            this.fResourceUpdaterConfig = resourceUpdaterConfig;
            this.fResourceProperties = resourceProperties;
        }

        public QName getElementName() {
            return this.fElementName;
        }

        public boolean hasCALMBackLinkOperation() {
            return this.fBackLinkOperationConfig != null && this.fBackLinkOperationConfig.getAttribute(ATTR_CLASS) != null;
        }

        public CALMBackLinkOperation createCALMBackLinkOperation() {
            if (this.fBackLinkOperationConfig != null) {
                try {
                    Object operationObj = this.fBackLinkOperationConfig.createExecutableExtension(ATTR_CLASS);
                    if (operationObj instanceof CALMBackLinkOperation) {
                        CALMBackLinkOperation operation = (CALMBackLinkOperation)operationObj;
                        operation.setVersion(this.getVersion());
                        operation.setContentType(this.getContentType());
                        operation.setElementName(this.getElementName());
                        operation.setHttpHeaders(this.getHttpHeaders());
                        return operation;
                    }
                    FoundationLog logger = FoundationLog.getLog(ExtensionRegistryReader.class);
                    logger.error(MessageFormat.format("Back link operation not of type CALMBackLinkOperation. {0}", this.fBackLinkOperationConfig.getAttribute(ATTR_CLASS)), null);
                }
                catch (CoreException e) {
                    FoundationLog logger = FoundationLog.getLog(ExtensionRegistryReader.class);
                    logger.error(MessageFormat.format("Can not create back link operation {0}", this.fBackLinkOperationConfig.getAttribute(ATTR_CLASS)), (Throwable)e);
                }
            }
            return null;
        }

        public ResourceUpdater createResourceUpdater(String resourceURL, IHttpClient httpClient) {
            if (this.fResourceUpdaterConfig != null) {
                try {
                    Object operationObj = this.fResourceUpdaterConfig.createExecutableExtension(ATTR_CLASS);
                    if (operationObj instanceof ResourceUpdater) {
                        ResourceUpdater updater = (ResourceUpdater)operationObj;
                        updater.init(this, httpClient, resourceURL);
                        return updater;
                    }
                    FoundationLog logger = FoundationLog.getLog(ExtensionRegistryReader.class);
                    logger.error(MessageFormat.format("Resource updater not of type ResourceUpdater. {0}", this.fResourceUpdaterConfig.getAttribute(ATTR_CLASS)), null);
                }
                catch (CoreException e) {
                    FoundationLog logger = FoundationLog.getLog(ExtensionRegistryReader.class);
                    logger.error(MessageFormat.format("Resource updater not of type ResourceUpdater. {0}", this.fResourceUpdaterConfig.getAttribute(ATTR_CLASS)), (Throwable)e);
                }
            }
            return null;
        }

        public List<ResourcePropertyDescription> getResourcePropertyDescriptions() {
            return this.fResourceProperties;
        }

        public ResourcePropertyDescription getResourcePropertyDescription(String id) {
            for (ResourcePropertyDescription desc : this.fResourceProperties) {
                if (!desc.getId().equals(id)) continue;
                return desc;
            }
            return null;
        }

        public boolean supportsProperties(String[] properties) {
            String[] stringArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                String property = stringArray[n2];
                if (this.getResourcePropertyDescription(property) == null) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    public static class ServiceDescription
    extends AbstractResourceVersion {
        private Map<PickerType, PickerServiceDescription> fPickerDescriptions;
        private Map<String, FilterServiceDescription> fFilterServiceDescriptions;

        ServiceDescription(OSLCResourceDescription oslcResource, String version, String contentType, Map<String, String> headers) {
            super(oslcResource, version, contentType, headers);
        }

        void setPickerDescriptions(Map<PickerType, PickerServiceDescription> pickerDescriptions) {
            this.fPickerDescriptions = pickerDescriptions;
        }

        void setFilterServiceDescriptions(Map<String, FilterServiceDescription> filterServiceDescriptions) {
            this.fFilterServiceDescriptions = filterServiceDescriptions;
        }

        public boolean hasPickerDescription() {
            return !this.fPickerDescriptions.isEmpty();
        }

        public PickerServiceDescription getPickerDescription(PickerType type) {
            return this.fPickerDescriptions.get((Object)type);
        }

        public FilterServiceDescription getFilterServiceDescription(String id) {
            return this.fFilterServiceDescriptions.get(id);
        }

        public CALMBackLinkOperation getLinkUpdateOperation() {
            return this.getOslcResource().getResourceVersion(this.getVersion()).createCALMBackLinkOperation();
        }
    }

    public static class ServiceDocument {
        private final CALMDocument fDocument;
        private final ServiceDescription fServiceDescription;
        private final NamespaceContext fNamespaceContext;

        public ServiceDocument(CALMDocument document, ServiceDescription serviceDescription, NamespaceContext namespaceContext) {
            this.fDocument = document;
            this.fServiceDescription = serviceDescription;
            this.fNamespaceContext = namespaceContext;
        }

        public PickerDescription getPickerDescription(PickerType pickerType) throws CALMDocument.DocumentParseException {
            List<PickerDescription> descriptions = this.getPickerDescriptions(pickerType);
            return this.getDefaultPicker(descriptions);
        }

        public List<PickerDescription> getPickerDescriptions(PickerType pickerType, CALMLinkTypeInformation linkType) throws CALMDocument.DocumentParseException {
            List<PickerDescription> descriptions = this.getPickerDescriptions(pickerType);
            if (!linkType.hasPickerConfiguration(pickerType)) {
                PickerDescription defaultPicker = this.getDefaultPicker(descriptions);
                return defaultPicker == null ? Collections.emptyList() : Collections.singletonList(defaultPicker);
            }
            ArrayList<PickerDescription> applicablePickers = new ArrayList<PickerDescription>(1);
            for (PickerDescription description : descriptions) {
                if (!linkType.supportsPicker(description)) continue;
                applicablePickers.add(description);
            }
            return applicablePickers;
        }

        private PickerDescription getDefaultPicker(List<PickerDescription> descriptions) {
            for (PickerDescription pickerDescription : descriptions) {
                if (!pickerDescription.isDefault()) continue;
                return pickerDescription;
            }
            return descriptions.isEmpty() ? null : descriptions.get(0);
        }

        private List<PickerDescription> getPickerDescriptions(PickerType pickerType) throws CALMDocument.DocumentParseException {
            CALMDocument document = this.fDocument;
            ArrayList<PickerDescription> result = new ArrayList<PickerDescription>();
            PickerServiceDescription picker = this.fServiceDescription.getPickerDescription(pickerType);
            if (picker != null) {
                NodeList nodes = document.getNodes(picker.getBasePath(), this.fNamespaceContext);
                int idx = 0;
                while (idx < nodes.getLength()) {
                    Node node = nodes.item(idx);
                    String url = document.getText(picker.getPickerURLPath(), node, this.fNamespaceContext);
                    String title = document.getText(picker.getTitlePath(), node, this.fNamespaceContext);
                    String label = picker.getLabelPath() != null ? document.getText(picker.getLabelPath(), node, this.fNamespaceContext) : null;
                    String widthHint = document.getText(picker.getWidthHintPath(), node, this.fNamespaceContext);
                    String heightHint = document.getText(picker.getHeightHintPath(), node, this.fNamespaceContext);
                    HashSet<String> identifiers = new HashSet<String>();
                    boolean isDefault = false;
                    if (picker.getUsagePath() != null) {
                        NodeList usageNodes = document.getNodes(picker.getUsagePath(), node, this.fNamespaceContext);
                        int i = 0;
                        while (i < usageNodes.getLength()) {
                            String nodeValue = document.getText(usageNodes.item(i));
                            identifiers.add(nodeValue);
                            if (nodeValue.equals("http://open-services.net/ns/core#default")) {
                                isDefault = true;
                            }
                            ++i;
                        }
                    } else {
                        if (picker.getIdentifierPath() != null) {
                            identifiers.add(document.getText(picker.getIdentifierPath(), node, this.fNamespaceContext));
                        }
                        boolean bl = isDefault = picker.getIsDefaultPath() == null ? false : Boolean.valueOf(document.getText(picker.getIsDefaultPath(), node, this.fNamespaceContext));
                    }
                    if (url != null && url.length() > 0) {
                        result.add(new PickerDescription(title, label, url, widthHint, heightHint, picker.getResultNamespace(), pickerType, identifiers, isDefault));
                    }
                    ++idx;
                }
            }
            return result;
        }

        public List<FilterDescription> getFilterDescription(String filterId) throws CALMDocument.DocumentParseException {
            CALMDocument document = this.fDocument;
            ArrayList<FilterDescription> result = new ArrayList<FilterDescription>();
            FilterServiceDescription filter = this.fServiceDescription.getFilterServiceDescription(filterId);
            if (filter != null) {
                NodeList nodes = document.getNodes(filter.getBasePath(), this.fNamespaceContext);
                int idx = 0;
                while (idx < nodes.getLength()) {
                    Node node = nodes.item(idx);
                    String url = document.getText(filter.getFilterURLPath(), node, this.fNamespaceContext);
                    String title = document.getText(filter.getTitlePath(), node, this.fNamespaceContext);
                    if (url != null && url.length() > 0) {
                        result.add(new FilterDescription(filterId, title, url));
                    }
                    ++idx;
                }
            }
            return result;
        }
    }

    public static class ServiceEntry {
    }
}

