/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.preview;

import com.ibm.team.calm.foundation.common.IHttpClient;
import com.ibm.team.calm.foundation.common.Property;
import com.ibm.team.calm.foundation.common.Size;
import com.ibm.team.calm.foundation.common.internal.preview.CompactRenderingDocument;
import com.ibm.team.calm.foundation.common.internal.preview.ICompactRenderingRepresentation;
import com.ibm.team.calm.foundation.common.internal.preview.ResolutionError;
import com.ibm.team.calm.foundation.common.internal.rcp.dto.CompactRenderingRepresentation;
import com.ibm.team.calm.foundation.common.internal.rcp.dto.RcpFactory;
import com.ibm.team.calm.foundation.common.oslc.RDFIdentifiers;
import com.ibm.team.calm.foundation.common.preview.IResolutionError;
import com.ibm.team.calm.foundation.common.preview.IResourcePreview;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.transport.HttpUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ResourcePreview
implements IResourcePreview {
    public static final String COMPACT_RENDERING = "compactRendering";
    public static final String TITLE = "title";
    public static final String ABBREVIATION = "abbreviation";
    public static final String SHORTTITLE = "shortTitle";
    public static final String ICON = "icon";
    public static final String SMALL_PREVIEW = "smallPreview";
    public static final String SMALL_WIDTH = "smallWidth";
    public static final String SMALL_HEIGHT = "smallHeight";
    public static final String LARGE_PREVIEW = "largePreview";
    public static final String LARGE_WIDTH = "largeWidth";
    public static final String LARGE_HEIGHT = "largeHeight";
    public static final String ERROR = "_err";
    public static final String OAUTH_ERROR = "oauthRequired";
    public static final String OSLC_COMPACT = "oslcCompact";
    public static final String DOCUMENT = "document";
    public static final String HINT_WIDTH = "hintWidth";
    public static final String HINT_HEIGHT = "hintHeight";
    public static final String INITIAL_HEIGHT = "initialHeight";
    private static final Property PREFERRED_WIDTH = new Property("http://jazz.net/xmlns/prod/jazz/presentation/1.0/", "preferred_width");
    private static final Property PREFERRED_HEIGHT = new Property("http://jazz.net/xmlns/prod/jazz/presentation/1.0/", "preferred_height");
    private final URI fResourceURI;
    private XMLString fTitle;
    private XMLString fAbbreviation;
    private URI fIconURI;
    private URI fSmallPreviewURI;
    private Long fSmallPreviewWidth;
    private Long fSmallPreviewHeight;
    private Long fSmallPreviewInitialHeight;
    private URI fLargePreviewURI;
    private Long fLargePreviewWidth;
    private Long fLargePreviewHeight;
    private Long fLargePreviewInitialHeight;
    private IResolutionError fError;
    @Deprecated
    private URI fRendererUri;

    public ResourcePreview(URI resourceURI, IResolutionError error) {
        this.fResourceURI = resourceURI;
        this.fError = error;
    }

    public ResourcePreview(IURIReference reference, XMLString abbreviation, URI iconUri, URI smallPreviewUri, Long smallPreviewWidth, Long smallPreviewHeight, URI largePreviewUri, Long largePreviewWidth, Long largePreviewHeight) {
        this(reference != null && reference.getComment() != null ? XMLString.createFromPlainText((String)reference.getComment()) : null, reference != null ? reference.getURI() : null, abbreviation, iconUri, smallPreviewUri, smallPreviewWidth, smallPreviewHeight, largePreviewUri, largePreviewWidth, largePreviewHeight);
    }

    public ResourcePreview(IURIReference reference, XMLString abbreviation, URI iconUri, URI smallPreviewUri, Long smallPreviewWidth, Long smallPreviewHeight, Long smallPreviewHeightInitial, URI largePreviewUri, Long largePreviewWidth, Long largePreviewHeight, Long largePreviewHeightInitial) {
        this(reference != null && reference.getComment() != null ? XMLString.createFromPlainText((String)reference.getComment()) : null, reference != null ? reference.getURI() : null, abbreviation, iconUri, smallPreviewUri, smallPreviewWidth, smallPreviewHeight, smallPreviewHeightInitial, largePreviewUri, largePreviewWidth, largePreviewHeight, largePreviewHeightInitial);
    }

    public ResourcePreview(XMLString title, URI itemUri, XMLString abbreviation, URI iconUri, URI smallPreviewUri, Long smallPreviewWidth, Long smallPreviewHeight, URI largePreviewUri, Long largePreviewWidth, Long largePreviewHeight) {
        this(title, itemUri, abbreviation, iconUri, smallPreviewUri, smallPreviewWidth, smallPreviewHeight, null, largePreviewUri, largePreviewWidth, largePreviewHeight, null);
    }

    public ResourcePreview(XMLString title, URI itemUri, XMLString abbreviation, URI iconUri, URI smallPreviewUri, Long smallPreviewWidth, Long smallPreviewHeight, Long smallPreviewInitialHeight, URI largePreviewUri, Long largePreviewWidth, Long largePreviewHeight, Long largePreviewInitialHeight) {
        this.fTitle = title;
        this.fResourceURI = itemUri;
        this.fAbbreviation = abbreviation;
        this.fIconURI = iconUri;
        this.fSmallPreviewURI = smallPreviewUri;
        this.fSmallPreviewWidth = smallPreviewWidth;
        this.fSmallPreviewHeight = smallPreviewHeight;
        this.fSmallPreviewInitialHeight = smallPreviewInitialHeight;
        this.fLargePreviewURI = largePreviewUri;
        this.fLargePreviewWidth = largePreviewWidth;
        this.fLargePreviewHeight = largePreviewHeight;
        this.fLargePreviewInitialHeight = largePreviewInitialHeight;
    }

    public ResourcePreview(String title, String itemUri, String abbreviation, String iconUri, String smallPreviewUri, Long smallPreviewWidth, Long smallPreviewHeight, Long smallPreviewInitialHeight, String largePreviewUri, Long largePreviewWidth, Long largePreviewHeight, Long largePreviewInitialHeight) {
        this(title != null ? XMLString.createFromXMLText((String)title) : null, itemUri != null ? URI.create(itemUri) : null, abbreviation != null ? XMLString.createFromXMLText((String)abbreviation) : null, iconUri != null ? URI.create(iconUri) : null, smallPreviewUri != null ? URI.create(smallPreviewUri) : null, smallPreviewWidth, smallPreviewHeight, smallPreviewInitialHeight, largePreviewUri != null ? URI.create(largePreviewUri) : null, largePreviewWidth, largePreviewHeight, largePreviewInitialHeight);
    }

    @Override
    public URI getResourceURI() {
        return this.fResourceURI;
    }

    @Override
    public XMLString getTitle() {
        return this.fTitle;
    }

    @Override
    public XMLString getAbbreviation() {
        return this.fAbbreviation;
    }

    @Override
    public URI getIconURI() {
        return this.fIconURI;
    }

    public void setIconURI(URI uri) {
        this.fIconURI = uri;
    }

    @Override
    public URI getSmallPreviewURI() {
        return this.fSmallPreviewURI;
    }

    @Override
    public Long getSmallPreviewWidth() {
        return this.fSmallPreviewWidth;
    }

    @Override
    public Long getSmallPreviewHeight() {
        return this.fSmallPreviewHeight;
    }

    @Override
    public Long getSmallPreviewInitialHeight() {
        return this.fSmallPreviewInitialHeight;
    }

    @Override
    public URI getLargePreviewURI() {
        return this.fLargePreviewURI;
    }

    @Override
    public Long getLargePreviewWidth() {
        return this.fLargePreviewWidth;
    }

    @Override
    public Long getLargePreviewHeight() {
        return this.fLargePreviewHeight;
    }

    @Override
    public Long getLargePreviewInitialHeight() {
        return this.fLargePreviewInitialHeight;
    }

    public void setRendererURI(URI rendererUri) {
        this.fRendererUri = rendererUri;
    }

    public URI getRendererURI() {
        return this.fRendererUri;
    }

    @Override
    public IResolutionError getError() {
        return this.fError;
    }

    public void setError(IResolutionError error) {
        this.fError = error;
    }

    @Override
    public boolean hasAuthenticationError() {
        return this.getError() != null && this.getError().isAuthenticationError();
    }

    public boolean hasErrors() {
        return this.getError() != null;
    }

    public boolean hasError(IResolutionError error) {
        return this.getError() != null && this.getError().equals(error);
    }

    public static ResourcePreview createPreview(ICompactRenderingRepresentation compactRenderingRepresentation) {
        ResourcePreview preview = compactRenderingRepresentation.getError() == null ? new ResourcePreview(compactRenderingRepresentation.getTitle(), compactRenderingRepresentation.getAbout(), compactRenderingRepresentation.getShortTitle(), compactRenderingRepresentation.getIconLocation(), compactRenderingRepresentation.getSmallPreviewLocation(), compactRenderingRepresentation.getSmallPreviewWidth(), compactRenderingRepresentation.getSmallPreviewHeight(), compactRenderingRepresentation.getSmallPreviewInitialHeight(), compactRenderingRepresentation.getLargePreviewLocation(), compactRenderingRepresentation.getLargePreviewWidth(), compactRenderingRepresentation.getLargePreviewHeight(), compactRenderingRepresentation.getLargePreviewInitialHeight()) : new ResourcePreview(URI.create(compactRenderingRepresentation.getAbout()), compactRenderingRepresentation.getError());
        return preview;
    }

    public static List<ICompactRenderingRepresentation> createCompactRenderingRepresentations(Map<String, Map<String, Object>> contents) {
        ArrayList<ICompactRenderingRepresentation> result = new ArrayList<ICompactRenderingRepresentation>();
        if (contents != null) {
            for (String urlStr : contents.keySet()) {
                Map errorObject;
                ResolutionError error;
                Map contentMap = contents.get(urlStr);
                String compactRendering = COMPACT_RENDERING;
                boolean isOslcV2 = false;
                if (contentMap.containsKey(OSLC_COMPACT)) {
                    compactRendering = OSLC_COMPACT;
                    isOslcV2 = true;
                }
                if (contentMap.get(compactRendering) != null) {
                    contentMap = (Map)contentMap.get(compactRendering);
                }
                String title = (String)contentMap.get(TITLE);
                String abbreviation = (String)contentMap.get(SHORTTITLE);
                if (!contentMap.containsKey(SHORTTITLE)) {
                    abbreviation = (String)contentMap.get(ABBREVIATION);
                }
                String iconUri = (String)contentMap.get(ICON);
                String smallPreviewUri = null;
                Long smallWigth = null;
                Long smallHeight = null;
                Long smallHeightInit = null;
                String largePreviewUri = null;
                Long largeWidth = null;
                Long largeHeight = null;
                Long largeHeightInit = null;
                if (isOslcV2) {
                    Map large;
                    Map small = (Map)contentMap.get(SMALL_PREVIEW);
                    if (small != null) {
                        smallPreviewUri = (String)small.get(DOCUMENT);
                        smallWigth = ResourcePreview.parseSizeInToPx((String)small.get(HINT_WIDTH));
                        smallHeight = ResourcePreview.parseSizeInToPx((String)small.get(HINT_HEIGHT));
                        smallHeightInit = ResourcePreview.parseSizeInToPx((String)small.get(INITIAL_HEIGHT));
                    }
                    if ((large = (Map)contentMap.get(LARGE_PREVIEW)) != null) {
                        largePreviewUri = (String)large.get(DOCUMENT);
                        largeWidth = ResourcePreview.parseSizeInToPx((String)large.get(HINT_WIDTH));
                        largeHeight = ResourcePreview.parseSizeInToPx((String)large.get(HINT_HEIGHT));
                        largeHeightInit = ResourcePreview.parseSizeInToPx((String)large.get(INITIAL_HEIGHT));
                    }
                } else {
                    smallPreviewUri = (String)contentMap.get(SMALL_PREVIEW);
                    smallWigth = (Long)contentMap.get(SMALL_WIDTH);
                    smallHeight = (Long)contentMap.get(SMALL_HEIGHT);
                    largePreviewUri = (String)contentMap.get(LARGE_PREVIEW);
                    largeWidth = (Long)contentMap.get(LARGE_WIDTH);
                    largeHeight = (Long)contentMap.get(LARGE_HEIGHT);
                }
                CompactRenderingRepresentation cur = RcpFactory.eINSTANCE.createCompactRenderingRepresentation();
                cur.setAbout(urlStr);
                cur.setTitle(title);
                cur.setShortTitle(abbreviation);
                cur.setIconLocation(iconUri);
                cur.setSmallPreviewLocation(smallPreviewUri);
                cur.setSmallPreviewWidth(smallWigth);
                cur.setSmallPreviewHeight(smallHeight);
                cur.setSmallPreviewInitialHeight(smallHeightInit);
                cur.setLargePreviewLocation(largePreviewUri);
                cur.setLargePreviewWidth(largeWidth);
                cur.setLargePreviewHeight(largeHeight);
                cur.setLargePreviewInitialHeight(largeHeightInit);
                ResolutionError resolutionError = error = contentMap.get(OAUTH_ERROR) != null ? new ResolutionError(0, null, true) : null;
                if (error == null && (errorObject = (Map)contentMap.get(ERROR)) != null) {
                    error = new ResolutionError((String)errorObject.get("message"));
                }
                if (error != null) {
                    cur = CompactRenderingDocument.createRepresentationWithError(urlStr, error);
                }
                result.add(cur);
            }
        }
        return result;
    }

    public static List<ResourcePreview> createPreviews(Map<String, Map<String, Object>> contents) {
        ArrayList<ResourcePreview> result = new ArrayList<ResourcePreview>();
        if (contents != null) {
            for (String urlStr : contents.keySet()) {
                Map errorObject;
                ResolutionError error;
                Map contentMap = contents.get(urlStr);
                String compactRendering = COMPACT_RENDERING;
                boolean isOslcV2 = false;
                if (contentMap.containsKey(OSLC_COMPACT)) {
                    compactRendering = OSLC_COMPACT;
                    isOslcV2 = true;
                }
                if (contentMap.get(compactRendering) != null) {
                    contentMap = (Map)contentMap.get(compactRendering);
                }
                URI resourceUri = ResourcePreview.createUri(urlStr);
                String title = (String)contentMap.get(TITLE);
                String abbreviation = (String)contentMap.get(SHORTTITLE);
                if (!contentMap.containsKey(SHORTTITLE)) {
                    abbreviation = (String)contentMap.get(ABBREVIATION);
                }
                URI iconUri = ResourcePreview.createUri((String)contentMap.get(ICON));
                URI smallPreviewUri = null;
                Long smallWigth = null;
                Long smallHeight = null;
                Long smallHeightInit = null;
                URI largePreviewUri = null;
                Long largeWidth = null;
                Long largeHeight = null;
                Long largeHeightInit = null;
                if (isOslcV2) {
                    Map large;
                    Map small = (Map)contentMap.get(SMALL_PREVIEW);
                    if (small != null) {
                        smallPreviewUri = ResourcePreview.createUri((String)small.get(DOCUMENT));
                        smallWigth = ResourcePreview.parseSizeInToPx((String)small.get(HINT_WIDTH));
                        smallHeight = ResourcePreview.parseSizeInToPx((String)small.get(HINT_HEIGHT));
                        smallHeightInit = ResourcePreview.parseSizeInToPx((String)small.get(INITIAL_HEIGHT));
                    }
                    if ((large = (Map)contentMap.get(LARGE_PREVIEW)) != null) {
                        largePreviewUri = ResourcePreview.createUri((String)large.get(DOCUMENT));
                        largeWidth = ResourcePreview.parseSizeInToPx((String)large.get(HINT_WIDTH));
                        largeHeight = ResourcePreview.parseSizeInToPx((String)large.get(HINT_HEIGHT));
                        largeHeightInit = ResourcePreview.parseSizeInToPx((String)large.get(INITIAL_HEIGHT));
                    }
                } else {
                    smallPreviewUri = ResourcePreview.createUri((String)contentMap.get(SMALL_PREVIEW));
                    smallWigth = (Long)contentMap.get(SMALL_WIDTH);
                    smallHeight = (Long)contentMap.get(SMALL_HEIGHT);
                    largePreviewUri = ResourcePreview.createUri((String)contentMap.get(LARGE_PREVIEW));
                    largeWidth = (Long)contentMap.get(LARGE_WIDTH);
                    largeHeight = (Long)contentMap.get(LARGE_HEIGHT);
                }
                ResourcePreview cur = new ResourcePreview(title != null ? XMLString.createFromXMLText((String)title) : null, resourceUri, abbreviation != null ? XMLString.createFromXMLText((String)abbreviation) : null, iconUri, smallPreviewUri, smallWigth, smallHeight, smallHeightInit, largePreviewUri, largeWidth, largeHeight, largeHeightInit);
                ResolutionError resolutionError = error = contentMap.get(OAUTH_ERROR) != null ? new ResolutionError(0, null, true) : null;
                if (error == null && (errorObject = (Map)contentMap.get(ERROR)) != null) {
                    error = new ResolutionError((String)errorObject.get("message"));
                }
                if (error != null) {
                    cur = new ResourcePreview(resourceUri, error);
                }
                result.add(cur);
            }
        }
        return result;
    }

    public static ICompactRenderingRepresentation createCompactRenderingRepresentationFromXML(Reader reader) throws IOException {
        if (reader != null) {
            NodeList childNodes;
            Element root = ResourcePreview.parseXMLDocument(reader);
            String resourceUri = ResourcePreview.getAttributeValue(RDFIdentifiers.ABOUT, root);
            String title = null;
            String abbreviation = null;
            String iconUri = null;
            String smallPrevUri = null;
            String smallPrevWth = null;
            String smallPrevHgt = null;
            String largePrevUri = null;
            String largePrevWth = null;
            String largePrevHgt = null;
            if (root.hasChildNodes() && (childNodes = root.getChildNodes()) != null) {
                boolean foundShortTitle = false;
                int idx = 0;
                int len = childNodes.getLength();
                while (idx < len) {
                    Node cur = childNodes.item(idx);
                    if (cur instanceof Element) {
                        if (TITLE.equals(cur.getLocalName())) {
                            title = ResourcePreview.getElementValue(cur);
                        } else if (!foundShortTitle && ABBREVIATION.equals(cur.getLocalName())) {
                            abbreviation = ResourcePreview.getElementValue(cur);
                        } else if (SHORTTITLE.equals(cur.getLocalName())) {
                            abbreviation = ResourcePreview.getElementValue(cur);
                            foundShortTitle = true;
                        } else if (ICON.equals(cur.getLocalName())) {
                            iconUri = ResourcePreview.getAttributeValue(RDFIdentifiers.RESOURCE, cur);
                        } else if (SMALL_PREVIEW.equals(cur.getLocalName())) {
                            smallPrevUri = ResourcePreview.getAttributeValue(RDFIdentifiers.RESOURCE, cur);
                            smallPrevWth = ResourcePreview.getAttributeValue(PREFERRED_WIDTH, cur);
                            smallPrevHgt = ResourcePreview.getAttributeValue(PREFERRED_HEIGHT, cur);
                        } else if (LARGE_PREVIEW.equals(cur.getLocalName())) {
                            largePrevUri = ResourcePreview.getAttributeValue(RDFIdentifiers.RESOURCE, cur);
                            largePrevWth = ResourcePreview.getAttributeValue(PREFERRED_WIDTH, cur);
                            largePrevHgt = ResourcePreview.getAttributeValue(PREFERRED_HEIGHT, cur);
                        }
                    }
                    ++idx;
                }
            }
            try {
                CompactRenderingRepresentation cur = RcpFactory.eINSTANCE.createCompactRenderingRepresentation();
                cur.setAbout(resourceUri);
                cur.setTitle(title);
                cur.setShortTitle(abbreviation);
                cur.setIconLocation(iconUri);
                cur.setSmallPreviewLocation(smallPrevUri);
                cur.setSmallPreviewWidth(smallPrevWth != null ? Long.valueOf(Long.parseLong(smallPrevWth)) : null);
                cur.setSmallPreviewHeight(smallPrevHgt != null ? Long.valueOf(Long.parseLong(smallPrevHgt)) : null);
                cur.setLargePreviewLocation(largePrevUri);
                cur.setLargePreviewWidth(largePrevWth != null ? Long.valueOf(Long.parseLong(largePrevWth)) : null);
                cur.setLargePreviewHeight(largePrevHgt != null ? Long.valueOf(Long.parseLong(largePrevHgt)) : null);
                return cur;
            }
            catch (NumberFormatException ex) {
                throw new IOException(ex.getMessage());
            }
        }
        return null;
    }

    public static ResourcePreview createPreviewFromXML(Reader reader) throws IOException {
        if (reader != null) {
            NodeList childNodes;
            Element root = ResourcePreview.parseXMLDocument(reader);
            String resourceUri = ResourcePreview.getAttributeValue(RDFIdentifiers.ABOUT, root);
            String title = null;
            String abbreviation = null;
            String iconUri = null;
            String smallPrevUri = null;
            String smallPrevWth = null;
            String smallPrevHgt = null;
            String largePrevUri = null;
            String largePrevWth = null;
            String largePrevHgt = null;
            if (root.hasChildNodes() && (childNodes = root.getChildNodes()) != null) {
                boolean foundShortTitle = false;
                int idx = 0;
                int len = childNodes.getLength();
                while (idx < len) {
                    Node cur = childNodes.item(idx);
                    if (cur instanceof Element) {
                        if (TITLE.equals(cur.getLocalName())) {
                            title = ResourcePreview.getElementValue(cur);
                        } else if (!foundShortTitle && ABBREVIATION.equals(cur.getLocalName())) {
                            abbreviation = ResourcePreview.getElementValue(cur);
                        } else if (SHORTTITLE.equals(cur.getLocalName())) {
                            abbreviation = ResourcePreview.getElementValue(cur);
                            foundShortTitle = true;
                        } else if (ICON.equals(cur.getLocalName())) {
                            iconUri = ResourcePreview.getAttributeValue(RDFIdentifiers.RESOURCE, cur);
                        } else if (SMALL_PREVIEW.equals(cur.getLocalName())) {
                            smallPrevUri = ResourcePreview.getAttributeValue(RDFIdentifiers.RESOURCE, cur);
                            smallPrevWth = ResourcePreview.getAttributeValue(PREFERRED_WIDTH, cur);
                            smallPrevHgt = ResourcePreview.getAttributeValue(PREFERRED_HEIGHT, cur);
                        } else if (LARGE_PREVIEW.equals(cur.getLocalName())) {
                            largePrevUri = ResourcePreview.getAttributeValue(RDFIdentifiers.RESOURCE, cur);
                            largePrevWth = ResourcePreview.getAttributeValue(PREFERRED_WIDTH, cur);
                            largePrevHgt = ResourcePreview.getAttributeValue(PREFERRED_HEIGHT, cur);
                        }
                    }
                    ++idx;
                }
            }
            try {
                return new ResourcePreview(title != null ? XMLString.createFromXMLText(title) : null, resourceUri != null ? new URI(resourceUri) : null, abbreviation != null ? XMLString.createFromXMLText(abbreviation) : null, iconUri != null ? new URI(iconUri) : null, smallPrevUri != null ? new URI(smallPrevUri) : null, smallPrevWth != null ? Long.valueOf(Long.parseLong(smallPrevWth)) : null, smallPrevHgt != null ? Long.valueOf(Long.parseLong(smallPrevHgt)) : null, largePrevUri != null ? new URI(largePrevUri) : null, largePrevWth != null ? Long.valueOf(Long.parseLong(largePrevWth)) : null, largePrevHgt != null ? Long.valueOf(Long.parseLong(largePrevHgt)) : null);
            }
            catch (NumberFormatException ex) {
                throw new IOException(ex.getMessage());
            }
            catch (URISyntaxException ex) {
                throw new IOException(ex.getMessage());
            }
        }
        return null;
    }

    private static Element parseXMLDocument(Reader reader) throws IOException {
        BufferedReader input = new BufferedReader(reader);
        String line = input.readLine();
        StringBuffer xmlContent = new StringBuffer();
        while (line != null) {
            xmlContent.append(line);
            line = input.readLine();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            byte[] bytes = xmlContent.toString().getBytes(HttpUtil.CharsetEncoding.UTF8.toCharset().name());
            Document document = documentBuilder.parse(new ByteArrayInputStream(bytes));
            return document.getDocumentElement();
        }
        catch (ParserConfigurationException ex) {
            throw new IOException(ex.getMessage());
        }
        catch (SAXException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    private static String getElementValue(Node node) {
        Node valueNode;
        if (node.hasChildNodes() && (valueNode = node.getChildNodes().item(0)) != null) {
            return valueNode.getNodeValue();
        }
        return null;
    }

    private static String getAttributeValue(Property property, Node node) {
        if (node.hasAttributes()) {
            NamedNodeMap attributes = node.getAttributes();
            int idx = 0;
            int len = attributes.getLength();
            while (idx < len) {
                Node attrNode = attributes.item(idx);
                if (property.getNamespaceURI().equals(attrNode.getNamespaceURI()) && property.getName().equals(attrNode.getLocalName())) {
                    return attrNode.getNodeValue();
                }
                ++idx;
            }
        }
        return null;
    }

    private static URI createUri(String urlStr) {
        if (urlStr != null && urlStr.length() > 0) {
            try {
                return new URI(urlStr);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return null;
    }

    private static Long parseSizeInToPx(String sizeString) {
        if (sizeString != null) {
            try {
                String numberStr = null;
                numberStr = sizeString.endsWith(Size.SizeUnit.em.toString()) || sizeString.endsWith(Size.SizeUnit.px.toString()) ? sizeString.substring(0, sizeString.length() - 2) : sizeString;
                Long number = Long.parseLong(numberStr);
                if (sizeString.endsWith(Size.SizeUnit.em.toString())) {
                    return number * 12L;
                }
                return number;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    @Deprecated
    public static List<ResourcePreview> parsePreviewsJSON(IHttpClient.IResponse response) throws TeamRepositoryException {
        String content;
        if (response != null && response.getStatusCode() == 200 && (content = response.getContent()) != null && content.length() > 0) {
            try {
                return ResourcePreview.createPreviews((Map<String, Map<String, Object>>)JSONObject.parse((Reader)new StringReader(content)));
            }
            catch (IOException ex) {
                throw new TeamRepositoryException(ex.getMessage(), (Throwable)ex);
            }
        }
        return Collections.emptyList();
    }

    @Deprecated
    public static List<ICompactRenderingRepresentation> parseRepresentationsJSON(IHttpClient.IResponse response) throws TeamRepositoryException {
        String content;
        if (response != null && response.getStatusCode() == 200 && (content = response.getContent()) != null && content.length() > 0) {
            try {
                return ResourcePreview.createCompactRenderingRepresentations((Map<String, Map<String, Object>>)JSONObject.parse((Reader)new StringReader(content)));
            }
            catch (IOException ex) {
                throw new TeamRepositoryException(ex.getMessage(), (Throwable)ex);
            }
        }
        return Collections.emptyList();
    }
}

