/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.links.common.internal.registry;

import com.ibm.team.links.common.internal.registry.EndPointDescriptor;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;

public class LinkTypeEntry
implements ILinkType {
    private final String linkTypeId;
    private final IEndPointDescriptor sourceEndPointDescriptor;
    private final IEndPointDescriptor targetEndPointDescriptor;
    private final boolean constrained;
    private final boolean internal;
    private final String componentId;

    LinkTypeEntry(String linkTypeId, String componentId, boolean constrained, boolean internal, EndPointDescriptor source, EndPointDescriptor target) {
        this.linkTypeId = linkTypeId;
        this.componentId = componentId;
        this.constrained = constrained;
        this.internal = internal;
        this.sourceEndPointDescriptor = source;
        if (source != null) {
            source.setLinkType(this);
        }
        this.targetEndPointDescriptor = target;
        if (target != null) {
            target.setLinkType(this);
        }
    }

    @Override
    public String getLinkTypeId() {
        return this.linkTypeId;
    }

    public String toString() {
        return "LinkTypeEntry for " + this.getLinkTypeId() + ':' + ", source: " + this.getSourceEndPointDescriptor() + ", target: " + this.getTargetEndPointDescriptor();
    }

    @Override
    public IEndPointDescriptor getSourceEndPointDescriptor() {
        return this.sourceEndPointDescriptor;
    }

    @Override
    public IEndPointDescriptor getTargetEndPointDescriptor() {
        return this.targetEndPointDescriptor;
    }

    @Override
    public boolean isConstrained() {
        return this.constrained;
    }

    @Override
    public boolean isInternal() {
        return this.internal;
    }

    @Override
    public String getComponentId() {
        return this.componentId;
    }
}

