/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UnsynchronizedBufferedInputStream
extends FilterInputStream {
    private static final String STREAM_IS_CLOSED = "Stream is closed";
    private byte[] buffer;
    private int pos;
    private int limit;
    private int markLimit;
    private int mark;

    public UnsynchronizedBufferedInputStream(InputStream in) {
        this(in, 8192);
    }

    public UnsynchronizedBufferedInputStream(InputStream in, int bufferSize) {
        super(in);
        this.buffer = new byte[bufferSize];
        this.mark = -1;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer == null) {
            throw new IOException(STREAM_IS_CLOSED);
        }
        if (this.pos == this.limit) {
            int read;
            do {
                if ((read = this.fillBuffer()) != -1) continue;
                return -1;
            } while (read == 0);
        }
        int result = this.buffer[this.pos++] & 0xFF;
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.buffer == null) {
            throw new IOException(STREAM_IS_CLOSED);
        }
        if (len == 0) {
            return 0;
        }
        if (this.pos != this.limit) {
            int toRead = Math.min(len, this.limit - this.pos);
            System.arraycopy(this.buffer, this.pos, b, off, toRead);
            this.pos += toRead;
            return toRead;
        }
        if (this.mark != -1 || this.buffer.length > len) {
            int read = this.fillBuffer();
            if (read == -1) {
                return -1;
            }
            int toRead = Math.min(len, this.limit - this.pos);
            System.arraycopy(this.buffer, this.pos, b, off, toRead);
            this.pos += toRead;
            return toRead;
        }
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.buffer == null) {
            throw new IOException(STREAM_IS_CLOSED);
        }
        if (n <= 0L) {
            return 0L;
        }
        int skipped = (int)Math.min(n, (long)(this.limit - this.pos));
        if (skipped != 0) {
            this.pos += skipped;
            return skipped;
        }
        if (this.mark == -1) {
            return this.in.skip(n);
        }
        if (this.pos - this.mark >= this.markLimit) {
            this.mark = -1;
            return this.in.skip(n);
        }
        this.fillBuffer();
        skipped = (int)Math.min(n, (long)(this.limit - this.pos));
        return skipped;
    }

    private int fillBuffer() throws IOException {
        if (this.mark == -1) {
            this.pos = 0;
            this.limit = 0;
        } else if (this.limit - this.mark >= this.markLimit) {
            this.pos = 0;
            this.limit = 0;
            this.mark = -1;
        } else if (this.mark != 0) {
            System.arraycopy(this.buffer, this.mark, this.buffer, 0, this.limit - this.mark);
            this.pos -= this.mark;
            this.limit -= this.mark;
            this.mark = 0;
        } else if (this.limit == this.buffer.length) {
            byte[] tmp = new byte[Math.min(this.limit * 2, this.markLimit)];
            System.arraycopy(this.buffer, 0, tmp, 0, this.limit);
            this.buffer = tmp;
        }
        int read = this.in.read(this.buffer, this.limit, this.buffer.length - this.limit);
        if (read != -1) {
            this.limit += read;
        }
        return read;
    }

    @Override
    public int available() throws IOException {
        if (this.buffer == null) {
            throw new IOException(STREAM_IS_CLOSED);
        }
        return this.limit - this.pos + this.in.available();
    }

    @Override
    public void close() throws IOException {
        if (this.buffer != null) {
            this.buffer = null;
            InputStream input = this.in;
            this.in = null;
            input.close();
        }
    }

    @Override
    public void mark(int readlimit) {
        this.mark = this.pos;
        this.markLimit = readlimit;
    }

    @Override
    public void reset() throws IOException {
        if (this.buffer == null) {
            throw new IOException(STREAM_IS_CLOSED);
        }
        if (this.mark == -1) {
            throw new IOException("Cannot reset");
        }
        this.pos = this.mark;
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

