/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client;

import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.IProcessReport;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.common.internal.util.WorkItemProcessUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;

public class DetailedStatus
extends MultiStatus
implements IDetailedStatus {
    public static final IDetailedStatus OK_STATUS = new DetailedStatus(0, "com.ibm.team.workitem.client", 0, Status.OK_STATUS.getMessage(), null);
    private String fDescription;
    private IOperationReport fOperationReport;
    private Object fData;

    public DetailedStatus(int severity, String pluginId, int code, String message, Throwable exception) {
        this(severity, pluginId, code, message, null, exception);
    }

    public DetailedStatus(int severity, String pluginId, int code, String message, String description, Throwable exception) {
        super(pluginId, code, message, exception);
        this.setSeverity(severity);
        this.fDescription = description;
    }

    public DetailedStatus(IStatus status) {
        this(status, null);
    }

    public DetailedStatus(IStatus status, IOperationReport operationReport) {
        super(status.getPlugin(), status.getCode(), status.getChildren(), status.getMessage(), status.getException());
        if (status.getChildren().length == 0) {
            this.setSeverity(status.getSeverity());
        }
        this.fOperationReport = operationReport;
    }

    public String getDescription() {
        return this.fDescription;
    }

    @Override
    public IOperationReport getOperationReport() {
        return this.fOperationReport;
    }

    public void setData(Object data) {
        this.fData = data;
    }

    public Object getData() {
        return this.fData;
    }

    @Override
    public void printDetails(PrintWriter writer) {
        writer.print(this.getMessage());
        if (this.getDescription() != null) {
            writer.println();
            writer.print(this.getDescription());
        }
        if (this.getException() != null) {
            writer.println();
            this.getException().printStackTrace(writer);
        }
    }

    @Override
    public String getDetails() {
        StringWriter writer = new StringWriter();
        this.printDetails(new PrintWriter(writer));
        return writer.toString();
    }

    public static IDetailedStatus createFromException(String message, Throwable x) {
        IOperationReport report;
        IReportInfo info;
        if (x.getCause() instanceof CoreException && ((CoreException)x.getCause()).getStatus() != null) {
            return new DetailedStatus(((CoreException)x.getCause()).getStatus());
        }
        if (x instanceof TeamOperationCanceledException && (info = WorkItemProcessUtils.getFirstErrorInfo((IProcessReport)(report = ((TeamOperationCanceledException)x).getReport()))) != null) {
            return new DetailedStatus(4, "com.ibm.team.workitem.client", 2, info.getSummary(), info.getDescription(), x);
        }
        int severity = x instanceof OperationCanceledException ? 8 : 4;
        return new DetailedStatus(severity, "com.ibm.team.workitem.client", 2, message, x);
    }
}

