/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.registry;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.registry.Injectable;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextAccessor {
    public <T> T getContext(Class<T> contextClass, RuntimeContext runtimeContext) {
        T context = this.getContextFromResolver(contextClass, runtimeContext);
        if (context != null) {
            return context;
        }
        return this.getContextFromAccessor(contextClass, runtimeContext);
    }

    public <T> T getContextFromAccessor(final Class<T> contextClass, RuntimeContext runtimeContext) {
        if (runtimeContext != null) {
            try {
                T instance = runtimeContext.getAttribute(contextClass);
                if (instance != null) {
                    return instance;
                }
            }
            catch (Exception e) {
                if (e instanceof InvocationTargetException) {
                    Throwable ite = ((InvocationTargetException)e).getTargetException();
                    if (ite instanceof RuntimeException) {
                        throw (RuntimeException)ite;
                    }
                    throw new WebApplicationException(ite);
                }
                throw new WebApplicationException(e);
            }
        }
        Object proxy = Proxy.newProxyInstance(Injectable.class.getClassLoader(), new Class[]{contextClass}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                RuntimeContext runtimeContext = RuntimeContextTLS.getRuntimeContext();
                if (runtimeContext == null) {
                    if ("toString".equals(method.getName()) && (args == null || args.length == 0)) {
                        return "Proxy for " + contextClass.getName();
                    }
                    throw new IllegalStateException();
                }
                Object context = ContextAccessor.this.getContext(contextClass, runtimeContext);
                return method.invoke(context, args);
            }
        });
        return (T)proxy;
    }

    public <T> T getContextFromResolver(Class<T> contextClass, RuntimeContext runtimeContext) {
        if (runtimeContext == null) {
            return null;
        }
        Providers providers = runtimeContext.getProviders();
        if (providers != null) {
            T context;
            ContextResolver<T> contextResolver;
            HttpHeaders httpHeaders = runtimeContext.getHttpHeaders();
            MediaType mediaType = null;
            if (httpHeaders != null) {
                mediaType = httpHeaders.getMediaType();
            }
            if (mediaType == null) {
                mediaType = MediaType.WILDCARD_TYPE;
            }
            if ((contextResolver = providers.getContextResolver(contextClass, mediaType)) != null && (context = contextResolver.getContext(contextClass)) != null) {
                return context;
            }
        }
        return null;
    }
}

