/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client.oslc.resources;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.wink.client.ClientResponse;
import org.eclipse.lyo.client.oslc.resources.OslcQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OslcQueryResult
implements Iterator<OslcQueryResult> {
    private final OslcQuery query;
    private final ClientResponse response;
    private final int pageNumber;
    private Model rdfModel;
    private Resource infoResource;
    private Resource membersResource;
    private String nextPageUrl = "";
    private boolean rdfInitialized = false;

    public OslcQueryResult(OslcQuery query2, ClientResponse response) {
        this.query = query2;
        this.response = response;
        this.pageNumber = 1;
    }

    private OslcQueryResult(OslcQueryResult prev) {
        this.query = new OslcQuery(prev);
        this.response = this.query.getResponse();
        this.pageNumber = prev.pageNumber + 1;
    }

    private synchronized void initializeRdf() {
        if (!this.rdfInitialized) {
            this.rdfInitialized = true;
            this.rdfModel = ModelFactory.createDefaultModel();
            this.rdfModel.read(this.response.getEntity(InputStream.class), this.query.getCapabilityUrl());
            Property rdfType = this.rdfModel.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type");
            Property responseInfo = this.rdfModel.createProperty("http://open-services.net/ns/core#", "ResponseInfo");
            ResIterator iter = this.rdfModel.listResourcesWithProperty(rdfType, responseInfo);
            this.infoResource = null;
            if (iter.hasNext()) {
                this.infoResource = (Resource)iter.next();
            }
            this.membersResource = this.rdfModel.getResource(this.query.getCapabilityUrl());
        }
    }

    String getNextPageUrl() {
        this.initializeRdf();
        if ((this.nextPageUrl == null || this.nextPageUrl.isEmpty()) && this.infoResource != null) {
            Property predicate = this.rdfModel.getProperty("http://open-services.net/ns/core#", "nextPage");
            SimpleSelector select = new SimpleSelector(this.infoResource, predicate, (RDFNode)null);
            StmtIterator iter = this.rdfModel.listStatements(select);
            if (iter.hasNext()) {
                Statement nextPage = (Statement)iter.next();
                this.nextPageUrl = nextPage.getResource().getURI();
            } else {
                this.nextPageUrl = "";
            }
        }
        return this.nextPageUrl;
    }

    @Override
    public boolean hasNext() {
        return !"".equals(this.getNextPageUrl());
    }

    @Override
    public OslcQueryResult next() {
        return new OslcQueryResult(this);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public OslcQuery getQuery() {
        return this.query;
    }

    public ClientResponse getRawResponse() {
        return this.response;
    }

    public String[] getMembersUrls() {
        this.initializeRdf();
        ArrayList<String> membersUrls = new ArrayList<String>();
        SimpleSelector select = new SimpleSelector(this.membersResource, (Property)null, (RDFNode)null);
        StmtIterator iter = this.rdfModel.listStatements(select);
        while (iter.hasNext()) {
            Statement member = (Statement)iter.next();
            try {
                String fqPredicateName = member.getPredicate().getNameSpace() + member.getPredicate().getLocalName();
                if (fqPredicateName == null || fqPredicateName.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) continue;
                membersUrls.add(member.getResource().getURI());
            }
            catch (Throwable t) {
                System.err.println("Member was not a resource");
            }
        }
        return membersUrls.toArray(new String[membersUrls.size()]);
    }
}

