/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.common.internal.setup.builders;

import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.internal.setup.builders.IProcessBuilderContext;
import com.ibm.team.process.internal.common.service.IProcessService;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class Processes {
    public static final Scrum SCRUM = new Scrum();
    public static final OpenUp OPEN_UP = new OpenUp();
    public static final Formal FORMAL = new Formal();
    public static final Simple SIMPLE = new Simple();
    public static final Unconfigured UNCONFIGURED = new Unconfigured();
    private String fId;

    private Processes(String id) {
        this.fId = id;
    }

    public String getId() {
        return this.fId;
    }

    public boolean isPredefined() {
        return false;
    }

    public void save(IProcessBuilderContext context) throws TeamRepositoryException {
        throw new RuntimeException("Can only save a Process from a zip file");
    }

    public static Processes fromZip(final String id, final URL zipFile) {
        return new Processes(id){

            @Override
            public void save(IProcessBuilderContext context) throws TeamRepositoryException {
                IProcessService service = context.getLibrary(IProcessService.class);
                service.saveProcessDefinitionImportWithParticipants(this.getContent(context, zipFile), id, id, true, "JTS-Sentinel-Id");
            }

            private IContent getContent(IProcessBuilderContext context, URL url) throws TeamRepositoryException {
                InputStream input = null;
                try {
                    int read;
                    URLConnection connection = url.openConnection();
                    input = connection.getInputStream();
                    BufferedInputStream reader = new BufferedInputStream(input);
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((read = reader.read(buffer)) >= 0) {
                        output.write(buffer, 0, read);
                    }
                    output.close();
                    IContent iContent = context.storeContent("application/unknown", null, output.toByteArray());
                    return iContent;
                }
                catch (IOException x) {
                    throw new TeamRepositoryException((Throwable)x);
                }
                finally {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException x) {
                        throw new TeamRepositoryException((Throwable)x);
                    }
                }
            }
        };
    }

    static Processes fromId(String id) {
        return new Processes(id){

            @Override
            public boolean isPredefined() {
                return true;
            }
        };
    }

    private static IRole toRole(String roleId) {
        return Processes.toRole(roleId, 0);
    }

    private static IRole toRole(final String roleId, final int cardinality) {
        return new IRole(){

            public String getId() {
                return roleId;
            }

            public String getDescription() {
                return roleId;
            }

            public int getCardinality() {
                return cardinality;
            }
        };
    }

    /* synthetic */ Processes(String string, Processes processes) {
        this(string);
    }

    public static class Formal
    extends Processes {
        public Formal() {
            super("formalpm.process.ibm.com", null);
        }

        public IRole Analyst() {
            return Processes.toRole("analyst");
        }

        public IRole Architect() {
            return Processes.toRole("architect", 1);
        }

        public IRole Developer() {
            return Processes.toRole("developer");
        }

        public IRole ProjectManager() {
            return Processes.toRole("project_manager", 1);
        }

        public IRole TeamLead() {
            return Processes.toRole("team_lead");
        }

        public IRole StakeHolder() {
            return Processes.toRole("stakeholder");
        }

        public IRole Tester() {
            return Processes.toRole("tester");
        }

        public IRole ReleaseEnginer() {
            return Processes.toRole("release_engineer");
        }

        public IRole Default() {
            return Processes.toRole("default");
        }

        @Override
        public boolean isPredefined() {
            return true;
        }
    }

    public static class OpenUp
    extends Processes {
        public OpenUp() {
            super("openup.process.eclipse.org", null);
        }

        @Override
        public boolean isPredefined() {
            return true;
        }
    }

    public static class Scrum
    extends Processes {
        public Scrum() {
            super("scrum2.process.ibm.com", null);
        }

        public IRole ProductOwner() {
            return Processes.toRole("Product Owner", 1);
        }

        public IRole ScrumMaster() {
            return Processes.toRole("ScrumMaster", 1);
        }

        public IRole TeamMember() {
            return Processes.toRole("Team Member");
        }

        public IRole StakeHolder() {
            return Processes.toRole("Stakeholder");
        }

        public IRole Default() {
            return Processes.toRole("default");
        }

        @Override
        public boolean isPredefined() {
            return true;
        }
    }

    public static class Simple
    extends Processes {
        public Simple() {
            super("simple.process.ibm.com", null);
        }

        @Override
        public boolean isPredefined() {
            return true;
        }
    }

    public static class Unconfigured
    extends Processes {
        public Unconfigured() {
            super("unconfigured.process.ibm.com", null);
        }

        @Override
        public boolean isPredefined() {
            return true;
        }
    }
}

