/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.links.client.internal;

import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.client.internal.LinkEvent;
import com.ibm.team.links.client.internal.LinkUtils;
import com.ibm.team.links.client.internal.Messages;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkQueryPage;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.links.common.internal.AuditableLinkUtils;
import com.ibm.team.links.common.internal.IBaseLinkService;
import com.ibm.team.links.common.internal.IRemoteLinkService;
import com.ibm.team.links.common.internal.LinkQueryPage;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;

public class AuditableLinkManager
extends EventSource
implements ILinkManager {
    public static final Log logger = LogFactory.getLog(AuditableLinkManager.class);
    private final IRemoteLinkService linkService;
    private final IReferenceFactory refFactory = IReferenceFactory.INSTANCE;
    private final IClientLibraryContext context;

    @Override
    public IReferenceFactory referenceFactory() {
        return this.refFactory;
    }

    public AuditableLinkManager(IClientLibraryContext context) {
        this.context = context;
        this.linkService = (IRemoteLinkService)context.getServiceInterface(IRemoteLinkService.class);
    }

    @Override
    public ILink createLink(String linkTypeId, IReference source, IReference target) throws IllegalArgumentException {
        return AuditableLinkUtils.INSTANCE.createLink(linkTypeId, source, target);
    }

    @Override
    public ILink createLink(String linkTypeId, IReference endPoint1, String endPoint2Id, IReference endPoint2) throws TeamRepositoryException {
        return AuditableLinkUtils.INSTANCE.createLink(linkTypeId, endPoint1, endPoint2Id, endPoint2);
    }

    @Override
    public void saveLink(final ILink link, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SavingLink"), 100);
                try {
                    AuditableLinkManager.this.acquire();
                    AuditableLinkManager.this.linkService().saveAuditableLink(link);
                    AuditableLinkManager.this.queueLinkEvent("com.ibm.team.links.LinkSaveEvent", link);
                    return null;
                }
                finally {
                    AuditableLinkManager.this.release();
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public void applySavedLinks(Collection<ILink> links) {
        if (links.isEmpty()) {
            return;
        }
        try {
            this.acquire();
            this.queueLinkEvents("com.ibm.team.links.LinkSaveEvent", links);
        }
        finally {
            this.release();
        }
    }

    @Override
    public void saveLinks(final Collection<ILink> links, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor mon) throws TeamRepositoryException {
                if (links.isEmpty()) {
                    return null;
                }
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SavingLinks"), 100);
                try {
                    AuditableLinkManager.this.acquire();
                    AuditableLinkUtils.INSTANCE.saveLinks(links, (IBaseLinkService)AuditableLinkManager.this.linkService());
                    AuditableLinkManager.this.queueLinkEvents("com.ibm.team.links.LinkSaveEvent", links);
                    return null;
                }
                finally {
                    AuditableLinkManager.this.release();
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public void deleteLink(final ILink link, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.DeletingLink"), 100);
                try {
                    AuditableLinkManager.this.acquire();
                    AuditableLinkManager.this.linkService().deleteAuditableLink(link);
                    AuditableLinkManager.this.queueLinkEvent("com.ibm.team.links.LinkDeletedEvent", link);
                    return null;
                }
                finally {
                    AuditableLinkManager.this.release();
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public void deleteLinks(final Collection<ILink> links, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor mon) throws TeamRepositoryException {
                if (links.isEmpty()) {
                    return null;
                }
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.DeletingLinks"), 100);
                try {
                    AuditableLinkManager.this.acquire();
                    AuditableLinkUtils.INSTANCE.deleteLinks(links, (IBaseLinkService)AuditableLinkManager.this.linkService());
                    AuditableLinkManager.this.queueLinkEvents("com.ibm.team.links.LinkDeletedEvent", links);
                    return null;
                }
                finally {
                    AuditableLinkManager.this.release();
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public void applyDeletedLinks(Collection<ILink> links) {
        if (links.isEmpty()) {
            return;
        }
        try {
            this.acquire();
            this.queueLinkEvents("com.ibm.team.links.LinkDeletedEvent", links);
        }
        finally {
            this.release();
        }
    }

    @Override
    public ILinkQueryPage findLinks(final IReference endpoint, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ILinkQueryPage>(){

            @Override
            public ILinkQueryPage run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SearchingForLinks"), 100);
                try {
                    Object[] result = AuditableLinkManager.this.linkService().findAuditableLinksByEndpoint(endpoint);
                    LinkQueryPage linkQueryPage = new LinkQueryPage(result);
                    return linkQueryPage;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public ILinkQueryPage findLinks(final String linkTypeId, final IReference endpoint, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ILinkQueryPage>(){

            @Override
            public ILinkQueryPage run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SearchingForLinks"), 100);
                try {
                    Object[] result = AuditableLinkManager.this.linkService().findAuditableLinksByNameByEndpoint(linkTypeId, endpoint);
                    LinkQueryPage linkQueryPage = new LinkQueryPage(result);
                    return linkQueryPage;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public ILinkQueryPage findLinks(final String[] linkTypeIds, final IReference endpoint, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ILinkQueryPage>(){

            @Override
            public ILinkQueryPage run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SearchingForLinks"), 100);
                try {
                    Object[] result = AuditableLinkManager.this.linkService().findAuditableLinksByNamesByEndpoint(linkTypeIds, endpoint);
                    LinkQueryPage linkQueryPage = new LinkQueryPage(result);
                    return linkQueryPage;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public ILinkQueryPage findLinksByItemType(final String[] linkTypeIds, final IItemType itemType, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ILinkQueryPage>(){

            @Override
            public ILinkQueryPage run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SearchingForLinks"), 100);
                try {
                    Object[] result = AuditableLinkManager.this.linkService().findAuditableLinksByNamesByItemType(linkTypeIds, itemType);
                    LinkQueryPage linkQueryPage = new LinkQueryPage(result);
                    return linkQueryPage;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public ILinkQueryPage findLinks(final String[] linkTypeIds, final IReference[] endpoints, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ILinkQueryPage>(){

            @Override
            public ILinkQueryPage run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SearchingForLinks"), 100);
                try {
                    Object[] result = AuditableLinkManager.this.linkService().findAuditableLinksByNamesByEndpoints(linkTypeIds, endpoints);
                    LinkQueryPage linkQueryPage = new LinkQueryPage(result);
                    return linkQueryPage;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public ILinkQueryPage findLinksBySource(final IReference source, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ILinkQueryPage>(){

            @Override
            public ILinkQueryPage run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SearchingForLinks"), 100);
                try {
                    Object[] result = AuditableLinkManager.this.linkService().findAuditableLinksBySource(source);
                    LinkQueryPage linkQueryPage = new LinkQueryPage(result);
                    return linkQueryPage;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public ILinkQueryPage findLinksBySource(final IReference source, final boolean ignoreUriQueryParams, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ILinkQueryPage>(){

            @Override
            public ILinkQueryPage run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SearchingForLinks"), 100);
                try {
                    Object[] result = AuditableLinkManager.this.linkService().findAuditableLinksBySourceByUriQryPrm(source, ignoreUriQueryParams);
                    LinkQueryPage linkQueryPage = new LinkQueryPage(result);
                    return linkQueryPage;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public ILinkQueryPage findLinksBySource(final String linkTypeId, final IReference source, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ILinkQueryPage>(){

            @Override
            public ILinkQueryPage run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SearchingForLinks"), 100);
                try {
                    Object[] result = AuditableLinkManager.this.linkService().findAuditableLinksByNamesBySource(new String[]{linkTypeId}, source);
                    LinkQueryPage linkQueryPage = new LinkQueryPage(result);
                    return linkQueryPage;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public ILinkQueryPage findLinksBySource(final String[] linkTypeIds, final IReference source, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ILinkQueryPage>(){

            @Override
            public ILinkQueryPage run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SearchingForLinks"), 100);
                try {
                    Object[] result = AuditableLinkManager.this.linkService().findAuditableLinksByNamesBySource(linkTypeIds, source);
                    LinkQueryPage linkQueryPage = new LinkQueryPage(result);
                    return linkQueryPage;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public ILinkQueryPage findLinksBySource(final String[] linkTypeIds, final IReference[] sources, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ILinkQueryPage>(){

            @Override
            public ILinkQueryPage run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SearchingForLinks"), 100);
                try {
                    Object[] result = AuditableLinkManager.this.linkService().findAuditableLinksByNamesBySources(linkTypeIds, sources);
                    LinkQueryPage linkQueryPage = new LinkQueryPage(result);
                    return linkQueryPage;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public ILinkQueryPage findLinksByTargetItemType(final String[] linkTypeIds, final IItemType targetItemType, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ILinkQueryPage>(){

            @Override
            public ILinkQueryPage run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SearchingForLinks"), 100);
                try {
                    Object[] result = AuditableLinkManager.this.linkService().findAuditableLinksByNamesByTargetItemType(linkTypeIds, targetItemType);
                    LinkQueryPage linkQueryPage = new LinkQueryPage(result);
                    return linkQueryPage;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public ILinkQueryPage findLinksByTarget(final IReference target, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ILinkQueryPage>(){

            @Override
            public ILinkQueryPage run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SearchingForLinks"), 100);
                try {
                    Object[] result = AuditableLinkManager.this.linkService().findAuditableLinksByTarget(target);
                    LinkQueryPage linkQueryPage = new LinkQueryPage(result);
                    return linkQueryPage;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public ILinkQueryPage findLinksByTarget(final IReference target, final boolean ignoreUriQueryParams, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ILinkQueryPage>(){

            @Override
            public ILinkQueryPage run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SearchingForLinks"), 100);
                try {
                    IReference[] targets = new IReference[]{target};
                    Object[] result = AuditableLinkManager.this.linkService().findAuditableLinks(null, false, null, null, false, targets, null, ignoreUriQueryParams);
                    LinkQueryPage linkQueryPage = new LinkQueryPage(result);
                    return linkQueryPage;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public ILinkQueryPage findLinksByTarget(final String linkTypeId, final IReference target, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ILinkQueryPage>(){

            @Override
            public ILinkQueryPage run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SearchingForLinks"), 100);
                try {
                    Object[] result = AuditableLinkManager.this.linkService().findAuditableLinksByNamesByTarget(new String[]{linkTypeId}, target);
                    LinkQueryPage linkQueryPage = new LinkQueryPage(result);
                    return linkQueryPage;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public ILinkQueryPage findLinksByTarget(final String[] linkTypeIds, final IReference target, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ILinkQueryPage>(){

            @Override
            public ILinkQueryPage run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SearchingForLinks"), 100);
                try {
                    Object[] result = AuditableLinkManager.this.linkService().findAuditableLinksByNamesByTarget(linkTypeIds, target);
                    LinkQueryPage linkQueryPage = new LinkQueryPage(result);
                    return linkQueryPage;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public ILinkQueryPage findLinksBySourceItemType(final String[] linkTypeIds, final IItemType sourceItemType, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ILinkQueryPage>(){

            @Override
            public ILinkQueryPage run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SearchingForLinks"), 100);
                try {
                    Object[] result = AuditableLinkManager.this.linkService().findAuditableLinksByNamesBySourceItemType(linkTypeIds, sourceItemType);
                    LinkQueryPage linkQueryPage = new LinkQueryPage(result);
                    return linkQueryPage;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public ILinkQueryPage findLinksByTarget(final String[] linkTypeIds, final IReference[] targets, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ILinkQueryPage>(){

            @Override
            public ILinkQueryPage run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SearchingForLinks"), 100);
                try {
                    Object[] result = AuditableLinkManager.this.linkService().findAuditableLinksByNamesByTargets(linkTypeIds, targets);
                    LinkQueryPage linkQueryPage = new LinkQueryPage(result);
                    return linkQueryPage;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public ILinkQueryPage findLinks(final String[] linkTypeIds, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ILinkQueryPage>(){

            @Override
            public ILinkQueryPage run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SearchingForLinks"), 100);
                try {
                    Object[] result = AuditableLinkManager.this.linkService().findAuditableLinksByNames(linkTypeIds);
                    LinkQueryPage linkQueryPage = new LinkQueryPage(result);
                    return linkQueryPage;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public ILinkQueryPage findLinks(final IItemReference[] endpoints, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ILinkQueryPage>(){

            @Override
            public ILinkQueryPage run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SearchingForLinks"), 100);
                try {
                    Object[] result = AuditableLinkManager.this.linkService().findAuditableLinksByReferences(endpoints);
                    LinkQueryPage linkQueryPage = new LinkQueryPage(result);
                    return linkQueryPage;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public ILinkQueryPage findLinks(final String[] linkTypeIds, final boolean requireSourceAndTarget, final IReference[] sourceReferences, final IItemType sourceItemType, final boolean ignoreSourceUriQueryParams, final IReference[] targetReferences, final IItemType targetItemType, final boolean ignoreTargetUriQueryParams, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ILinkQueryPage>(){

            @Override
            public ILinkQueryPage run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SearchingForLinks"), 100);
                try {
                    Object[] result = AuditableLinkManager.this.linkService().findAuditableLinks(linkTypeIds, requireSourceAndTarget, sourceReferences, sourceItemType, ignoreSourceUriQueryParams, targetReferences, targetItemType, ignoreTargetUriQueryParams);
                    LinkQueryPage linkQueryPage = new LinkQueryPage(result);
                    return linkQueryPage;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    private IRemoteLinkService linkService() throws TeamRepositoryException {
        if (this.linkService == null) {
            throw new TeamRepositoryException(Messages.getServerString("_NoId.AuditableLinkManager.ServiceNotFound"));
        }
        return this.linkService;
    }

    private void queueLinkEvent(String eventType, ILink link) {
        this.queueEvent(new LinkEvent(this, eventType, link));
    }

    private void queueLinkEvents(String eventType, Collection<ILink> links) {
        for (ILink link : links) {
            this.queueEvent(new LinkEvent(this, eventType, link));
        }
    }

    @Override
    public ILinkQueryPage followLinks(final boolean up, final boolean down, final String[] linkTypeIds, final IItemHandle[] initialHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ILinkQueryPage>(){

            @Override
            public ILinkQueryPage run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = LinkUtils.getMonitor(mon, Messages.getServerString("_NoId.AuditableLinkManager.SearchingForLinks"), 100);
                try {
                    Object[] result = AuditableLinkManager.this.linkService().followLinks(up, down, linkTypeIds, initialHandles);
                    LinkQueryPage linkQueryPage = new LinkQueryPage(result);
                    return linkQueryPage;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    private <T> T callCancelableService(IClientLibraryContext.IServiceRunnable<T> runnable, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.context.callCancelableService(runnable, monitor);
    }
}

