/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.common.IContributorIdentity;
import com.ibm.team.repository.common.IContributorRecord;
import com.ibm.team.repository.common.UUID;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;

public class ContributorIdentityCache {
    private final HashMap<UUID, ContributorRecordReference> cache = new HashMap();
    private final ReferenceQueue<IContributorRecord> queue = new ReferenceQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(IContributorRecord contributorRecord) {
        HashMap<UUID, ContributorRecordReference> hashMap = this.cache;
        synchronized (hashMap) {
            ContributorRecordReference crr = this.cache.get(contributorRecord.getItemId());
            if (crr != null && crr.get() != contributorRecord) {
                this.cache.remove(crr.itemId);
                for (UUID id : crr.identities) {
                    this.cache.remove(id);
                }
                crr = null;
            }
            if (crr == null) {
                crr = new ContributorRecordReference(contributorRecord, this.queue);
                this.cache.put(contributorRecord.getItemId(), crr);
                for (UUID id : crr.identities) {
                    this.cache.put(id, crr);
                }
            } else {
                HashSet<UUID> oldUUIDs = new HashSet<UUID>(crr.identities);
                for (Object o : contributorRecord.getIdentities()) {
                    IContributorIdentity ident = (IContributorIdentity)o;
                    UUID id = ident.getId();
                    oldUUIDs.remove(id);
                    crr.identities.add(id);
                    this.cache.put(id, crr);
                }
                for (UUID id : oldUUIDs) {
                    this.cache.remove(id);
                }
            }
            this.scrub();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContributorRecord(UUID contirbutorRecord) {
        HashMap<UUID, ContributorRecordReference> hashMap = this.cache;
        synchronized (hashMap) {
            ContributorRecordReference crr = this.cache.remove(contirbutorRecord);
            if (crr == null) {
                return;
            }
            for (UUID id : crr.identities) {
                this.cache.remove(id);
            }
            this.scrub();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContributorRecord get(UUID identity) {
        IContributorRecord result;
        HashMap<UUID, ContributorRecordReference> hashMap = this.cache;
        synchronized (hashMap) {
            ContributorRecordReference r = this.cache.get(identity);
            result = r == null ? null : (IContributorRecord)r.get();
            this.scrub();
        }
        return result;
    }

    private void scrub() {
        ContributorRecordReference r;
        while ((r = (ContributorRecordReference)this.queue.poll()) != null) {
            this.cache.remove(r.itemId);
            for (UUID id : r.identities) {
                this.cache.remove(id);
            }
        }
    }

    private static final class ContributorRecordReference
    extends SoftReference<IContributorRecord> {
        public final UUID itemId;
        public final HashSet<UUID> identities;

        public ContributorRecordReference(IContributorRecord contributorRecord, ReferenceQueue<IContributorRecord> queue) {
            super(contributorRecord, queue);
            this.itemId = contributorRecord.getItemId();
            this.identities = new HashSet();
            for (Object o : contributorRecord.getIdentities()) {
                IContributorIdentity id = (IContributorIdentity)o;
                this.identities.add(id.getId());
            }
        }
    }
}

