/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal.util;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.Auditable;
import com.ibm.team.repository.common.model.Item;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.repository.common.model.SimpleItem;
import com.ibm.team.repository.common.util.NLS;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ClientUtil {
    static final double[] statisticalDivisors = new double[]{1024.0, 1048576.0, 1.073741824E9, 1.099511627776E12, 1.125899906842624E15};
    static final String[] statisticalSuffixes = new String[]{"KB", "MB", "GB", "TB", "PB"};

    public static IProgressMonitor getMonitor(IProgressMonitor monitor) {
        return monitor == null ? new NullProgressMonitor() : monitor;
    }

    public static IProgressMonitor beginMonitor(IProgressMonitor monitor, String name, int totalWork) {
        monitor = ClientUtil.getMonitor(monitor);
        monitor.beginTask(name, totalWork);
        return monitor;
    }

    public static IProgressMonitor beginMonitor(IProgressMonitor monitor, int totalWork) {
        monitor = ClientUtil.getMonitor(monitor);
        monitor.beginTask("", totalWork);
        return monitor;
    }

    public static void makeImmutable(ITeamRepository repository, IItemHandle itemHandle) {
        ClientUtil.makeImmutable(repository, (EObject)itemHandle, new IdentityHashMap());
    }

    public static void makeImmutable(ITeamRepository repository, EObject eObject) {
        ClientUtil.makeImmutable(repository, eObject, new IdentityHashMap());
    }

    public static void makeImmutable(ITeamRepository repository, Collection objects) {
        IdentityHashMap visited = new IdentityHashMap();
        for (Object object : objects) {
            if (!(object instanceof EObject)) continue;
            ClientUtil.makeImmutable(repository, (EObject)object, visited);
        }
    }

    public static void makeImmutable(ITeamRepository repository, Object[] objects) {
        IdentityHashMap visited = new IdentityHashMap();
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (object instanceof EObject) {
                ClientUtil.makeImmutable(repository, (EObject)object, visited);
            }
            ++i;
        }
    }

    public static void fixWorkingCopy(Auditable workingCopy, UUID newStateId) {
        workingCopy.setWorkingCopy(false);
        workingCopy.setWorkingCopyPredecessor(null);
        workingCopy.setWorkingCopyMergePredecessor(null);
        if (workingCopy.isPropertySet(IItem.MODIFIED_BY_PROPERTY)) {
            workingCopy.setModifiedBy(null);
        }
        if (workingCopy.isPropertySet(IItem.MODIFIED_PROPERTY)) {
            workingCopy.setModified(null);
        }
        if (workingCopy.isPropertySet(IAuditable.PREDECESSOR_STATE_PROPERTY)) {
            workingCopy.setPredecessor(null);
        }
        if (workingCopy.isPropertySet(IAuditable.MERGE_PREDECESSOR_STATE_PROPERTY)) {
            workingCopy.setMergePredecessor(null);
        }
        if (workingCopy.isPropertySet(IItem.STATE_ID_PROPERTY)) {
            workingCopy.setStateId(newStateId);
        }
    }

    public static void fixWorkingCopy(SimpleItem workingCopy) {
        workingCopy.setWorkingCopy(false);
        if (workingCopy.isPropertySet(IItem.MODIFIED_BY_PROPERTY)) {
            workingCopy.setModifiedBy(null);
        }
        if (workingCopy.isPropertySet(IItem.MODIFIED_PROPERTY)) {
            workingCopy.setModified(null);
        }
    }

    public static void detachItems(EObject eObject) {
        EClass type = null;
        for (EReference containment : eObject.eClass().getEAllContainments()) {
            if (!eObject.eIsSet((EStructuralFeature)containment)) continue;
            type = ItemUtil.getTargetClassIfFacade((EReference)containment);
            if (RepositoryPackage.eINSTANCE.getItemHandle().isSuperTypeOf(type)) {
                eObject.eUnset((EStructuralFeature)containment);
                continue;
            }
            if (containment.isMany()) {
                EList children = (EList)eObject.eGet((EStructuralFeature)containment);
                if (children == null) continue;
                for (EObject child : children) {
                    if (child == null) continue;
                    ClientUtil.detachItems(child);
                }
                continue;
            }
            EObject child = (EObject)eObject.eGet((EStructuralFeature)containment);
            if (child == null) continue;
            ClientUtil.detachItems(child);
        }
    }

    public static String bytesAsHumanReadable(long amt) {
        int i = statisticalDivisors.length - 1;
        while (i >= 0) {
            if ((double)amt > statisticalDivisors[i]) {
                return String.format("%,.1f %s", (double)amt / statisticalDivisors[i], statisticalSuffixes[i]);
            }
            --i;
        }
        return NLS.bind((String)"{0} B", (Object)amt, (Object[])new Object[0]);
    }

    private static void makeImmutable(ITeamRepository repository, EObject eObject, Map visited) {
        if (visited.containsKey(eObject)) {
            return;
        }
        visited.put(eObject, null);
        if (eObject instanceof ItemHandle) {
            ItemHandle itemHandle = (ItemHandle)eObject;
            itemHandle.setOrigin((Object)repository);
            if (itemHandle instanceof Item) {
                Item item = (Item)itemHandle;
                if (!item.isWorkingCopy()) {
                    item.makeImmutable();
                }
                item.protect();
            } else {
                itemHandle.makeImmutable();
                itemHandle.protect();
            }
        }
        Iterator i = eObject.eContents().iterator();
        while (i.hasNext()) {
            ClientUtil.makeImmutable(repository, (EObject)i.next(), visited);
        }
        i = eObject.eCrossReferences().iterator();
        while (i.hasNext()) {
            ClientUtil.makeImmutable(repository, (EObject)i.next(), visited);
        }
    }
}

