/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.framework;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.jayway.restassured.specification.RequestSpecification;
import com.urbancode.commons.util.query.QueryFilter;
import com.urbancode.release.rest.framework.ClientEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class QueryParams<T extends ClientEntity> {
    protected ClientEntity<T> source;
    protected String format;
    protected String orderField;
    protected boolean asc = true;
    protected List<FilterWithClass> filters = new ArrayList<FilterWithClass>();
    protected Multimap<String, String> params = HashMultimap.create();

    public QueryParams() {
    }

    public QueryParams(ClientEntity<T> source) {
        this.source = source;
    }

    public QueryParams(ClientEntity<T> source, QueryParams<?> other) {
        this.source = source;
        this.format = other.format;
        this.orderField = other.orderField;
        this.asc = other.asc;
        this.filters = other.filters;
        this.params = other.params;
    }

    public ClientEntity<T> when() {
        return this.source;
    }

    public QueryParams<T> format(String format) {
        this.format = format;
        return this;
    }

    public QueryParams<T> nameFormat() {
        return this.format("name").orderBy("name");
    }

    public QueryParams<T> listFormat() {
        return this.format("list");
    }

    public QueryParams<T> detailFormat() {
        return this.format("detail");
    }

    public QueryParams<T> orderBy(String orderField) {
        return this.orderBy(orderField, true);
    }

    public QueryParams<T> orderBy(String orderField, boolean asc) {
        this.orderField = orderField;
        this.asc = asc;
        return this;
    }

    public QueryParams<T> filter(String field, FilterClass filterClass, QueryFilter.FilterType type, Object ... values) {
        this.filters.add(new FilterWithClass(field, filterClass, type, Arrays.asList(values)));
        return this;
    }

    public QueryParams<T> like(String field, String like) {
        return this.filter(field, FilterClass.STRING, QueryFilter.FilterType.LIKE, like);
    }

    public QueryParams<T> equals(String field, FilterClass filterClass, String match) {
        return this.filter(field, filterClass, QueryFilter.FilterType.EQUALS, match);
    }

    public QueryParams<T> param(String name, String ... values) {
        if (values == null) {
            return this;
        }
        for (String value : values) {
            if (value == null) continue;
            this.params.put(name, value);
        }
        return this;
    }

    public Multimap<String, String> allParams() {
        HashMultimap<String, String> combinedParams = HashMultimap.create();
        if (this.format != null && !"".equals(this.format)) {
            combinedParams.put("format", this.format);
        }
        if (this.orderField != null) {
            combinedParams.put("orderField", this.orderField);
            combinedParams.put("sortType", this.asc ? "asc" : "desc");
        }
        ArrayList<String> fields = new ArrayList<String>(this.filters.size());
        for (FilterWithClass filter : this.filters) {
            String name = filter.getFieldName();
            fields.add(name);
            combinedParams.put("filterType_" + name, filter.getFilterType().getParamString());
            for (Object value : filter.getValues()) {
                combinedParams.put("filterValue_" + name, value.toString());
            }
            combinedParams.put("filterClass_" + name, filter.filterClass.toString());
        }
        combinedParams.putAll("filterFields", fields);
        combinedParams.putAll(this.params);
        return combinedParams;
    }

    public RequestSpecification apply(RequestSpecification rs) {
        Multimap<String, String> query = this.allParams();
        for (String key : query.keySet()) {
            rs.param(key, query.get(key));
        }
        return rs;
    }

    public static class FilterWithClass
    extends QueryFilter.Filter {
        public FilterClass filterClass;

        public FilterWithClass(String fieldName, FilterClass filterClass, QueryFilter.FilterType filterType, Collection<Object> values) {
            super(fieldName, filterType, values);
            this.filterClass = filterClass;
        }
    }

    public static enum FilterClass {
        BOOLEAN("Boolean"),
        LONG("Long"),
        STRING("String"),
        UUID("UUID"),
        ENUM("Enum"),
        DATE("Date");

        String paramString;

        private FilterClass(String paramString) {
            this.paramString = paramString;
        }

        public String toString() {
            return this.paramString;
        }
    }
}

