/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.urbancode.release.rest.framework.ClientEntity;
import com.urbancode.release.rest.models.User;
import com.urbancode.release.rest.models.internal.DeploymentExecution;
import com.urbancode.release.rest.models.internal.Role;
import com.urbancode.release.rest.models.internal.SegmentExecution;
import com.urbancode.release.rest.models.internal.TaskExecution;

public class DeploymentNotification
extends ClientEntity<DeploymentNotification> {
    public String targetType;
    public String eventType;
    public Integer minutes;
    public String timeUnit;
    public String filterType;
    public User user;
    public Role role;
    public DeploymentExecution deploymentExecution;
    public TaskExecution[] tasks;
    public SegmentExecution[] segments;

    public DeploymentNotification() {
        this.path = "/deploymentNotification/";
        this.minutes = 0;
        this.timeUnit = "MINUTES_AFTER";
        this.filterType = "ALWAYS";
    }

    public DeploymentNotification targetType(String targetType) {
        this.targetType = targetType;
        return this;
    }

    public DeploymentNotification eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public DeploymentNotification minutes(Integer minutes) {
        this.minutes = minutes;
        return this;
    }

    public DeploymentNotification timeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
        return this;
    }

    public DeploymentNotification filterType(String filterType) {
        this.filterType = filterType;
        return this;
    }

    public DeploymentNotification user(User user) {
        this.handleNull(user, "user");
        this.user = user;
        return this;
    }

    public DeploymentNotification role(Role role) {
        this.handleNull(role, "role");
        this.role = role;
        return this;
    }

    public DeploymentNotification deploymentExecution(DeploymentExecution deploymentExecution) {
        this.handleNull(deploymentExecution, "deploymentExecution");
        this.deploymentExecution = deploymentExecution;
        return this;
    }

    public DeploymentNotification tasks(TaskExecution ... tasks) {
        this.handleNull(tasks, "tasks");
        this.tasks = tasks;
        return this;
    }

    public DeploymentNotification segments(SegmentExecution ... segments) {
        this.handleNull(segments, "segments");
        this.segments = segments;
        return this;
    }
}

