/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.framework.ClientWithPropertySheet;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.internal.JiraIntegrationProvider;
import com.urbancode.release.rest.models.internal.PluginIntegrationProvider;
import com.urbancode.release.rest.models.internal.RTCIntegrationProvider;
import com.urbancode.release.rest.models.internal.UCDIntegrationProvider;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class IntegrationProvider<T extends IntegrationProvider>
extends ClientWithPropertySheet<T> {
    public IntegrationProviderType integrationType;
    public Integer frequency;
    @JsonReadOnly
    public Long lastExecution;
    @JsonReadOnly
    public String lastExecutionReport;
    @JsonReadOnly
    public String lastExecutionStatus;
    @JsonReadOnly
    public String currentState;

    public IntegrationProvider() {
        this.path = "/integrationProvider/";
        this.frequency = 0;
    }

    @Override
    public Response delete() {
        log.debug("IntegrationProvider delete()");
        ((Response)RestAssured.given().formParam("integrationProviderId", this.id).post(this.path() + "deleteAll", new Object[0])).then().statusCode(200);
        return super.delete();
    }

    public List<String> getDisabledFields(String entityName) {
        ArrayList<String> result = new ArrayList<String>();
        String prefix = "disabled:" + entityName + ":";
        for (String propName : this.propertyValues.keySet()) {
            if (!propName.startsWith(prefix) || !((String)this.propertyValues.get(propName)).equals("disabled")) continue;
            result.add(propName.substring(prefix.length()));
        }
        return result;
    }

    public IntegrationProvider<T> frequency(Integer minutes) {
        this.frequency = minutes;
        return this;
    }

    public IntegrationProvider<T> manual() {
        this.frequency = 0;
        return this;
    }

    public IntegrationProvider<T> daily() {
        this.frequency = 1440;
        return this;
    }

    public T disabledFields(String entityName, String ... fieldNames) {
        String prefix = "disabled:" + entityName + ":";
        for (String propName : this.propertyValues.keySet()) {
            if (!propName.startsWith(prefix)) continue;
            this.property(propName, "enabled");
        }
        for (String fieldName : fieldNames) {
            this.property(prefix + fieldName, "disabled");
        }
        return (T)this;
    }

    public T run() {
        RestAssured.given().formParam("integrationProviderId", this.id).post("/integrationProvider/execute", new Object[0]);
        return (T)this;
    }

    public static class Deserializer
    implements JsonDeserializer<IntegrationProvider> {
        @Override
        public IntegrationProvider deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonNull()) {
                return null;
            }
            if (json.isJsonPrimitive()) {
                return (IntegrationProvider)new IntegrationProvider().id(json.getAsString());
            }
            if (json.isJsonObject()) {
                JsonObject jo = json.getAsJsonObject();
                if (jo.has("integrationType")) {
                    IntegrationProviderType ipType = (IntegrationProviderType)((Object)context.deserialize(jo.get("integrationType"), (Type)((Object)IntegrationProviderType.class)));
                    return (IntegrationProvider)context.deserialize(jo, ipType.clientClass);
                }
                if (jo.has("id")) {
                    return (IntegrationProvider)new IntegrationProvider().id(jo.get("id").getAsString());
                }
                throw new IllegalStateException("IntegrationProvider references must have at least an 'id' property");
            }
            throw new IllegalStateException("IntegrationProvider references should not receive a JsonArray");
        }
    }

    public static enum IntegrationProviderType {
        RTC(RTCIntegrationProvider.class),
        JIRA(JiraIntegrationProvider.class),
        UCD(UCDIntegrationProvider.class),
        PLUGIN(PluginIntegrationProvider.class);

        public Class<? extends IntegrationProvider> clientClass;

        private IntegrationProviderType(Class<? extends IntegrationProvider> clientClass) {
            this.clientClass = clientClass;
        }

        public String getTypeString() {
            return ((Object)((Object)this)).getClass().getAnnotation(SerializedName.class).value();
        }

        public IntegrationProviderType fromTypeString(String typeString) {
            for (IntegrationProviderType type : IntegrationProviderType.values()) {
                if (!type.getTypeString().equals(typeString)) continue;
                return type;
            }
            return null;
        }
    }
}

