/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.google.common.collect.Sets;
import com.urbancode.release.rest.framework.ClientDescribed;
import com.urbancode.release.rest.framework.JsonReadOnly;
import java.util.HashSet;
import java.util.Set;

public class Role
extends ClientDescribed<Role> {
    public static final Role ADMIN = (Role)new Role().id("00000000-0000-0000-0000-000000000003");
    public static final Role RELEASE_MANAGER = (Role)new Role().id("00000000-0000-0000-0000-000000000004");
    public static final Role OBSERVER = (Role)new Role().id("00000000-0000-0000-0000-000000000005");
    public static final Role DEVELOPMENT_MANAGER = (Role)new Role().id("00000000-0000-0000-0000-000000000301");
    public static final Role QA_MANAGER = (Role)new Role().id("00000000-0000-0000-0000-000000000302");
    public static final Role PARTICIPANT = (Role)new Role().id("00000000-0000-0000-0000-000000000303");
    public String[] actions;
    @JsonReadOnly
    public Boolean enabled;

    public Role() {
        this.path = "/role/";
    }

    public Role actions(Action ... actions) {
        String[] ids = new String[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            ids[i] = actions[i].id;
        }
        this.actions = ids;
        return this;
    }

    public Set<Action> getActions() {
        HashSet<Action> actions = Sets.newHashSet();
        for (String id : this.actions) {
            actions.add(new Action().id(id));
        }
        return actions;
    }

    public Role addAction(Action action) {
        Set<Action> actions = this.getActions();
        actions.add(action);
        return this.actions(actions.toArray(new Action[0]));
    }

    public Role removeAction(Action action) {
        Set<Action> actions = this.getActions();
        actions.remove(action);
        return this.actions(actions.toArray(new Action[0]));
    }

    public static class Action {
        public static final Action EDIT_APPLICATION = new Action().id("00000000-0000-0000-0000-000000000088");
        public static final Action EDIT_STATUS_COMMENTS_ATTACHMENTS = new Action().id("00000000-0000-0000-0000-000000000205");
        public static final Action VIEW_RELEASE = new Action().id("00000000-0000-0000-0000-000000000005");
        public static final Action EDIT_RELEASE = new Action().id("00000000-0000-0000-0000-000000000006");
        public static final Action EDIT_SEGMENTS = new Action().id("00000000-0000-0000-0000-000000000007");
        public static final Action OVERRIDE_TASK_STATE = new Action().id("00000000-0000-0000-0000-000000000202");
        public static final Action EXEMPT_GATES = new Action().id("00000000-0000-0000-0000-000000000203");
        public static final Action EDIT_LIFECYCLE = new Action().id("00000000-0000-0000-0000-000000000204");
        public static final Action EDIT_STATUS = new Action().id("00000000-0000-0000-0000-000000000201");
        public static final Action EDIT_ENTERPRISE_EVENT = new Action().id("00000000-0000-0000-0000-000000001206");
        public static final Action EDIT_INITIATIVES = new Action().id("00000000-0000-0000-0000-000000000207");
        public static final Action EDIT_ENVIRONMENTS = new Action().id("00000000-0000-0000-0000-000000000206");
        public static final Action EDIT_ACTIVITIES = new Action().id("00000000-0000-0000-0000-000000000209");
        public static final Action SECURITY_ADMIN = new Action().id("00000000-0000-0000-0000-000000000001");
        public static final Action USER_ADMIN = new Action().id("00000000-0000-0000-0000-000000000002");
        public static final Action ROLE_ADMIN = new Action().id("00000000-0000-0000-0000-000000000003");
        public static final Action TEAM_ADMIN = new Action().id("00000000-0000-0000-0000-000000000004");
        public static final Action INTEGRATION_ADMIN = new Action().id("00000000-0000-0000-0000-000000000208");
        public static final Action MANUAL_QA_PASS = new Action().id("00000000-0000-0000-0000-000000000101");
        public static final Action QA_MANAGER_REVIEW_PASS = new Action().id("00000000-0000-0000-0000-000000000102");
        public static final Action UNIT_TESTS_PASS = new Action().id("00000000-0000-0000-0000-000000000103");
        public String id;

        public Action id(String id) {
            this.id = id;
            return this;
        }

        public String toString() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Action) {
                Action other = (Action)obj;
                if (this.id == null || other.id == null) {
                    return false;
                }
                return other.id.equals(this.id);
            }
            return false;
        }
    }
}

