/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.urbancode.release.rest.framework.ClientDescribed;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.internal.TaskPlan;

public class SegmentPlan
extends ClientDescribed<SegmentPlan> {
    public static final SegmentPlan DEPLOYMENT_TASKS = (SegmentPlan)new SegmentPlan().id("00000000-0000-0000-0000-000000000437");
    public static final SegmentPlan PRE_DEPLOYMENT_TASKS = (SegmentPlan)new SegmentPlan().id("00000000-0000-0000-0000-000000000438");
    public String deploymentPlan;
    @JsonReadOnly
    public TaskPlan[] tasks;
    @JsonReadOnly
    public String enforceSequential;
    @JsonReadOnly
    public String executionPattern;
    @JsonReadOnly
    public String[] prerequisiteIds;

    public SegmentPlan() {
        this.path = "/segmentPlan/";
        this.prerequisiteIds = new String[0];
    }

    public SegmentPlan deploymentPlan(String id) {
        this.deploymentPlan = id;
        return this;
    }

    public SegmentPlan addTask(TaskPlan task) {
        RestAssured.given().post(this.path(this.id) + "/tasks/" + task.id, new Object[0]);
        return this;
    }

    public SegmentPlan removeTask(TaskPlan task) {
        RestAssured.given().delete(this.path(this.id) + "/tasks/" + task.id, new Object[0]);
        return this;
    }

    public SegmentPlan removeTask(int index) {
        return this.removeTask(this.tasks[index]);
    }

    public SegmentPlan updateTaskOrder() {
        return this.updateTaskOrder(SegmentPlan.ids(this.tasks));
    }

    public SegmentPlan updateTaskOrder(TaskPlan ... tasks) {
        return this.updateTaskOrder(SegmentPlan.ids(tasks));
    }

    public SegmentPlan updateTaskOrder(String ... tasks) {
        RestAssured.given().body((Object)tasks, ObjectMapperType.GSON).put(this.path(this.id) + "/tasks", new Object[0]);
        return this;
    }

    public void executionPattern(String pattern) {
        this.executionPattern = pattern;
    }
}

