/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropCore;
import com.ibm.rational.wvcm.interop.InteropUtilities;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.connector.scm.client.FB;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzRepoBaseline;
import com.ibm.team.connector.scm.client.JzRepoBaselineControlledFolder;
import com.ibm.team.connector.scm.client.JzRepoChangeSet;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoConfiguration;
import com.ibm.team.connector.scm.client.JzRepoControllableFolder;
import com.ibm.team.connector.scm.client.JzRepoControllableResource;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoRootBaseline;
import com.ibm.team.connector.scm.client.JzRepoRootVersion;
import com.ibm.team.connector.scm.client.JzRepoStream;
import com.ibm.team.connector.scm.client.JzRepoSymbolicLink;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoVersionHistory;
import com.ibm.team.connector.scm.client.JzRepoWorkItem;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.connector.scm.common.CcConnectorUtils;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.interop.client.IInteropManager;
import com.ibm.team.interop.common.IExternalProxyHandle;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.repository.client.IContributorManager;
import com.ibm.team.repository.client.ILicenseClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wvcm.Activity;
import javax.wvcm.Baseline;
import javax.wvcm.Component;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableFolder;
import javax.wvcm.ControllableResource;
import javax.wvcm.DetailedFeedback;
import javax.wvcm.Feedback;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.ProviderFactory;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Stream;
import javax.wvcm.Task;
import javax.wvcm.Version;
import javax.wvcm.VersionHistory;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class JzProvider
extends SrvcProvider {
    public static final String EMPTY_STRING = new String();
    public static final String UNDERSCORE = String.valueOf('_');
    public static final String COMMA = String.valueOf(',');
    public static final String SPACE = String.valueOf(' ');
    public static final String COMMA_SPACE = String.valueOf(COMMA) + SPACE;
    public static final String DASH_DASH = "--";
    public static final String DOUBLE_QUOTE = String.valueOf('\"');
    public static final String FWDSLASH = String.valueOf('/');
    public static final String BACKSLASH = String.valueOf('\\');
    public static final String FALSE = "false";
    public static final String TRUE = "true";
    public static final String COMMAND_STRING = "cccToolsCommand";
    public static final String WINDOWS = "windows";
    public static final String UPDATE_SYNC_STREAM_LICENSE_ID = "com.ibm.team.connector.scm.cc.update-sync-stream";
    public static final String IMPORT_STREAM_LICENSE_ID = "com.ibm.team.connector.scm.cc.import-stream";
    public static final String EV_PREFIX = "com.ibm.team.connector.scm.client.";
    public static final PropertyNameList.PropertyName<String> PN_PROCESS_AREA_ID = new PropertyNameList.PropertyName("com.ibm.team.connector.scm", "TEAM_AREA_ID");
    public static final PropertyNameList.PropertyName<String> PN_OWNER_PROCESS_AREA_PATHNAME = new PropertyNameList.PropertyName("com.ibm.team.connector.scm", "OWNER_PROCESS_AREA_PATHNAME");
    private static final String IA_TEMPLATE_ID_NAME = "com.ibm.team.connector.scm.WORKITEM_TEMPLATE_ID";
    private static final String OLD_DEFAULT_TEMPLATE_ID = "do not use a template for workitem creation";
    private static final String IA_SYNC_VIA_BUILD = "com.ibm.team.connector.scm.SYNC_VIA_BUILD";
    private static final String DEFAULT_SYNC_VIA_BUILD = "true";
    public static final String SYNC_USER_ID_BASENAME = "SYNC_USER_ID";
    public static final String IA_SYNC_USER_ID = "com.ibm.team.connector.scm.SYNC_USER_ID";
    public static final String DEFAULT_SYNC_USER_ID = "ccsync";
    public static final String IA_TEAM_AREA_PATH = "com.ibm.team.connector.scm.TEAM_AREA_PATH";
    private static final String IA_DEFAULT_COMPONENT_RI = "defaultComponentRI";
    private static final String IA_BUILD_DEF_LOC_STR = "com.ibm.team.connector.scm.BUILD_DEF_LOC_STR";
    private static final String IA_BUILD_RESULT_LOC_STR = "com.ibm.team.connector.scm.BUILD_RESULT_LOC_STR";
    public static final String IA_BUILD_ENGINE_NAME = "com.ibm.team.connector.scm.BUILD_ENGINE_NAME";
    public static final String IA_BUILD_KIND = "com.ibm.team.connector.scm.BUILD_KIND";
    public static final String IA_REPOSITORY_URI = "com.ibm.team.connector.scm.REPOSITORY_URI";
    public static final String IA_BUILD_CLI_PATH = "com.ibm.team.connector.scm.CLI_PATH";
    public static final String IA_INSTALL_LOCATION_BASENAME = "INSTALL_LOCATION";
    public static final String IA_INSTALL_PATH = "com.ibm.team.connector.scm.INSTALL_LOCATION";
    public static final String IA_SLEEP_TIME = "com.ibm.team.connector.scm.BUILD_ENGINE_SLEEP_TIME";
    public static final String IA_SYNC_HOST = "com.ibm.team.connector.scm.SYNC_HOST";
    public static final String IA_SYNC_HOST_IS_WINDOWS = "com.ibm.team.connector.scm.SYNC_HOST_IS_WINDOWS";
    public static final String IA_SCRIPT_LOCATION_PREFIX_BASENAME = "SCRIPT_LOCATION_PREFIX";
    public static final String IA_STREAM_SCRIPT_DIR_BASENAME = "STREAM_SCRIPT_DIR";
    public static final String IA_STREAM_SCRIPT_DIR_PATH = "com.ibm.team.connector.scm.STREAM_SCRIPT_DIR";
    public static final String IA_SYMLINKS_SUPPORTED = "com.ibm.team.connector.scm.SYMLINKS_SUPPORTED";
    public static final String IA_PROCESS_VS_FILES = "com.ibm.team.connector.scm.PROCESS_VISUAL_STUDIO_FILES";
    public static final String IA_MAX_NUM_QUERY_ENTRIES = "com.ibm.team.connector.scm.MAX_NUM_QUERY_ENTRIES";
    public static final String IA_MAX_CHANGE_SET_SIZE = "com.ibm.team.connector.scm.MAX_CHANGE_SET_SIZE";
    public static final String IA_SCRIPT_LOCATION_PREFIX = "com.ibm.team.connector.scm.SCRIPT_LOCATION_PREFIX";
    public static final String IA_ALLOW_MOD_MOD_MERGE = "com.ibm.team.connector.scm.ALLOW_MOD_MOD_MERGE";
    public static final BuildKind DEFAULT_BUILD_KIND = BuildKind.CLI;
    public static final String BUILD_CLI_PATH_DEFAULT = "eclipse" + File.separator + "ccc";
    public static final String IA_MAX_CONTENT_COMMIT_DEFERRAL_MILLIS = "com.ibm.team.connector.scm.DEFER_CONTENT_OPS";
    public static final String IA_REPOSITORY_ROOT_UUID = "com.ibm.team.connector.scm.REPOSITORY_ROOT_UUID";
    public static final String IA_MAX_NUM_AUTO_COMMIT_ENTRIES = "com.ibm.team.connector.scm.MAX_NUM_AUTO_COMMIT_ENTRIES";
    public static final String IA_MAX_QUERY_SIZE = "com.ibm.team.connector.scm.MAX_QUERY_SIZE";
    public static final String IA_PRE_SYNC_OPERATION_PATH = "com.ibm.team.connector.scm.PRE_SYNC_OPERATION_PATH";
    public static final String IA_POST_SYNC_OPERATION_PATH = "com.ibm.team.connector.scm.POST_SYNC_OPERATION_PATH";
    public static final String DEFAULT_SLEEP_TIME = "120";
    public static final String DEFAULT_IGNORE_TASK_CREATION_FAILURE = "false";
    private static final Long MILLIS_PER_MINUTE = new Long(60000L);
    private static final Long DEFAULT_MAX_COMMIT_LAG = 5L * MILLIS_PER_MINUTE;
    public static SimpleDateFormat timeFormatter = new SimpleDateFormat("HH.mm.ss");
    private ITeamRepository _jazzRepository;
    private static String fallbackUri;
    private Log _log = null;
    private OpsForAllConfigurations deferrals = new OpsForAllConfigurations();
    static final String SLN_START_PROJECT = "Project(";
    static final String SLN_GLOBAL = "Global";
    static final String SLN_END_GLOBAL = "EndGlobal";
    static final String SLN_GLOBAL_SECTION_START = "GlobalSection";
    static final String SLN_GLOBAL_SECTION_END = "EndGlobalSection";
    static final String SLN_TAB;
    static final String SLN_GLOBAL_SECTION_START_FMT = "\t{0}({1}) = preSolution";
    static final String SLN_JAZZ_SCM_PROPERTIES = "JazzSourceControlProviderSolutionProperties";
    static final String SLN_CLEARCASE = "RationalClearCase";
    static final String SLN_JZ_GLOBAL_SECTION_START;
    static final String SLN_JZ_SOLUTION_PROP_1 = "\t\tSolutionIsControlled = True";
    static final String SLN_JZ_SOLUTION_PROP_2 = "\t\tSolutionBindings = <Solution Location In Database>";
    static final String SLN_CC_SOLUTION_PROP_1 = "\t\tSourceControlProvider = RationalClearCase";
    static final String UTF8_ENCODING_NAME = "UTF-8";
    static final Pattern PROJ_XML_PATTERN;
    static final Pattern PROJ_VC_PATTERN;
    static final Pattern PROJ_DB_PATTERN;
    static final Pattern PROJ_VD_PATTERN;
    static final String PROJ_CLEARCASE = "Rational ClearCase";
    static final String PROJ_TAG_FMT = "<{0}>{1}</{0}>";
    static final String PROJ_VC_FMT = "{0}=\"{1}\"";
    static final String PROJ_DB_FMT = "{0} = \"{1}\"";
    static final String PROJ_VD_FMT = "\"{0}\" = \"8:{1}\"";
    static Map<String, String> PROJ_JZ_TAGMAP;

    static {
        SLN_TAB = String.valueOf('\t');
        SLN_JZ_GLOBAL_SECTION_START = MessageFormat.format(SLN_GLOBAL_SECTION_START_FMT, SLN_GLOBAL_SECTION_START, SLN_JAZZ_SCM_PROPERTIES);
        PROJ_XML_PATTERN = Pattern.compile("<(Scc\\w+)>[\\s\\w\\&;:\\{\\}-]+</\\1>");
        PROJ_VC_PATTERN = Pattern.compile("(Scc\\w+)\\s*=\\s*\\\"[\\s\\w\\&;:\\{\\}-]+\\\"");
        PROJ_DB_PATTERN = Pattern.compile("(Scc\\w+)\\s*=\\s*\\\"[\\s\\w<>:\\{\\}-]+\\\"");
        PROJ_VD_PATTERN = Pattern.compile("\\\"(Scc\\w+)\\\"\\s*=\\s*\\\"[\\s\\w<>:\\{\\}-]+\\\"");
        PROJ_JZ_TAGMAP = null;
        PROJ_JZ_TAGMAP = new HashMap<String, String>();
        PROJ_JZ_TAGMAP.put("SccProjectName", "&lt;Project Location In Database&gt;");
        PROJ_JZ_TAGMAP.put("SccLocalPath", "&lt;Local Binding Root of Project&gt;");
        PROJ_JZ_TAGMAP.put("SccAuxPath", "&lt;Source Control Database&gt;");
        PROJ_JZ_TAGMAP.put("SccProvider", "Jazz Source Control Provider:{AC8810C5-F6E7-4145-83AA-FDFFF6F5506D}");
    }

    public static int FB_BASE(int begin, int end, int count, int size) {
        return begin + (end - begin) * count / size;
    }

    public JzProvider() {
    }

    public JzProvider(ProviderFactory.Callback callback, Map<String, String> args) throws WvcmException {
        this();
        this.initialize(args, callback);
    }

    public static void setFallbackUri(String repositoryURI) {
        fallbackUri = repositoryURI;
    }

    public void initialize(Map<String, String> args, ProviderFactory.Callback callback) throws WvcmException {
        super.setDisplayName("Jazz");
        args.put("com.ibm.rational.wvcm.VERSION_KNOWS_PARENT", "true");
        args.put("com.ibm.team.ucm_importer.HAS_OBJECT_LINKAGE_INFO", "true");
        args.put("com.ibm.team.ucm_importer.TASKS_REQUIRE_TRANSITION_ACTIONS", "true");
        if (args.get("com.ibm.team.interop.DESYNC") == null) {
            args.put("com.ibm.team.interop.DESYNC", EMPTY_STRING);
        }
        if (JzProvider.getTemplateId(args) == null) {
            JzProvider.setTemplateId(args, EMPTY_STRING);
        }
        if (JzProvider.getSyncViaBuild(args) == null) {
            JzProvider.setSyncViaBuild(args, "true");
        }
        if (JzProvider.getSyncUserId(args) == null) {
            this.setSyncUserIdToDefault(args);
        }
        if (JzProvider.getBuildKind(args) == null) {
            JzProvider.setBuildKind(args, DEFAULT_BUILD_KIND);
        }
        if (this.getMaxContentCommitDeferralMillis(args) == null) {
            this.setMaxContentCommitDeferralMillis(args, DEFAULT_MAX_COMMIT_LAG.toString());
        }
        if (this.getMaxNumAutoCommitEntries(args) == null) {
            this.setMaxNumAutoCommitEntries(args, String.valueOf(0));
        }
        if (JzProvider.getBuildCliPath(args) == null) {
            JzProvider.setBuildCliPath(args, BUILD_CLI_PATH_DEFAULT);
        }
        if (JzProvider.getInstallLocation(args) == null) {
            JzProvider.setInstallLocation(args, EMPTY_STRING);
        }
        if (JzProvider.getBuildEngineSleepTime(args) == null) {
            JzProvider.setBuildEngineSleepTime(args, DEFAULT_SLEEP_TIME);
        }
        if (JzProvider.getSyncHost(args) == null) {
            JzProvider.setSyncHost(args, JzProvider.getLocalHostname());
        }
        if (JzProvider.getSyncHostIsWindows(args) == null) {
            JzProvider.setSyncHostIsWindows(args, JzProvider.getIsThisHostWindows());
        }
        if (args.get("com.ibm.rational.wvcm.LOG_MINIMUM_DURATION") == null) {
            args.put("com.ibm.rational.wvcm.LOG_MINIMUM_DURATION", String.valueOf(300000));
        }
        if (args.get("com.ibm.team.interop.IGNORE_TASK_CREATION_FAILURE") == null) {
            args.put("com.ibm.team.interop.IGNORE_TASK_CREATION_FAILURE", "false");
        }
        if (!args.containsKey(IA_SCRIPT_LOCATION_PREFIX)) {
            args.put(IA_SCRIPT_LOCATION_PREFIX, EMPTY_STRING);
        }
        if (args.get(IA_PROCESS_VS_FILES) == null) {
            args.put(IA_PROCESS_VS_FILES, EMPTY_STRING);
        }
        if (args.get(IA_MAX_NUM_QUERY_ENTRIES) == null) {
            args.put(IA_MAX_NUM_QUERY_ENTRIES, String.valueOf(5000));
        }
        if (args.get(IA_MAX_CHANGE_SET_SIZE) == null) {
            args.put(IA_MAX_CHANGE_SET_SIZE, String.valueOf(1500));
        }
        if (args.get("com.ibm.team.interop.RESOURCES_PER_CLONE_LINK_UPDATE") == null) {
            args.put("com.ibm.team.interop.RESOURCES_PER_CLONE_LINK_UPDATE", String.valueOf(1000));
        }
        if (args.get("com.ibm.team.interop.MAXIMUM_MEMBER_COUNT") == null) {
            args.put("com.ibm.team.interop.MAXIMUM_MEMBER_COUNT", String.valueOf(1000));
        }
        if (args.get("com.ibm.team.interop.RESTARTABLE_IMPORTS") == null) {
            args.put("com.ibm.team.interop.RESTARTABLE_IMPORTS", InteropUtilities.TRUE_STRING);
        }
        if (args.get("com.ibm.team.interop.DISABLE_HASHING_FOR_CONTENT_COMPARE") == null) {
            args.put("com.ibm.team.interop.DISABLE_HASHING_FOR_CONTENT_COMPARE", EMPTY_STRING);
        }
        if (args.get("com.ibm.team.connector.scm.MAX_NUM_BATCH_ENTRIES") == null) {
            args.put("com.ibm.team.connector.scm.MAX_NUM_BATCH_ENTRIES", String.valueOf(5000));
        }
        if (JzProvider.lookupPreSyncOperationPath(args) == null) {
            JzProvider.setPreSyncOperationPath(args, EMPTY_STRING);
        }
        if (JzProvider.lookupPostSyncOperationPath(args) == null) {
            JzProvider.setPostSyncOperationPath(args, EMPTY_STRING);
        }
        String repoUriString = JzProvider.getRepositoryURI(args);
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        if (repoUriString == null) {
            throw new IllegalArgumentException("Repository URI String must not be null");
        }
        String uuidString = JzProvider.lookupRepoRootUuid(args);
        UUID storedRepoUuid = uuidString == null ? null : UUID.valueOf((String)uuidString);
        this._jazzRepository = JzProvider.findTeamRepository(repoUriString, storedRepoUuid);
        if (this._jazzRepository == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzProvider_ERROR_NO_CONNECTION_FOUND_FOR_URI, (Object)repoUriString, (Object[])new Object[0]), WvcmException.ReasonCode.CONFLICT);
        }
        args.put(IA_REPOSITORY_URI, this._jazzRepository.getRepositoryURI());
        if (storedRepoUuid == null) {
            JzProvider.setRepoRootUuid(args, this._jazzRepository.root().getItemId().getUuidValue());
        }
        if (JzProvider.getSymlinksSupported(args) == null) {
            boolean doesServerSupportSymlinks;
            try {
                doesServerSupportSymlinks = FileSystemCore.getFileSystemManager((ITeamRepository)this.getRepo()).serverSupportsSymbolicLinks(null);
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException((Exception)((Object)e));
            }
            if (doesServerSupportSymlinks) {
                JzProvider.setSymlinksSupported(args, "true");
            }
        }
        super.initialize(args, callback);
    }

    private static ITeamRepository findTeamRepository(String repoUriString, UUID storedRepoUuid) {
        ITeamRepository result = null;
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(repoUriString, 4);
        if (JzProvider.checkTeamRepository(repo, storedRepoUuid)) {
            result = repo;
        }
        if (result == null && fallbackUri != null && JzProvider.checkTeamRepository(repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(fallbackUri, 4), storedRepoUuid)) {
            result = repo;
        }
        if (result == null && storedRepoUuid != null) {
            ITeamRepository[] repos;
            ITeamRepository[] iTeamRepositoryArray = repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            int n = repos.length;
            int n2 = 0;
            while (n2 < n) {
                ITeamRepository candidate = iTeamRepositoryArray[n2];
                if (JzProvider.checkTeamRepository(candidate, storedRepoUuid)) {
                    result = candidate;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    private static boolean checkTeamRepository(ITeamRepository repo, UUID storedRepoUuid) {
        boolean result = false;
        if (repo != null && repo.loggedIn()) {
            result = true;
            if (storedRepoUuid != null) {
                result = repo.root().getItemId().equals((Object)storedRepoUuid);
            }
        }
        return result;
    }

    public static void setRepoRootUuid(Map<String, String> args, String repoUuidValue) {
        args.put(IA_REPOSITORY_ROOT_UUID, repoUuidValue);
    }

    public void setRepoRootUuid(Map<String, String> args) {
        JzProvider.setRepoRootUuid(args, this.getRepo().root().getItemId().getUuidValue());
    }

    public static String lookupRepoRootUuid(Map<String, String> args) {
        return args.get(IA_REPOSITORY_ROOT_UUID);
    }

    public String lookupRepoRootUuid() {
        return JzProvider.lookupRepoRootUuid(this._initArgs);
    }

    public boolean setRepoRootUuidIfNecessary(Map<String, String> args) {
        boolean isNecessary;
        boolean bl = isNecessary = !args.containsKey(IA_REPOSITORY_ROOT_UUID);
        if (isNecessary) {
            this.setRepoRootUuid(args);
        }
        return isNecessary;
    }

    public static final boolean isThisHostWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    public static String getIsThisHostWindows() {
        return JzProvider.isThisHostWindows() ? "true" : "false";
    }

    public static String getLocalHostname() throws WvcmException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new WvcmException(Messages.JzProvider_ERROR_COULD_NOT_GET_LOCAL_HOSTNAME, null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    public static ITeamRepository doLogin(String repoUriString, String authLoginName, String authPassword) {
        try {
            return JzProvider.doLoginThrowsTRE(repoUriString, authLoginName, authPassword, true);
        }
        catch (TeamRepositoryException e) {
            throw new RuntimeException("login failed", e);
        }
    }

    public static ITeamRepository doLoginThrowsTRE(String repoUriString, final String authLoginName, final String authPassword, boolean managed) throws TeamRepositoryException {
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        ITeamRepositoryService teamRepositoryService = TeamPlatform.getTeamRepositoryService();
        ITeamRepository result = managed ? teamRepositoryService.getTeamRepository(repoUriString, 2) : teamRepositoryService.getUnmanagedRepository(repoUriString);
        result.registerLoginHandler(new ITeamRepository.ILoginHandler(){

            public ITeamRepository.ILoginHandler.ILoginInfo challenge(ITeamRepository repo) {
                return new ITeamRepository.ILoginHandler.ILoginInfo(){

                    public String getPassword() {
                        return authPassword;
                    }

                    public String getUserId() {
                        return authLoginName;
                    }
                };
            }
        });
        result.login(null);
        if (managed) {
            teamRepositoryService.addTeamRepository(result);
        }
        return result;
    }

    public static Feedback nonNullFeedback(Feedback feedback) {
        return feedback != null ? feedback : DetailedFeedback.fb(null);
    }

    public ResourceList<Folder> activityFolderList(PropertyRequestItem.PropertyRequest propertyRequest) throws WvcmException {
        throw new WvcmException("activityFolderList is NYI", WvcmException.ReasonCode.FORBIDDEN);
    }

    public JzRepoControllableFolder doCreateControllableFolder(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        boolean isSymbolicLinkControlledFolderLocation;
        JzLocation jzLoc = JzLocation.create(location);
        boolean isBaselineControlledFolderLocation = jzLoc.kind() == JzLocation.Kind.BaselineControlledFolder;
        boolean bl = isSymbolicLinkControlledFolderLocation = jzLoc.kind() == JzLocation.Kind.SymbolicLink;
        if (isBaselineControlledFolderLocation) {
            JzRepoBaselineControlledFolder result = JzRepoBaselineControlledFolder.doCreateResource(this, jzLoc, updates, updated, feedback.nest(70));
            return result;
        }
        if (isSymbolicLinkControlledFolderLocation) {
            JzRepoResource result = JzRepoSymbolicLink.doCreateSymbolicLink(this, jzLoc, updates, updated, feedback);
            result.doWriteProperties(updates, updated, feedback);
            return (JzRepoControllableFolder)result;
        }
        JzRepoResource result = JzRepoControllableFolder.doCreate(this, jzLoc, feedback);
        return (JzRepoControllableFolder)result;
    }

    public SrvcResource doCreateControllableResource(Location genericLocation, SrvcFeedback feedback) throws WvcmException {
        return JzRepoControllableResource.doCreateControllableResource(this, JzLocation.create(genericLocation), feedback);
    }

    public SrvcResource doCreateControllableSymbolicLink(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return JzRepoSymbolicLink.doCreateSymbolicLink(this, JzLocation.create(location), updates, updated, feedback);
    }

    public SrvcResource doCreateGeneratedActivity(Location location, boolean isStream, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        if (isStream) {
            return JzRepoStream.doCreateGeneratedResource(this, JzLocation.create(location), updates, updated, feedback);
        }
        return JzRepoChangeSet.doCreateGeneratedResource(this, JzLocation.create(location), updates, updated, feedback);
    }

    public SrvcResource doCreateGeneratedWorkspace(Location locationHint, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return JzRepoWorkspace.doCreateGeneratedWorkspace(this, JzLocation.create(locationHint), updates, updated, feedback);
    }

    public SrvcResource doCreateVersionControlledResource(Location location, Location versionLoc, SrvcFeedback feedback) throws WvcmException {
        return JzRepoControllableFolder.doCreateVersionControlledResource(this, location, versionLoc, false, feedback);
    }

    public List<Object> doCreateVersionControlledResources(List<Location> newLocations, List<Location> versionLocations, SrvcFeedback feedback) throws WvcmException {
        List results;
        try {
            results = JzRepoControllableFolder.doCreateVersionControlledResources(this, newLocations, versionLocations, feedback);
        }
        catch (Exception e) {
            if (newLocations.size() != 1) {
                feedback.notifyWarning(NLS.bind((String)Messages.JzProvider_WARN_FALLING_BACK_FOR_RESTORE_RESOURCES, (Object)newLocations.size(), (Object[])new Object[]{e.getMessage()}));
            }
            results = super.doCreateVersionControlledResources(newLocations, versionLocations, feedback);
        }
        return results;
    }

    public JzRepoControllableFolder doBaselineControl(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        JzRepoResource folder = this.lookup(location, feedback);
        if (folder != null) {
            if (folder instanceof JzRepoBaselineControlledFolder) {
                return (JzRepoBaselineControlledFolder)folder;
            }
            throw new WvcmException("Must be a controllable folder", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
        }
        return (JzRepoBaselineControlledFolder)this.doCreateControllableFolder(location, (Map)updates, (List)updated, feedback);
    }

    public SrvcResource doCreateBaselineControlledFolder(Location location, Location baselineLoc, SrvcFeedback feedback) throws WvcmException {
        return JzRepoControllableFolder.doCreateBaselineControlledFolder(this, location, baselineLoc, feedback);
    }

    public SrvcResource doCreateGeneratedTask(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return JzRepoWorkItem.doCreateGeneratedResource(this, JzLocation.create(location), updates, updated, feedback);
    }

    public SrvcResource doFindOne(Resource query, SrvcFeedback feedback) throws WvcmException {
        List<SrvcResource> result = this.doFind(query, false, true, feedback);
        if (result.isEmpty()) {
            throw this.computeDidNotFindOneException(query, feedback);
        }
        return result.get(0);
    }

    public SrvcResource doFind(Resource query, SrvcFeedback feedback) throws WvcmException {
        List<SrvcResource> result = this.doFind(query, false, false, feedback);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    public List<SrvcResource> doFindAll(Resource query, SrvcFeedback feedback) throws WvcmException {
        return this.doFind(query, true, false, feedback);
    }

    private List<SrvcResource> doFind(Resource query, boolean all, boolean findOne, SrvcFeedback feedback) throws WvcmException {
        Object compNameVal;
        Object requestedIdVal;
        List<SrvcResource> result = Collections.emptyList();
        Object cloneVal = query.lookupProperty(InteropCore.PN_CLONE);
        if (cloneVal instanceof String) {
            return this.doFindClone(query, all, feedback);
        }
        if (query instanceof Task && (requestedIdVal = query.lookupProperty(InteropUtilities.PN_TASK_ID)) instanceof String) {
            String requestedId = (String)requestedIdVal;
            JzRepoWorkItem requestedItem = JzRepoWorkItem.lookupById(this, requestedId, feedback);
            result = new ArrayList(1);
            result.add(requestedItem);
            return result;
        }
        if (query instanceof Component && (compNameVal = query.lookupProperty(Component.DISPLAY_NAME)) instanceof String) {
            String compName = (String)compNameVal;
            JzLocation compLoc = JzLocation.createComponentNameLocation(compName);
            JzRepoResource comp = this.lookup((Location)compLoc, feedback);
            return Collections.singletonList(comp);
        }
        if (query instanceof Task) {
            Task taskQuery = (Task)query;
            return JzRepoWorkItem.doFind(this, taskQuery, all, feedback);
        }
        if (query instanceof Stream) {
            if (!all) {
                throw new WvcmException("doFindStream NYI when all is false", WvcmException.ReasonCode.FORBIDDEN);
            }
            return new ArrayList<SrvcResource>(this.doFindStream(feedback));
        }
        if (query instanceof Baseline) {
            Baseline baselineQuery = (Baseline)query;
            return this.doFindBaselines(baselineQuery, all, feedback);
        }
        if (query instanceof Version) {
            Version versionQuery = (Version)query;
            VersionHistory vhQuery = versionQuery.getVersionHistory();
            JzLocation vhLoc = JzLocation.create(vhQuery.getPathnameLocation());
            JzRepoVersionHistory vh = (JzRepoVersionHistory)this.get((Location)vhLoc, feedback);
            Object inBlList = versionQuery.lookupProperty(Version.IN_BASELINE_LIST);
            if (inBlList instanceof ResourceList) {
                return this.doFindVersionInBaseline(versionQuery, vh, all, findOne, feedback);
            }
            return this.doFindVersionInWorkspace(versionQuery, vh, all, findOne, feedback);
        }
        if (query instanceof Configuration) {
            Configuration confQuery = (Configuration)query;
            Component queryComp = (Component)confQuery.getVersionHistory();
            JzLocation compLoc = JzLocation.create(queryComp.getPathnameLocation());
            JzLocation wsLoc = JzLocation.create(confQuery.getWorkspace().getPathnameLocation());
            JzRepoWorkspace jzWS = new JzRepoWorkspace(this, wsLoc);
            IConfiguration conf = jzWS.lookupConfiguration(compLoc, feedback);
            if (conf != null) {
                result = new ArrayList<SrvcResource>(1);
                JzLocation configLoc = JzLocation.createConfigurationLoc(wsLoc, compLoc);
                JzRepoConfiguration config = (JzRepoConfiguration)this.lookup((Location)configLoc, feedback);
                result.add(config);
            }
            return result;
        }
        if (query instanceof ControllableResource) {
            JzLocation wsLoc;
            JzRepoWorkspace jzWS;
            Object countValue = query.lookupProperty(InteropCore.PN_MAXIMUM_MEMBER_COUNT);
            if (query instanceof ControllableFolder && countValue instanceof Integer) {
                int threshold = (Integer)countValue;
                JzRepoControllableFolder root = (JzRepoControllableFolder)this.get(query.location(), feedback.nest(10));
                ArrayList<JzRepoControllableFolder> results = new ArrayList<JzRepoControllableFolder>();
                root.findBigFolders(threshold, results, feedback.nest(20));
                return new ArrayList<SrvcResource>(results);
            }
            result = new ArrayList<SrvcResource>(1);
            ControllableResource crQuery = (ControllableResource)query;
            VersionHistory queryVh = crQuery.getVersionHistory();
            Location vhLoc = queryVh.getPathnameLocation();
            JzRepoVersionHistory jzV = (JzRepoVersionHistory)this.get(vhLoc, feedback);
            JzRepoControllableResource cr = jzV.createControllableResource(jzWS = new JzRepoWorkspace(this, wsLoc = JzLocation.create(crQuery.getWorkspace().getPathnameLocation())), feedback);
            if (cr != null) {
                cr = (JzRepoControllableResource)this.lookup((Location)cr.location(), feedback);
                result.add(cr);
            }
            return result;
        }
        throw new WvcmException("Unhandled query", WvcmException.ReasonCode.FORBIDDEN);
    }

    private List<SrvcResource> doFindBaselines(Baseline query, boolean all, SrvcFeedback feedback) throws WvcmException {
        List<SrvcResource> results = Collections.emptyList();
        Object value = query.lookupProperty(Version.VERSION_HISTORY);
        if (!(value instanceof Component)) {
            results = JzRepoBaseline.doFindSnapshots(this, query, all, feedback);
        } else {
            String displayName;
            Component queryComp = (Component)value;
            JzLocation compLoc = JzLocation.create(queryComp.getPathnameLocation());
            JzRepoComponent jrComp = JzRepoComponent.lookup(this, compLoc, feedback);
            Object queryActivityObject = query.lookupProperty(Baseline.ACTIVITY);
            JzLocation streamLoc = queryActivityObject instanceof Activity ? JzLocation.create(((Activity)queryActivityObject).getPathnameLocation()) : null;
            JzRepoStream stream = streamLoc == null ? null : JzRepoStream.lookup(this, streamLoc, feedback);
            Object queryNameObject = query.lookupProperty(Baseline.DISPLAY_NAME);
            String string = displayName = queryNameObject instanceof String ? (String)queryNameObject : null;
            if (jrComp != null) {
                if (stream != null) {
                    results = stream.getAllBaselines(jrComp, feedback);
                } else if (displayName != null) {
                    results = jrComp.doFindNamedBaselines(displayName, all, feedback);
                }
            }
        }
        return results;
    }

    private List<SrvcResource> doFindVersionInWorkspace(Version query, JzRepoVersionHistory vh, boolean all, boolean findOne, SrvcFeedback feedback) throws WvcmException {
        ArrayList<SrvcResource> results = new ArrayList<SrvcResource>(1);
        ResourceList workspaceQueryList = query.getInWorkspaceList();
        JzLocation workspaceLoc = JzLocation.create(((Workspace)workspaceQueryList.get(0)).getPathnameLocation());
        JzRepoWorkspace workspace = (JzRepoWorkspace)this.get((Location)workspaceLoc, feedback);
        JzRepoVersion resultVersion = JzRepoWorkspace.locateByHistory(this, workspace.getConnection(feedback), vh, feedback);
        if (resultVersion != null) {
            JzLocation vLoc = resultVersion.location();
            feedback.setResourceCache((Location)vLoc, this.createContextProxy(resultVersion, (Location)vLoc, workspace, feedback));
            results.add(resultVersion);
        } else if (findOne) {
            String msg = NLS.bind((String)Messages.JzProvider_ERROR_REQUIRED_VERSION_NOT_FOUND, (Object)workspaceLoc.toString(), (Object[])new Object[]{vh.location().toString()});
            throw new WvcmException(msg, WvcmException.ReasonCode.NOT_FOUND);
        }
        return results;
    }

    private List<SrvcResource> doFindVersionInBaseline(Version query, JzRepoVersionHistory vh, boolean all, boolean findOne, SrvcFeedback feedback) throws WvcmException {
        ArrayList<SrvcResource> results = new ArrayList<SrvcResource>(1);
        JzLocation baselineLoc = JzLocation.create(((Baseline)query.getInBaselineList().get(0)).getPathnameLocation());
        JzRepoBaseline bl = (JzRepoBaseline)this.get((Location)baselineLoc, feedback);
        JzRepoVersion resultVersion = (JzRepoVersion)bl.locateByHistory(vh, feedback);
        if (findOne && resultVersion == null) {
            String msg = NLS.bind((String)Messages.JzProvider_ERR_CANT_FIND_VERSION_IN_BL_WITH_VH_PATH_AND_BL_PATH, (Object)vh.location().toString(), (Object[])new Object[]{baselineLoc.toString()});
            throw new WvcmException(msg, WvcmException.ReasonCode.NOT_FOUND);
        }
        results.add(resultVersion);
        return results;
    }

    private List<SrvcResource> doFindClone(Resource query, boolean all, SrvcFeedback feedback) throws WvcmException {
        JzRepoResource result;
        block15: {
            result = null;
            String cloneValue = (String)query.getProperty(InteropCore.PN_CLONE);
            if (query instanceof VersionHistory && !(query instanceof Component)) {
                JzRepoVersionHistory jrvh;
                List<JzRepoVersionHistory> jrvhs = JzRepoVersionHistory.getClonesOfTargets(this, Collections.singletonList(cloneValue), feedback);
                result = jrvh = jrvhs.get(0);
            } else {
                IItemHandle foundItemHandle = JzRepoResource.lookupByValue(this, InteropCore.PN_CLONE, cloneValue, feedback);
                if (foundItemHandle != null) {
                    if (query instanceof Component) {
                        JzRepoComponent comp = JzRepoComponent.create((IComponentHandle)foundItemHandle, this);
                        result = comp;
                    } else if (query instanceof Task) {
                        JzLocation resultLoc = JzLocation.createWorkItemLoc(JzRepoResource.getCurrentStateDisplayName(foundItemHandle));
                        JzRepoWorkItem resultWI = (JzRepoWorkItem)this.lookup((Location)resultLoc, feedback);
                        if (resultWI != null) {
                            result = resultWI;
                        }
                    } else {
                        try {
                            IItem item = this.getRepo().itemManager().fetchCompleteItem(foundItemHandle, 0, JzProvider.getMonitor(feedback, 100));
                            if (item instanceof IBaseline) {
                                IBaseline baseline = (IBaseline)item;
                                IComponentHandle compHandle = baseline.getComponent();
                                JzRepoComponent comp = JzRepoComponent.create(compHandle, this);
                                result = JzRepoBaseline.create(comp, (IBaselineHandle)baseline);
                                break block15;
                            }
                            if (item instanceof IChangeSet) {
                                result = JzRepoChangeSet.create(this, (IChangeSetHandle)((IChangeSet)item), feedback.nest(80));
                                break block15;
                            }
                            if (item instanceof IComponent) {
                                result = JzRepoComponent.create((IComponentHandle)((IComponent)item), this);
                                break block15;
                            }
                            if (item instanceof IWorkspace) {
                                IWorkspace flowNode = (IWorkspace)item;
                                result = flowNode.isStream() ? JzRepoStream.create(this, (IItemHandle)item) : JzRepoWorkspace.create(this, (IWorkspaceHandle)((IWorkspace)item));
                                break block15;
                            }
                            if (item instanceof IWorkItem) {
                                result = JzRepoWorkItem.create(this, (IWorkItemHandle)((IWorkItem)item));
                                break block15;
                            }
                            throw new IllegalStateException("unsupported class: " + item.getClass().getName());
                        }
                        catch (TeamRepositoryException e) {
                            throw JzProvider.wrapException((Exception)((Object)e));
                        }
                    }
                }
            }
        }
        return Collections.singletonList(result);
    }

    private List<JzRepoStream> doFindStream(SrvcFeedback feedback) throws WvcmException {
        IProcessArea processAreaHandle = this.getProcessArea(feedback.nest(10));
        return this.findStreams(Collections.singletonList(processAreaHandle), feedback);
    }

    public List<Stream> findInteropStreams(List<IProcessAreaHandle> processAreaHandles, PropertyRequestItem.PropertyRequest propertyRequest, boolean verbose, SrvcFeedback f) throws WvcmException {
        String interopStreamPropertyName = InteropCore.PN_INTEROP_STREAM.getName();
        List<IWorkspaceHandle> streamHandles = JzProvider.findAllStreamHandles(processAreaHandles, this.getRepo(), f);
        ArrayList<IWorkspaceHandle> interopStreamHandles = new ArrayList<IWorkspaceHandle>();
        for (IWorkspaceHandle streamHandle : streamHandles) {
            Object value = JzRepoResource.getCustomProperty(this, (IItemHandle)streamHandle, interopStreamPropertyName, f);
            if (value == null) continue;
            interopStreamHandles.add(streamHandle);
        }
        int count = interopStreamHandles.size();
        if (verbose) {
            f.notifyActive(NLS.bind((String)Messages.JzProvider_FOUND_C_SYNC_STREAMS_OUT_OF_J_SCM_STREAMS, (Object)count, (Object[])new Object[]{streamHandles.size()}));
        }
        ArrayList<Stream> results = new ArrayList<Stream>(count);
        for (IWorkspaceHandle h : interopStreamHandles) {
            JzLocation streamLoc = JzRepoStream.createStreamLocation((IItemHandle)h);
            Stream result = (Stream)this.buildProxy((Location)streamLoc, propertyRequest, f);
            results.add(result);
        }
        return results;
    }

    public String getAreaPathname(IProcessAreaHandle areaHandle, SrvcFeedback feedback) throws WvcmException {
        ITeamAreaHandle parent;
        IProcessArea processArea = this.fetchCompleteProcessArea(areaHandle, feedback.nest(10));
        IProjectArea projectArea = this.getProjectArea(processArea, feedback.nest(30));
        if (ItemUtil.equivItemRef((IItemHandle)areaHandle, (IItemHandle)projectArea)) {
            return projectArea.getName();
        }
        ITeamAreaHierarchy hier = projectArea.getTeamAreaHierarchy();
        LinkedList<String> names = new LinkedList<String>();
        do {
            names.push(processArea.getName());
        } while ((processArea = (parent = hier.getParent((ITeamAreaHandle)processArea)) == null ? null : this.fetchCompleteProcessArea((IProcessAreaHandle)parent, feedback)) != null);
        names.push(projectArea.getName());
        StringBuffer result = new StringBuffer(names.size());
        boolean first = true;
        do {
            if (first) {
                first = false;
            } else {
                result.append(FWDSLASH);
            }
            result.append((String)names.pop());
        } while (!names.isEmpty());
        return result.toString();
    }

    private List<JzRepoStream> findStreams(List<IProcessAreaHandle> processAreaHandles, SrvcFeedback f) throws WvcmException {
        List<IWorkspaceHandle> streamHandles = JzProvider.findAllStreamHandles(processAreaHandles, this.getRepo(), f);
        ArrayList<JzRepoStream> results = new ArrayList<JzRepoStream>(streamHandles.size());
        for (IWorkspaceHandle streamHandle : streamHandles) {
            JzLocation streamLoc = JzRepoStream.createStreamLocation((IItemHandle)streamHandle);
            JzRepoStream result = (JzRepoStream)this.lookup((Location)streamLoc, f);
            results.add(result);
        }
        return results;
    }

    private static List<IWorkspaceHandle> findAllStreamHandles(List<IProcessAreaHandle> processAreaHandles, ITeamRepository repo, SrvcFeedback f) throws WvcmException {
        if (processAreaHandles.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<IWorkspaceHandle> results = new ArrayList<IWorkspaceHandle>();
        IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(1);
        criteria.getFilterByOwnerOptional().addAll(processAreaHandles);
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        boolean moreToDo = true;
        do {
            try {
                List streamHandles = workspaceManager.findWorkspaces(criteria, Integer.MAX_VALUE, JzProvider.getMonitor(f, 100));
                if (streamHandles.size() == 0) {
                    moreToDo = false;
                    break;
                }
                results.addAll(streamHandles);
                IWorkspaceHandle lastWsHandle = (IWorkspaceHandle)streamHandles.get(streamHandles.size() - 1);
                IWorkspace lastWs = (IWorkspace)JzProvider.fetchCompleteItem((IItemHandle)lastWsHandle, repo, JzProvider.getMonitor(f, 50));
                criteria.setModifiedBeforeOptional(lastWs.modified());
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException((Exception)((Object)e));
            }
        } while (moreToDo);
        return results;
    }

    static IItem fetchCompleteItem(IItemHandle h, ITeamRepository repo, IProgressMonitor m) throws WvcmException {
        return JzProvider.fetchCompleteItems(Collections.singletonList(h), repo, m).get(0);
    }

    private static List<IItem> fetchCompleteItems(List<IItemHandle> handles, ITeamRepository repo, IProgressMonitor monitor) throws WvcmException {
        if (handles.size() == 0) {
            return Collections.emptyList();
        }
        try {
            List streams = repo.itemManager().fetchCompleteItems(handles, 0, monitor);
            return streams;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public ITeamRepository getRepo() {
        return this._jazzRepository;
    }

    public String lookupProcessAreaPathInitArg() {
        return JzProvider.getProcessAreaPath(this._initArgs);
    }

    public static String getProcessAreaPath(Map<String, String> args) {
        String result = args.get(IA_TEAM_AREA_PATH);
        if (result != null) {
            return result;
        }
        return args.get("processAreaPath");
    }

    public static void setProcessAreaPathInitArg(Map<String, String> args, String path) {
        args.put(IA_TEAM_AREA_PATH, path);
    }

    public JzLocation location(String string) throws WvcmException {
        return new JzLocation(string);
    }

    public JzRepoResource get(Location genericLocation, SrvcFeedback feedback) throws WvcmException {
        JzRepoResource result = this.lookup(genericLocation, feedback);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzProvider_ERROR_NOT_FOUND_WITH_LOC_STRING, (Object)genericLocation.string(), (Object[])new Object[0]), WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    public JzRepoResource lookup(Location genericLocation, SrvcFeedback feedback) throws WvcmException {
        if (genericLocation == null) {
            return null;
        }
        JzLocation loc = JzLocation.create(genericLocation);
        JzRepoResource result = null;
        JzLocation.Kind kind = loc.kind();
        try {
            switch (kind) {
                case Baseline: 
                case Snapshot: {
                    result = JzRepoBaseline.lookup(this, loc, feedback);
                    break;
                }
                case BaselineControlledFolder: {
                    result = JzRepoBaselineControlledFolder.lookup(this, loc, feedback);
                    break;
                }
                case ChangeSet: {
                    result = JzRepoChangeSet.lookup(this, loc, feedback);
                    break;
                }
                case ControllableFolder: 
                case ControllableResource: 
                case FileSysPath: 
                case NewControllableFolder: 
                case SymbolicLink: {
                    result = JzRepoControllableResource.lookup(this, loc, feedback);
                    break;
                }
                case Component: {
                    result = JzRepoComponent.lookup(this, loc, feedback);
                    break;
                }
                case Configuration: {
                    result = JzRepoConfiguration.lookup(this, loc, feedback);
                    break;
                }
                case Pathname: {
                    result = this.lookupByPathname(loc, feedback);
                    break;
                }
                case RootVersion: {
                    result = new JzRepoRootVersion(this, (Location)loc);
                    break;
                }
                case RootBaseline: {
                    result = new JzRepoRootBaseline(this, loc);
                    break;
                }
                case Stream: {
                    result = JzRepoStream.lookup(this, loc, feedback);
                    break;
                }
                case Version: {
                    result = this.resolveVersion(loc, feedback);
                    break;
                }
                case VersionHistory: {
                    result = JzRepoVersionHistory.lookup(this, loc, null, feedback);
                    break;
                }
                case Workspace: {
                    result = JzRepoWorkspace.lookup(this, loc, feedback);
                    break;
                }
                case WorkspaceConfiguration: {
                    result = JzRepoConfiguration.lookup(this, loc, feedback);
                    break;
                }
                case WorkItem: {
                    result = JzRepoWorkItem.lookup(this, loc);
                }
            }
        }
        catch (WvcmException e) {
            if (WvcmException.ReasonCode.NOT_FOUND.equals((Object)e.getReasonCode())) {
                this.logIgnoredExceptionAsNotAlwaysVisible("JzProvider.lookup", (Exception)((Object)e));
            }
            throw e;
        }
        return result;
    }

    private JzRepoResource lookupByPathname(JzLocation loc, SrvcFeedback feedback) throws WvcmException {
        JzRepoResource result = null;
        try {
            String wsUuid;
            JzRepoWorkspace ws;
            String pathKind;
            ArrayList<String> segments = new ArrayList<String>(Arrays.asList(loc.getPath()));
            if (segments.size() > 2 && (pathKind = (String)segments.remove(0)).equalsIgnoreCase(JzLocation.kindWorkspaceString) && (ws = JzRepoWorkspace.lookupByPathname(this, wsUuid = (String)segments.remove(0))) != null) {
                JzLocation resultLoc = ws.location();
                for (String segment : segments) {
                    resultLoc = resultLoc.child(segment);
                }
                result = this.lookup((Location)resultLoc, feedback);
            }
        }
        catch (WvcmException e) {
            if (!WvcmException.ReasonCode.NOT_FOUND.equals((Object)e.getReasonCode())) {
                throw e;
            }
            this.logIgnoredExceptionAsNotAlwaysVisible("JzProvider.lookupByPathname", (Exception)((Object)e));
            result = null;
        }
        return result;
    }

    public JzRepoVersion resolveVersion(JzLocation loc, SrvcFeedback feedback) {
        JzRepoVersion result;
        block3: {
            result = null;
            try {
                IVersionableHandle h = (IVersionableHandle)JzRepoResource.getItemHandle(this, loc);
                if (h != null) {
                    result = JzRepoVersion.createAppropriateProxy(this, loc, (IItemHandle)h, feedback);
                }
            }
            catch (Throwable e) {
                if (!(e instanceof Exception)) break block3;
                this.logIgnoredExceptionAsAlwaysVisible("JzProvider.resolveVersion", (Exception)e);
            }
        }
        return result;
    }

    public ResourceList<Folder> workspaceFolderList(PropertyRequestItem.PropertyRequest propertyRequest) {
        ResourceList resList = this.resourceList((Resource[])new Folder[0]);
        resList.add((Object)this.folder(JzLocation.workspaceFolderList()));
        return resList;
    }

    public JzLocation rootLocation() {
        return JzLocation.root();
    }

    public IProcessAreaHandle lookupProcessAreaHandle(SrvcFeedback feedback) throws WvcmException {
        IProcessArea result = null;
        String processAreaPath = this.lookupProcessAreaPathInitArg();
        if (processAreaPath != null) {
            try {
                result = (IProcessAreaHandle)JzRepoResource.lookupItemHandle(this, new URI(processAreaPath));
            }
            catch (URISyntaxException e) {
                throw new WvcmException("lookupProcessAreaByPath: " + processAreaPath, null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
            }
        } else {
            result = JzProvider.lookupProcessArea("Interop SCM", this.getRepo(), feedback);
        }
        return result;
    }

    public static IProcessArea lookupProcessArea(String processAreaName, ITeamRepository teamRepository, SrvcFeedback feedback) throws WvcmException {
        IProcessClientService processClientLibrary = (IProcessClientService)teamRepository.getClientLibrary(IProcessClientService.class);
        try {
            IProcessArea area = processClientLibrary.findProcessArea(new URI(JzProvider.convertToURI(processAreaName)), IProcessClientService.ALL_PROPERTIES, JzProvider.getMonitor(feedback, 100));
            return area;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
        catch (URISyntaxException e) {
            throw JzProvider.wrapException(e);
        }
    }

    private static String convertToURI(String path) throws WvcmException {
        try {
            path = URLEncoder.encode(path, UTF8_ENCODING_NAME);
            return path.replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new WvcmException("huh?", null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    public static IQueryService getQueryService(ITeamRepository teamRepository) {
        IClientLibraryContext context = (IClientLibraryContext)teamRepository;
        IQueryService qs = (IQueryService)context.getServiceInterface(IQueryService.class);
        return qs;
    }

    private Log getLog() {
        if (this._log == null) {
            this._log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
        }
        return this._log;
    }

    public boolean isDiagInfoEnabled() {
        return this.getLog().isInfoEnabled();
    }

    public boolean isDebugLogEnabled() {
        return this.getLog().isDebugEnabled();
    }

    public void logCreation(String objectKind, JzLocation requestedLocation, String resourceIdentifer, String otherInfo) {
        if (this.isDebugLogEnabled()) {
            this.logDebug("created " + objectKind + "at requested location: " + requestedLocation.string() + " with resource Id: " + resourceIdentifer + " " + otherInfo);
        }
    }

    public void logCreation(String objectKind, JzLocation objectLocation) {
        if (this.isDebugLogEnabled()) {
            this.logDebug("created " + objectKind + " with location: " + objectLocation.string());
        }
    }

    public void logInfo(String msg) {
        System.out.println(msg);
    }

    public void logDiagInfo(String fmt, Object ... args) {
        if (this.isDiagInfoEnabled()) {
            this.getLog().info((Object)String.format(fmt, args));
        }
    }

    public void logDebug(String msg) {
        this.getLog().debug((Object)msg);
    }

    public void logIgnoredExceptionAsNotAlwaysVisible(String methodName, Exception e) {
        this.logDebug("Ignored Exception: method: " + methodName + " is ignoring exception: " + e.getMessage());
    }

    public void logIgnoredExceptionAsNotAlwaysVisible(String methodName, Exception e, String extraDescription) {
        this.logDebug("Ignored Exception: method: " + methodName + " is ignoring exception: " + e.getMessage() + "with extra description: " + extraDescription);
    }

    public void logIgnoredExceptionAsAlwaysVisible(String methodName, Exception e) {
        this.logInfo(NLS.bind((String)Messages.JzProvider_IGNORED_EXCEPTION, (Object)methodName, (Object[])new Object[]{e.getMessage()}));
    }

    public void logIgnoredExceptionAsAlwaysVisible(String methodName, Exception e, String extraDescription) {
        this.logInfo(NLS.bind((String)Messages.JzProvider_IGNORED_EXCEPTION_WITH_EXTRA_DESCRIPTION, (Object)methodName, (Object[])new Object[]{e.getMessage(), extraDescription}));
    }

    public IProjectArea getProjectArea(SrvcFeedback feedback) throws WvcmException {
        IProcessArea processArea = this.getProcessArea(feedback);
        return this.getProjectArea(processArea, feedback);
    }

    protected IProjectArea getProjectArea(IProcessArea processArea, SrvcFeedback feedback) throws WvcmException {
        IProjectAreaHandle projectAreaHandle = processArea.getProjectArea();
        IProjectArea result = ItemUtil.equivItemRef((IItemHandle)processArea, (IItemHandle)projectAreaHandle) ? (IProjectArea)processArea : (IProjectArea)this.fetchCompleteProcessArea((IProcessAreaHandle)projectAreaHandle, feedback);
        return result;
    }

    public IProcessArea getProcessArea(SrvcFeedback feedback) throws WvcmException {
        IProcessAreaHandle h = this.lookupProcessAreaHandle(feedback);
        if (h == null) {
            throw new IllegalStateException("Could not get team area handle from JzProvider initArgs");
        }
        return this.fetchCompleteProcessArea(h, feedback);
    }

    public IProcessArea fetchCompleteProcessArea(IProcessAreaHandle processAreaHandle, SrvcFeedback feedback) throws WvcmException {
        ITeamRepository repo = this.getRepo();
        try {
            IProcessArea result = (IProcessArea)repo.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 1, JzProvider.getMonitor(feedback, 100));
            return result;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public String setDefaultComponentRI(String value) {
        return this._initArgs.put(IA_DEFAULT_COMPONENT_RI, value);
    }

    public String getDefaultComponentRI() {
        return (String)this._initArgs.get(IA_DEFAULT_COMPONENT_RI);
    }

    public static void setTemplateId(Map<String, String> args, String templateId) {
        args.put(IA_TEMPLATE_ID_NAME, templateId);
    }

    public static String getTemplateId(Map<String, String> args) {
        return args.get(IA_TEMPLATE_ID_NAME);
    }

    public String getTemplateId() {
        return JzProvider.getTemplateId(this._initArgs);
    }

    public boolean templateIdHasInitialValue() {
        return this.getTemplateId().equals(OLD_DEFAULT_TEMPLATE_ID) || this.getTemplateId().length() == 0;
    }

    public static String getSyncViaBuild(Map<String, String> args) {
        return args.get(IA_SYNC_VIA_BUILD);
    }

    public String getSyncViaBuild() {
        return JzProvider.getSyncViaBuild(this._initArgs);
    }

    public static void setSyncViaBuild(Map<String, String> args, String value) {
        args.put(IA_SYNC_VIA_BUILD, value);
    }

    public static String getRepositoryURI(Map<String, String> args) {
        String result = args.get(IA_REPOSITORY_URI);
        if (result != null) {
            return result;
        }
        return args.get("RepositoryURI");
    }

    public String getRepositoryURI() {
        return JzProvider.getRepositoryURI(this._initArgs);
    }

    public static String getSyncUserId(Map<String, String> args) {
        return args.get(IA_SYNC_USER_ID);
    }

    public String getSyncUserId() {
        return JzProvider.getSyncUserId(this._initArgs);
    }

    public static void setSyncUserId(Map<String, String> args, String value) {
        args.put(IA_SYNC_USER_ID, value);
    }

    private void setSyncUserIdToDefault(Map<String, String> args) {
        String systemSyncUserIdString = System.getProperty(IA_SYNC_USER_ID);
        String idString = systemSyncUserIdString != null ? systemSyncUserIdString : DEFAULT_SYNC_USER_ID;
        JzProvider.setSyncUserId(args, idString);
    }

    public String lookupBuildDefinitionLocationString() {
        return (String)this._initArgs.get(IA_BUILD_DEF_LOC_STR);
    }

    public void setBuildDefinitionLocationString(String locString) {
        this._initArgs.put(IA_BUILD_DEF_LOC_STR, locString);
    }

    public String lookupBuildResultLocationString() {
        return (String)this._initArgs.get(IA_BUILD_RESULT_LOC_STR);
    }

    public static void setBuildResultLocationString(Map<String, String> args, String locString) {
        args.put(IA_BUILD_RESULT_LOC_STR, locString);
    }

    public static String lookupBuildEngineName(Map<String, String> args) {
        return args.get(IA_BUILD_ENGINE_NAME);
    }

    public String lookupBuildEngineBasename() {
        return JzProvider.lookupBuildEngineName(this._initArgs);
    }

    public static void setBuildEngineName(Map<String, String> args, String name) {
        if (name == null) {
            args.remove(IA_BUILD_ENGINE_NAME);
        } else {
            args.put(IA_BUILD_ENGINE_NAME, name);
        }
    }

    public void setBuildEngineName(String name) {
        JzProvider.setBuildEngineName(this._initArgs, name);
    }

    public static void setInstallLocation(Map<String, String> args, String path) {
        args.put(IA_INSTALL_PATH, path);
    }

    public static String getInstallLocation(Map<String, String> args) {
        return args.get(IA_INSTALL_PATH);
    }

    public String getInstallLocation() {
        String installLocationValue = JzProvider.getInstallLocation(this._initArgs);
        if (installLocationValue == null) {
            throw new IllegalStateException(NLS.bind((String)Messages.JzProvider_ERROR_INSTALL_PATH_PROP_MUST_BE_NON_NULL_WITH_PROPNAME, (Object)IA_INSTALL_PATH, (Object[])new Object[0]));
        }
        return installLocationValue;
    }

    public static void setBuildEngineSleepTime(Map<String, String> args, String sleepTimeString) {
        args.put(IA_SLEEP_TIME, sleepTimeString);
    }

    public String getBuildEngineSleepTime() {
        return JzProvider.getBuildEngineSleepTime(this._initArgs);
    }

    public static String getBuildEngineSleepTime(Map<String, String> args) {
        return args.get(IA_SLEEP_TIME);
    }

    public static void setSyncHost(Map<String, String> args, String hostname) {
        args.put(IA_SYNC_HOST, hostname);
    }

    public void setSyncHost(String hostname) {
        JzProvider.setSyncHost(this._initArgs, hostname);
    }

    public static String getSyncHost(Map<String, String> args) {
        return args.get(IA_SYNC_HOST);
    }

    public String getSyncHost() {
        return JzProvider.getSyncHost(this._initArgs);
    }

    public static void setSyncHostIsWindows(Map<String, String> args, String syncHostIsWindows) {
        args.put(IA_SYNC_HOST_IS_WINDOWS, syncHostIsWindows);
    }

    public void setSyncHostIsWindows(String syncHostIsWindows) {
        JzProvider.setSyncHostIsWindows(this._initArgs, syncHostIsWindows);
    }

    public static String getSyncHostIsWindows(Map<String, String> args) {
        return args.get(IA_SYNC_HOST_IS_WINDOWS);
    }

    public String getSyncHostIsWindows() {
        return JzProvider.getSyncHostIsWindows(this._initArgs);
    }

    public static String getSymlinksSupported(Map<String, String> args) {
        return args.get(IA_SYMLINKS_SUPPORTED);
    }

    public String getSymlinksSupported() {
        String areSymlinksSupported = JzProvider.getSymlinksSupported(this._initArgs);
        if (areSymlinksSupported != null) {
            return areSymlinksSupported;
        }
        return "false";
    }

    public static void setSymlinksSupported(Map<String, String> args, String symlinksSupported) {
        args.put(IA_SYMLINKS_SUPPORTED, symlinksSupported);
    }

    public void setSymlinksSupported(String symlinksSupported) {
        JzProvider.setSymlinksSupported(this._initArgs, symlinksSupported);
    }

    public String getScriptLocationPrefix() {
        return JzProvider.getScriptLocationPrefix(this._initArgs);
    }

    public static void setScriptLocationPrefix(Map<String, String> args, String value) {
        args.put(IA_SCRIPT_LOCATION_PREFIX, value);
    }

    public static String getScriptLocationPrefix(Map<String, String> args) {
        return args.get(IA_SCRIPT_LOCATION_PREFIX);
    }

    public static void setPreSyncOperationPath(Map<String, String> args, String value) {
        args.put(IA_PRE_SYNC_OPERATION_PATH, value);
    }

    public void setPreSyncOperationPath(String value) {
        JzProvider.setPreSyncOperationPath(this._initArgs, value);
    }

    public static String lookupPreSyncOperationPath(Map<String, String> args) {
        return args.get(IA_PRE_SYNC_OPERATION_PATH);
    }

    public String lookupPreSyncOperationPath() {
        return JzProvider.lookupPreSyncOperationPath(this._initArgs);
    }

    public static void setPostSyncOperationPath(Map<String, String> args, String value) {
        args.put(IA_POST_SYNC_OPERATION_PATH, value);
    }

    public void setPostSyncOperationPath(String value) {
        JzProvider.setPostSyncOperationPath(this._initArgs, value);
    }

    public static String lookupPostSyncOperationPath(Map<String, String> args) {
        return args.get(IA_POST_SYNC_OPERATION_PATH);
    }

    public String lookupPostSyncOperationPath() {
        return JzProvider.lookupPostSyncOperationPath(this._initArgs);
    }

    public void forEachExternalProxyWithTargetItemAndUri(IVisitCloneExternalProxy visitor) throws WvcmException {
        IInteropManager interopManager = (IInteropManager)this.getRepo().getClientLibrary(IInteropManager.class);
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            IExternalProxyHandle[] externalProxyHandles;
            IExternalProxyHandle[] iExternalProxyHandleArray = externalProxyHandles = interopManager.findProxiesBySyncRule(null, (IProgressMonitor)monitor);
            int n = externalProxyHandles.length;
            int n2 = 0;
            while (n2 < n) {
                boolean continueOn;
                IExternalProxyHandle externalProxyHandle = iExternalProxyHandleArray[n2];
                URI otherUri = interopManager.getUri(externalProxyHandle, (IProgressMonitor)monitor);
                IItemHandle thisItem = interopManager.getTargetItem(externalProxyHandle, (IProgressMonitor)monitor);
                if (otherUri == null || thisItem == null || !CcConnectorUtils.CLONED_ITEM_TYPES.contains(thisItem.getItemType()) || (continueOn = visitor.visit(externalProxyHandle, thisItem, otherUri))) {
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public static InteropUtilities.LineSeparator lookupLineSeparator(Resource resource) {
        if (resource == null) {
            return null;
        }
        Object valLS = resource.lookupProperty(InteropUtilities.PN_LINE_SEPARATOR);
        if (valLS instanceof String) {
            return InteropUtilities.LineSeparator.valueOf((String)((String)valLS));
        }
        return null;
    }

    public static String getLineDelimiterText(FileLineDelimiter delim) {
        switch (delim) {
            case LINE_DELIMITER_CR: {
                return "\r";
            }
            case LINE_DELIMITER_CRLF: {
                return "\r\n";
            }
            case LINE_DELIMITER_LF: {
                return "\n";
            }
            case LINE_DELIMITER_PLATFORM: {
                return JzProvider.getLineDelimiterText(FileLineDelimiter.getPlatformDelimiter());
            }
        }
        throw new RuntimeException("Unexpected LineSeparator value");
    }

    public static FileLineDelimiter getLineDelimiter(InteropUtilities.LineSeparator lineSeparator) {
        if (lineSeparator.equals((Object)InteropUtilities.LineSeparator.UNSPECIFIED)) {
            return FileLineDelimiter.LINE_DELIMITER_NONE;
        }
        if (lineSeparator.equals((Object)InteropUtilities.LineSeparator.LF)) {
            return FileLineDelimiter.LINE_DELIMITER_LF;
        }
        if (lineSeparator.equals((Object)InteropUtilities.LineSeparator.CR)) {
            return FileLineDelimiter.LINE_DELIMITER_CR;
        }
        if (lineSeparator.equals((Object)InteropUtilities.LineSeparator.CRLF)) {
            return FileLineDelimiter.LINE_DELIMITER_CRLF;
        }
        if (lineSeparator.equals((Object)InteropUtilities.LineSeparator.PLATFORM)) {
            return FileLineDelimiter.LINE_DELIMITER_PLATFORM;
        }
        throw new IllegalArgumentException("Unknown line separator value");
    }

    public static String getBuildKindValue(Map<String, String> args) {
        String value = args.get(IA_BUILD_KIND);
        return value;
    }

    public static BuildKind getBuildKind(Map<String, String> args) {
        String value = JzProvider.getBuildKindValue(args);
        BuildKind result = value == null ? null : BuildKind.valueOf(value);
        return result;
    }

    public BuildKind getBuildKind(BuildKind defaultBuildKind) {
        return JzProvider.getBuildKind(this._initArgs);
    }

    public static void setBuildKind(Map<String, String> args, BuildKind value) {
        args.put(IA_BUILD_KIND, value.name());
    }

    public static String getBuildCliPath(Map<String, String> args) {
        return args.get(IA_BUILD_CLI_PATH);
    }

    public static void setBuildCliPath(Map<String, String> args, String value) {
        args.put(IA_BUILD_CLI_PATH, value);
    }

    public String getBuildCliPath() {
        return JzProvider.getBuildCliPath(this._initArgs);
    }

    public boolean allowModModMerge(Map<String, String> args) {
        String value = args.get(IA_ALLOW_MOD_MOD_MERGE);
        return Boolean.TRUE.toString().equalsIgnoreCase(value);
    }

    public boolean allowModModMerge() {
        return this.allowModModMerge(this._initArgs);
    }

    public static void setAllowModModMerge(Map<String, String> args, boolean boolValue) {
        args.put(IA_ALLOW_MOD_MOD_MERGE, boolValue ? "true" : "false");
    }

    private void setMaxContentCommitDeferralMillis(Map<String, String> args, String value) {
        args.put(IA_MAX_CONTENT_COMMIT_DEFERRAL_MILLIS, value);
    }

    private String getMaxContentCommitDeferralMillis(Map<String, String> args) {
        return args.get(IA_MAX_CONTENT_COMMIT_DEFERRAL_MILLIS);
    }

    private void setMaxNumAutoCommitEntries(Map<String, String> args, String value) {
        args.put(IA_MAX_NUM_AUTO_COMMIT_ENTRIES, value);
    }

    private String getMaxNumAutoCommitEntries(Map<String, String> args) {
        return args.get(IA_MAX_NUM_AUTO_COMMIT_ENTRIES);
    }

    public boolean areContentCommitsDeferred() {
        return this.getMaxCommitLag() != 0L || this.getMaxCommitNum() > 0;
    }

    private Long getMaxCommitLag() {
        Long result = new Long(0L);
        String value = this.getMaxContentCommitDeferralMillis(this._initArgs);
        try {
            result = Long.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            boolean oldValueCommitsAreDeferred = value != null && Boolean.valueOf(value) != false;
            result = oldValueCommitsAreDeferred ? DEFAULT_MAX_COMMIT_LAG : 0L;
        }
        return result;
    }

    private int getMaxCommitNum() {
        int result = 0;
        String value = this.getMaxNumAutoCommitEntries(this._initArgs);
        try {
            result = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            this.logIgnoredExceptionAsNotAlwaysVisible("getMaxCommitNum", e);
        }
        return result;
    }

    public static void setMaxQuerySize(Map<String, String> args, int value) {
        args.put(IA_MAX_QUERY_SIZE, String.valueOf(value));
    }

    public void setMaxQuerySize(int value) {
        JzProvider.setMaxQuerySize(this._initArgs, value);
    }

    public static String getMaxQuerySize(Map<String, String> args) {
        return args.get(IA_MAX_QUERY_SIZE);
    }

    public int getMaxQuerySize() {
        int result = 512;
        String value = JzProvider.getMaxQuerySize(this._initArgs);
        try {
            result = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            this.logIgnoredExceptionAsNotAlwaysVisible("getMaxQuerySize", e);
        }
        return result;
    }

    public String lookupStreamScriptDir() {
        return (String)this._initArgs.get(IA_STREAM_SCRIPT_DIR_PATH);
    }

    public void setStreamScriptDir(String streamScriptDir) {
        Map args = this._initArgs;
        JzProvider.setStreamScriptDir(args, streamScriptDir);
    }

    public static void setStreamScriptDir(Map<String, String> args, String streamScriptDir) {
        args.put(IA_STREAM_SCRIPT_DIR_PATH, streamScriptDir);
    }

    public void deferOrCommitContentOp(JzRepoConfiguration wvcmConfiguration, IWorkspaceConnection.IConfigurationOp configOp, JzLocation location, SrvcFeedback feedback) throws WvcmException {
        boolean commitNow = false;
        Long timeOfFirstDeferredOp = this.deferrals.add(wvcmConfiguration, configOp, location);
        int numDeferred = this.deferrals.count(wvcmConfiguration);
        Long maxCommitLag = this.getMaxCommitLag();
        if (maxCommitLag > 0L) {
            Long now = System.nanoTime();
            Long ageOfFirstDeferredOp = (now - timeOfFirstDeferredOp) / 1000000L;
            boolean bl = commitNow = ageOfFirstDeferredOp >= maxCommitLag;
        }
        if (!commitNow) {
            int maxCommitNum = this.getMaxCommitNum();
            boolean bl = commitNow = maxCommitNum > 0 && numDeferred >= maxCommitNum;
        }
        if (commitNow) {
            this.deferrals.applyDeferredContentCommits(true, feedback);
        }
    }

    public static String myToString(String separator, String ... parts) {
        if (parts == null) {
            return new String();
        }
        StringBuffer result = new StringBuffer();
        boolean needSep = false;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String onePart = stringArray[n2];
            if (needSep) {
                result.append(separator);
            } else {
                needSep = true;
            }
            result.append(onePart);
            ++n2;
        }
        return result.toString();
    }

    public IContributor getContributor(String userId, SrvcFeedback feedback) throws WvcmException {
        try {
            IContributorManager s = this.getRepo().contributorManager();
            IContributor result = s.fetchContributorByUserId(userId, JzProvider.getMonitor(feedback, 100));
            return result;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public List<Object> doFind(ResourceList<?> queries, SrvcFeedback feedback) throws WvcmException {
        BatchedQueryKind queryKind = BatchedQueryKind.UNOPTIMIZED;
        ArrayList<String> cloneValues = new ArrayList<String>(queries.size());
        ArrayList<ControllableResource> findCrQueries = new ArrayList<ControllableResource>(queries.size());
        for (Resource query : queries) {
            if (query instanceof VersionHistory) {
                if (BatchedQueryKind.UNOPTIMIZED.equals((Object)queryKind) || BatchedQueryKind.FIND_VH_CLONES.equals((Object)queryKind)) {
                    queryKind = BatchedQueryKind.FIND_VH_CLONES;
                    cloneValues.add((String)query.getProperty(InteropCore.PN_CLONE));
                    continue;
                }
                throw new IllegalStateException("found VersionHistory query after finding query kind : " + queryKind.name());
            }
            if (query instanceof ControllableResource) {
                if (BatchedQueryKind.UNOPTIMIZED.equals((Object)queryKind) || BatchedQueryKind.FIND_CR_IN_WORKSPACE.equals((Object)queryKind)) {
                    queryKind = BatchedQueryKind.FIND_CR_IN_WORKSPACE;
                    findCrQueries.add((ControllableResource)query);
                    continue;
                }
                throw new IllegalStateException("found ControllableResource query after finding query kind : " + queryKind.name());
            }
            if (BatchedQueryKind.UNOPTIMIZED.equals((Object)queryKind)) continue;
            throw new IllegalStateException("found unoptimized query after finding query kind : " + queryKind.name());
        }
        ArrayList<Object> results = new ArrayList(queries.size());
        switch (queryKind) {
            case FIND_VH_CLONES: {
                List<JzRepoVersionHistory> vhClones = JzRepoVersionHistory.getClonesOfTargets(this, cloneValues, feedback);
                results.addAll(vhClones);
                break;
            }
            case FIND_CR_IN_WORKSPACE: {
                List<JzRepoControllableResource> crs = JzRepoVersionHistory.computeControllableResources(this, findCrQueries, feedback);
                results.addAll(crs);
                break;
            }
            default: {
                results = super.doFind(queries, feedback);
            }
        }
        return results;
    }

    public static IProgressMonitor getMonitor(Feedback feedback, int percentDone) {
        if (feedback != null && feedback instanceof FB) {
            return ((FB)feedback).getMonitor(percentDone);
        }
        return new NullProgressMonitor();
    }

    public static IProgressMonitor getMonitor(SrvcFeedback srvcFeedback, int percentDone) {
        if (srvcFeedback != null) {
            return JzProvider.getMonitor(srvcFeedback.get_feedback(), percentDone);
        }
        return new NullProgressMonitor();
    }

    public static boolean isVSFile(Location loc) {
        return JzProvider.isVSSolutionFile(loc) || JzProvider.isVSProjectFile(loc);
    }

    public static boolean isVSSolutionFile(Location loc) {
        return loc != null && loc.lastSegment().toLowerCase().endsWith(".sln");
    }

    public static boolean isVSProjectFile(Location loc) {
        return JzProvider.isVSProjectMSBuildFile(loc) || JzProvider.isVSProjectVCFile(loc) || JzProvider.isVSProjectDBFile(loc) || JzProvider.isVSProjectVDFile(loc);
    }

    public static boolean isVSProjectMSBuildFile(Location loc) {
        if (loc == null) {
            return false;
        }
        String fileName = loc.lastSegment().toLowerCase();
        return fileName.endsWith(".csproj") || fileName.endsWith(".vbproj") || fileName.endsWith(".vjsproj") || fileName.endsWith(".vcxproj") || fileName.endsWith(".fsproj") || fileName.endsWith(".dbproj");
    }

    public static boolean isVSProjectVCFile(Location loc) {
        return loc != null && loc.lastSegment().toLowerCase().endsWith(".vcproj");
    }

    public static boolean isVSProjectDBFile(Location loc) {
        return loc != null && loc.lastSegment().toLowerCase().endsWith(".dbp");
    }

    public static boolean isVSProjectVDFile(Location loc) {
        return loc != null && loc.lastSegment().toLowerCase().endsWith(".vdproj");
    }

    public static InputStream convertSCPInVsFileToJazz(Location loc, InputStream input, String encoding, FileLineDelimiter lineTerminator) throws WvcmException {
        if (JzProvider.isVSSolutionFile(loc)) {
            return JzProvider.convertSCPInVsSolutionFileToJazz(input, lineTerminator);
        }
        if (JzProvider.isVSProjectMSBuildFile(loc)) {
            return JzProvider.convertSCPInVsProjectFileToJazz(input, UTF8_ENCODING_NAME, PROJ_XML_PATTERN, PROJ_TAG_FMT, false);
        }
        if (JzProvider.isVSProjectVCFile(loc)) {
            if (encoding == null) {
                throw new WvcmException(NLS.bind((String)Messages.JzProvider_ERROR_VS_MISSING_ENCODING_IN_SRC, (Object)loc.string(), (Object[])new Object[0]), WvcmException.ReasonCode.READ_FAILED);
            }
            return JzProvider.convertSCPInVsProjectFileToJazz(input, encoding, PROJ_VC_PATTERN, PROJ_VC_FMT, false);
        }
        if (JzProvider.isVSProjectDBFile(loc)) {
            if (encoding == null) {
                throw new WvcmException(NLS.bind((String)Messages.JzProvider_ERROR_VS_MISSING_ENCODING_IN_SRC, (Object)loc.string(), (Object[])new Object[0]), WvcmException.ReasonCode.READ_FAILED);
            }
            return JzProvider.convertSCPInVsProjectFileToJazz(input, encoding, PROJ_DB_PATTERN, PROJ_DB_FMT, true);
        }
        if (JzProvider.isVSProjectVDFile(loc)) {
            return JzProvider.convertSCPInVsProjectFileToJazz(input, UTF8_ENCODING_NAME, PROJ_VD_PATTERN, PROJ_VD_FMT, true);
        }
        throw new RuntimeException("Unexpected file extension for Visual Studio Project file");
    }

    public static void convertSCPInVsFileFromJazz(Location loc, ByteArrayOutputStream src, OutputStream output, String encoding, FileLineDelimiter lineTerminator) throws WvcmException {
        if (JzProvider.isVSSolutionFile(loc)) {
            JzProvider.convertSCPInVsSolutionFileFromJazz(src, output, lineTerminator);
        } else if (JzProvider.isVSProjectMSBuildFile(loc)) {
            JzProvider.convertSCPInVsProjectFileFromJazz(src, output, UTF8_ENCODING_NAME, PROJ_XML_PATTERN, PROJ_TAG_FMT);
        } else if (JzProvider.isVSProjectVCFile(loc)) {
            if (encoding == null) {
                throw new WvcmException(NLS.bind((String)Messages.JzProvider_ERROR_VS_MISSING_ENCODING, (Object)loc.string(), (Object[])new Object[0]), WvcmException.ReasonCode.READ_FAILED);
            }
            JzProvider.convertSCPInVsProjectFileFromJazz(src, output, encoding, PROJ_VC_PATTERN, PROJ_VC_FMT);
        } else if (JzProvider.isVSProjectDBFile(loc)) {
            if (encoding == null) {
                throw new WvcmException(NLS.bind((String)Messages.JzProvider_ERROR_VS_MISSING_ENCODING_IN_SRC, (Object)loc.string(), (Object[])new Object[0]), WvcmException.ReasonCode.READ_FAILED);
            }
            JzProvider.convertSCPInVsProjectFileFromJazz(src, output, encoding, PROJ_DB_PATTERN, PROJ_DB_FMT);
        } else if (JzProvider.isVSProjectVDFile(loc)) {
            JzProvider.convertSCPInVsProjectFileFromJazz(src, output, UTF8_ENCODING_NAME, PROJ_VD_PATTERN, PROJ_VD_FMT);
        }
    }

    private static InputStream convertSCPInVsSolutionFileToJazz(InputStream input, FileLineDelimiter lineTerminator) throws WvcmException {
        String delimiter = lineTerminator == null || FileLineDelimiter.LINE_DELIMITER_NONE.equals((Object)lineTerminator) ? JzProvider.getLineDelimiterText(FileLineDelimiter.LINE_DELIMITER_CRLF) : JzProvider.getLineDelimiterText(lineTerminator);
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            BufferedReader inStream = new BufferedReader(new InputStreamReader(input, UTF8_ENCODING_NAME));
            while ((line = inStream.readLine()) != null) {
                if (line.contains(SLN_START_PROJECT)) {
                    lines.add(line);
                    lines.add(SLN_JZ_GLOBAL_SECTION_START);
                    lines.add(SLN_JZ_SOLUTION_PROP_1);
                    lines.add(SLN_JZ_SOLUTION_PROP_2);
                    lines.add(String.valueOf(SLN_TAB) + SLN_GLOBAL_SECTION_END);
                    continue;
                }
                if (line.trim().equals(SLN_GLOBAL)) {
                    lines.add(line);
                    lines.add(SLN_JZ_GLOBAL_SECTION_START);
                    lines.add(SLN_JZ_SOLUTION_PROP_1);
                    lines.add(SLN_JZ_SOLUTION_PROP_2);
                    lines.add(String.valueOf(SLN_TAB) + SLN_GLOBAL_SECTION_END);
                    continue;
                }
                if (line.contains(SLN_GLOBAL_SECTION_START) && line.contains(SLN_CLEARCASE)) {
                    while (!line.contains(SLN_GLOBAL_SECTION_END)) {
                        line = inStream.readLine();
                    }
                    break;
                }
                lines.add(line);
            }
            while ((line = inStream.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            throw JzProvider.wrapException(e);
        }
        StringBuffer newContent = new StringBuffer();
        int i = 0;
        while (i < lines.size()) {
            newContent.append((String)lines.get(i));
            newContent.append(delimiter);
            ++i;
        }
        return new ReaderToInputStream((Reader)new StringReader(newContent.toString()), UTF8_ENCODING_NAME);
    }

    private static void convertSCPInVsSolutionFileFromJazz(ByteArrayOutputStream src, OutputStream output, FileLineDelimiter lineTerminator) throws WvcmException {
        String delimiter = lineTerminator == null || FileLineDelimiter.LINE_DELIMITER_NONE.equals((Object)lineTerminator) ? JzProvider.getLineDelimiterText(FileLineDelimiter.LINE_DELIMITER_CRLF) : JzProvider.getLineDelimiterText(lineTerminator);
        try {
            String[] lines = src.toString(UTF8_ENCODING_NAME).split(delimiter);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, UTF8_ENCODING_NAME));
            boolean inGlobal = false;
            boolean inGlobalSection = false;
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.contains(SLN_GLOBAL_SECTION_START) && line.contains(SLN_JAZZ_SCM_PROPERTIES)) {
                    inGlobalSection = true;
                    if (inGlobal) {
                        writer.write(MessageFormat.format(SLN_GLOBAL_SECTION_START_FMT, SLN_GLOBAL_SECTION_START, SLN_CLEARCASE));
                        writer.write(delimiter);
                        writer.write(SLN_CC_SOLUTION_PROP_1);
                        writer.write(delimiter);
                        writer.write(String.valueOf(SLN_TAB) + SLN_GLOBAL_SECTION_END);
                        writer.write(delimiter);
                    }
                } else if (line.trim().equals(SLN_GLOBAL)) {
                    inGlobal = true;
                } else if (line.trim().equals(SLN_END_GLOBAL)) {
                    inGlobal = false;
                }
                if (inGlobalSection) {
                    if (line.contains(SLN_GLOBAL_SECTION_END)) {
                        inGlobalSection = false;
                    }
                } else {
                    writer.write(line);
                    writer.write(delimiter);
                }
                ++n2;
            }
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw JzProvider.wrapException(e);
        }
    }

    private static InputStream convertSCPInVsProjectFileToJazz(InputStream input, String encoding, Pattern patternFrom, String formatTo, boolean convertEntity) throws WvcmException {
        StringBuffer strBuf = new StringBuffer();
        try {
            int count;
            BufferedReader inStream = new BufferedReader(new InputStreamReader(input, encoding));
            char[] buf = new char[8192];
            while ((count = inStream.read(buf, 0, 8192)) > 0) {
                strBuf.append(buf, 0, count);
            }
            String content = strBuf.toString();
            strBuf = new StringBuffer(content.length());
            Matcher matcher = patternFrom.matcher(content);
            int last = 0;
            while (matcher.find()) {
                strBuf.append(content.substring(last, matcher.start()));
                String tag = matcher.group(1);
                String value = PROJ_JZ_TAGMAP.get(tag);
                if (value != null) {
                    if (convertEntity) {
                        value = value.replace("&lt;", String.valueOf('<'));
                        value = value.replace("&gt;", String.valueOf('>'));
                    }
                    strBuf.append(MessageFormat.format(formatTo, tag, value));
                } else {
                    strBuf.append(content.substring(matcher.start(), matcher.end()));
                }
                last = matcher.end();
            }
            strBuf.append(content.substring(last));
        }
        catch (IOException e) {
            throw JzProvider.wrapException(e);
        }
        return new ReaderToInputStream((Reader)new StringReader(strBuf.toString()), encoding);
    }

    private static void convertSCPInVsProjectFileFromJazz(ByteArrayOutputStream src, OutputStream output, String encoding, Pattern patternFrom, String formatTo) throws WvcmException {
        try {
            String content = src.toString(encoding);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, encoding));
            Matcher matcher = patternFrom.matcher(content);
            int last = 0;
            while (matcher.find()) {
                writer.write(content.substring(last, matcher.start()));
                String tag = matcher.group(1);
                if (PROJ_JZ_TAGMAP.keySet().contains(tag)) {
                    writer.write(MessageFormat.format(formatTo, tag, PROJ_CLEARCASE));
                } else {
                    writer.write(content.substring(matcher.start(), matcher.end()));
                }
                last = matcher.end();
            }
            writer.write(content.substring(last));
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw JzProvider.wrapException(e);
        }
    }

    public JzRepoResource doWriteContent(Location location, InputStream input, String contentIdentifier, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        JzRepoControllableResource srvcResource = (JzRepoControllableResource)this.lookup(location, feedback);
        if (srvcResource == null) {
            srvcResource = (JzRepoControllableResource)JzRepoControllableResource.doCreateResourceWithContent(this, JzLocation.create(location), input, contentIdentifier, updates, updated, feedback);
        } else {
            srvcResource.doWriteContent(input, contentIdentifier, updates, updated, feedback);
        }
        return srvcResource;
    }

    public List<Object> doUpdateContextProperties(List<Location> locations, Location contextLocation, List<Map<PropertyNameList.PropertyName<?>, PropValue>> updatesList, List<List<PropertyNameList.PropertyName<?>>> updatedList, SrvcFeedback feedback) throws WvcmException {
        boolean requiresUnbatched = false;
        int size = locations.size();
        ArrayList<Object> results = new ArrayList<Object>(size);
        HashMap<JzRepoResource, String> sources2Values = new HashMap<JzRepoResource, String>();
        int i = 0;
        while (i < size) {
            Map<PropertyNameList.PropertyName<?>, PropValue> updates = updatesList.get(i);
            if (updates.size() > 0) {
                for (PropertyNameList.PropertyName<?> propertyName : updates.keySet()) {
                    if (InteropCore.PN_CLONE.equals(propertyName)) continue;
                    requiresUnbatched = true;
                    break;
                }
            } else {
                requiresUnbatched = true;
            }
            if (requiresUnbatched) {
                return super.doUpdateContextProperties(locations, contextLocation, updatesList, updatedList, feedback);
            }
            JzRepoResource jrr = this.get(locations.get(i), feedback);
            if (sources2Values.containsKey((Object)jrr)) {
                return super.doUpdateContextProperties(locations, contextLocation, updatesList, updatedList, feedback);
            }
            results.add((Object)jrr);
            PropValue propValue = updates.get(InteropCore.PN_CLONE);
            String value = (String)propValue.get_value();
            sources2Values.put(jrr, value);
            ++i;
        }
        try {
            JzRepoResource.storeInteropCloneValues(this, sources2Values, feedback);
        }
        catch (Exception exception) {
            return super.doUpdateContextProperties(locations, contextLocation, updatesList, updatedList, feedback);
        }
        ArrayList<PropertyNameList.PropertyName> cloneUpdate = new ArrayList<PropertyNameList.PropertyName>();
        cloneUpdate.add(InteropCore.PN_CLONE);
        int i2 = 0;
        while (i2 < locations.size()) {
            updatedList.add(cloneUpdate);
            ++i2;
        }
        return results;
    }

    public static WvcmException wrapExceptionGivenExternalizedMsg(String externalizedMsg, Exception e) {
        return new WvcmException(externalizedMsg, null, JzRepoResource.exceptionToReasonCode(e), (Throwable)e);
    }

    public static WvcmException wrapException(Exception e) {
        return new WvcmException(e.getMessage(), null, JzRepoResource.exceptionToReasonCode(e), (Throwable)e);
    }

    public static void validateNotNull(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("parameter must not be null: " + name);
        }
    }

    public static void validateNotEmpty(String parameterName, String parameterValue) throws IllegalArgumentException {
        JzProvider.validateNotNull("parameterName", parameterName);
        JzProvider.validateNotNull(parameterName, parameterValue);
        if (parameterValue.length() == 0) {
            throw new IllegalArgumentException(NLS.bind((String)"{0} must not be empty", (Object)parameterName, (Object[])new Object[0]));
        }
    }

    public static boolean testingThrownException(String triggerEvName) {
        String testingThrownExceptions = System.getProperty(triggerEvName, null);
        if (testingThrownExceptions == null) {
            testingThrownExceptions = System.getenv(triggerEvName);
        }
        return Boolean.TRUE.toString().equalsIgnoreCase(testingThrownExceptions);
    }

    public void assertLicenseForSyncUser(IContributor contributor, boolean isImportOnlyStream, Feedback feedback) throws WvcmException {
        ILicenseClient clientLibrary = (ILicenseClient)this.getRepo().getClientLibrary(ILicenseClient.class);
        String operationId = JzProvider.getLicenseOperationId(isImportOnlyStream);
        try {
            clientLibrary.assertLicenseForContributor(operationId, (IContributorHandle)contributor, JzProvider.getMonitor(feedback, 100));
            boolean testingThrownExceptions = JzProvider.testingThrownException("com.ibm.team.connector.scm.client.forceLicensingException");
            if (testingThrownExceptions) {
                throw new LicenseNotGrantedException("This is a test of the exception for : com.ibm.team.connector.scm.cc.update-sync-stream");
            }
        }
        catch (LicenseNotGrantedException e) {
            String msg = isImportOnlyStream ? Messages.JzProvider_ERROR_USER_NOT_LICENSED_TO_IMPORT : Messages.JzProvider_ERROR_SYNC_USER_NOT_LICENSED_TO_SYNC;
            throw new WvcmException(NLS.bind((String)msg, (Object)contributor.getName(), (Object[])new Object[0]), null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
        catch (TeamRepositoryException e) {
            String msg = isImportOnlyStream ? Messages.JzProvider_ERROR_CANT_CHECK_LICENSE_TO_IMPORT : Messages.JzProvider_ERROR_CANT_CHECK_LICENSE_TO_SYNC;
            throw new WvcmException(msg, null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    public static String getLicenseOperationId(boolean isImportOnlyStream) {
        String operationId = isImportOnlyStream ? IMPORT_STREAM_LICENSE_ID : UPDATE_SYNC_STREAM_LICENSE_ID;
        return operationId;
    }

    public IProcessArea getOwnerProcessArea(String processAreaLocString, SrvcFeedback feedback) throws WvcmException {
        JzLocation processAreaLoc = new JzLocation(processAreaLocString);
        IProcessAreaHandle processAreaHandle = (IProcessAreaHandle)JzRepoResource.lookupItemHandle(this, processAreaLoc);
        if (processAreaHandle == null) {
            throw new WvcmException(NLS.bind((String)Messages.ERROR_PROCESS_AREA_NOT_FOUND_WITH_URI_STRING0, (Object)processAreaLocString, (Object[])new Object[0]), WvcmException.ReasonCode.NOT_FOUND);
        }
        IProcessArea result = this.fetchCompleteProcessArea(processAreaHandle, feedback);
        return result;
    }

    public void applyDeferredContentCommits(SrvcFeedback feedback) throws WvcmException {
        this.deferrals.applyDeferredContentCommits(false, feedback);
    }

    public void applyDeferredContentCommits(JzRepoConfiguration config, JzLocation loc, SrvcFeedback feedback) throws WvcmException {
        this.deferrals.applyDeferredContentCommits(config, loc, feedback);
    }

    public void applyDeferredContentCommits(JzRepoConfiguration config, SrvcFeedback feedback) throws WvcmException {
        this.deferrals.applyDeferredContentCommits(config, false, feedback);
    }

    public IBuildResult lookupBuildResultThrowsTRE(SrvcFeedback feedback) throws WvcmException, TeamRepositoryException {
        IBuildResult buildResult = null;
        String buildResultLocationString = this.lookupBuildResultLocationString();
        if (buildResultLocationString != null) {
            try {
                ITeamRepository repo = this.getRepo();
                URI buildDefUri = new URI(buildResultLocationString);
                com.ibm.team.repository.common.Location usableLoc = com.ibm.team.repository.common.Location.location((com.ibm.team.repository.common.Location)com.ibm.team.repository.common.Location.location((URI)buildDefUri), (String)repo.getRepositoryURI(), null);
                buildResult = (IBuildResult)repo.itemManager().fetchCompleteItem(usableLoc, 1, JzProvider.getMonitor(feedback, 55));
            }
            catch (URISyntaxException e) {
                throw JzProvider.wrapExceptionGivenExternalizedMsg(NLS.bind((String)Messages.JzRepoWorkItem_WARN_CANT_CONS_URI, (Object)buildResultLocationString, (Object[])new Object[0]), e);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                buildResult = null;
            }
        }
        return buildResult;
    }

    public int getMaxNumQueryEntries() {
        return this.getPositiveNumberFromInitArgElseMaxValue(IA_MAX_NUM_QUERY_ENTRIES, "getMaxNumQueryEntries");
    }

    public int maxChangesPerChangeSet() {
        return this.getPositiveNumberFromInitArgElseMaxValue(IA_MAX_CHANGE_SET_SIZE, "getMaxNumQueryEntries");
    }

    private int getPositiveNumberFromInitArgElseMaxValue(String key, String nameForException) {
        int result = -1;
        try {
            String value = (String)this._initArgs.get(key);
            result = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            this.logIgnoredExceptionAsAlwaysVisible(nameForException, e);
        }
        if (result < 1) {
            result = Integer.MAX_VALUE;
        }
        return result;
    }

    public SrvcResource getSrvcRes(Location loc, SrvcFeedback feedback) throws WvcmException {
        JzRepoResource resource = this.lookup(loc, feedback);
        if (resource == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzProvider_ERROR_RESOURCE_DOES_NOT_EXIST, (Object)loc.string(), (Object[])new Object[0]), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return resource;
    }

    public IWorkspaceManager getWorkspaceManager() {
        return SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepo());
    }

    public void clearCache(Feedback feedback) {
        JzRepoComponent.clearCache();
    }

    public static enum BatchedQueryKind {
        UNOPTIMIZED,
        FIND_VH_CLONES,
        FIND_CR_IN_WORKSPACE;

    }

    public static enum BuildKind {
        ANT,
        CLI;

    }

    public static interface IVisitCloneExternalProxy {
        public boolean visit(IExternalProxyHandle var1, IItemHandle var2, URI var3) throws WvcmException;
    }

    class OpsForAllConfigurations {
        private Map<JzRepoConfiguration, Map<JzLocation, IWorkspaceConnection.IConfigurationOp>> deferredContentOps = new HashMap<JzRepoConfiguration, Map<JzLocation, IWorkspaceConnection.IConfigurationOp>>();
        Long timeOfFirstDeferredOp = null;

        OpsForAllConfigurations() {
        }

        public Long add(JzRepoConfiguration wvcmConfiguration, IWorkspaceConnection.IConfigurationOp configOp, JzLocation location) {
            if (this.timeOfFirstDeferredOp == null) {
                this.timeOfFirstDeferredOp = System.nanoTime();
            }
            if (!this.deferredContentOps.containsKey((Object)wvcmConfiguration)) {
                this.deferredContentOps.put(wvcmConfiguration, new HashMap());
            }
            Map<JzLocation, IWorkspaceConnection.IConfigurationOp> deferredOps = this.deferredContentOps.get((Object)wvcmConfiguration);
            deferredOps.put(location, configOp);
            return this.timeOfFirstDeferredOp;
        }

        public void applyDeferredContentCommits(boolean isAutoCommit, SrvcFeedback feedback) throws WvcmException {
            Set<JzRepoConfiguration> configs = this.deferredContentOps.keySet();
            for (JzRepoConfiguration config : configs) {
                this.applyDeferredContentCommits(config, isAutoCommit, feedback);
            }
            this.timeOfFirstDeferredOp = null;
        }

        public void applyDeferredContentCommits(JzRepoConfiguration config, boolean isAutoCommit, SrvcFeedback feedback) throws WvcmException {
            Map<JzLocation, IWorkspaceConnection.IConfigurationOp> commitThese = this.deferredContentOps.get((Object)config);
            if (commitThese != null) {
                this.commit(config, commitThese, isAutoCommit, feedback);
            }
        }

        private void commit(JzRepoConfiguration config, Map<JzLocation, IWorkspaceConnection.IConfigurationOp> commitThese, boolean isAutoCommit, SrvcFeedback feedback) throws WvcmException {
            int count = commitThese.size();
            if (count > 0) {
                JzProvider.this.logDiagInfo("committing %d deferred operations", count);
                config.commit(commitThese, isAutoCommit, feedback);
                commitThese.clear();
            }
        }

        public void applyDeferredContentCommits(JzRepoConfiguration config, JzLocation loc, SrvcFeedback feedback) throws WvcmException {
            Map<JzLocation, IWorkspaceConnection.IConfigurationOp> commitThese = this.deferredContentOps.get((Object)config);
            if (commitThese != null && commitThese.containsKey((Object)loc)) {
                config.commit(commitThese.get((Object)loc), loc, feedback);
                commitThese.remove((Object)loc);
            }
        }

        public int count(JzRepoConfiguration config) {
            Map<JzLocation, IWorkspaceConnection.IConfigurationOp> countThese = this.deferredContentOps.get((Object)config);
            return countThese.size();
        }
    }
}

