/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.ri.impl.VersionImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoVersionHistory;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IChangeSetSearchCriteria;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Version;
import javax.wvcm.WvcmException;

public class JzRepoRootVersion
extends JzRepoVersion {
    public JzRepoRootVersion(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return VersionImpl.class;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            return this.location().string();
        }
        if (propertyName.equals((Object)Version.VERSION_HISTORY)) {
            return this.getVersionHistory(null, feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private JzRepoVersionHistory getVersionHistory(JzRepoComponent comp, SrvcFeedback feedback) throws WvcmException {
        JzRepoVersionHistory result = JzRepoVersionHistory.lookup(this.provider(), this.location().getVersionHistoryLocation(), comp, feedback);
        return result;
    }

    @Override
    public IVersionable fetchCompleteState(SrvcFeedback feedback) throws WvcmException {
        JzRepoVersionHistory vh = this.getVersionHistory(null, feedback);
        return JzRepoRootVersion.fetchCompleteState(this.provider(), (IVersionableHandle)vh.getItemHandle(feedback), feedback);
    }

    @Override
    protected String getBindingName(SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("getBindingName is NYI", WvcmException.ReasonCode.FORBIDDEN);
    }

    @Override
    public IFolderHandle getParentFolderHandle(SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent comp = this.getJzRepoComponent(feedback);
        IFolderHandle parent = comp.getRootFolderHandle(feedback);
        return parent;
    }

    @Override
    protected JzRepoVersionHistory getParentVersionHistory(SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("getParentVersionHistory is NYI", WvcmException.ReasonCode.FORBIDDEN);
    }

    @Override
    public JzRepoComponent getJzRepoComponent(SrvcFeedback feedback) throws WvcmException {
        return (JzRepoComponent)this.provider().get((Location)this.getComponentLocation(), feedback);
    }

    public static List<IVersionable> getWorkingCopies(JzRepoComponent comp, List<JzRepoRootVersion> versionsToRestore, SrvcFeedback feedback) throws WvcmException {
        int inputCount = versionsToRestore.size();
        if (inputCount == 0) {
            return Collections.emptyList();
        }
        JzProvider provider = comp.provider();
        TreeMap<IVersionableHandle, Integer> map = new TreeMap<IVersionableHandle, Integer>(ItemUtil.itemIdComparator);
        int i = 0;
        while (i < inputCount) {
            JzRepoRootVersion v = versionsToRestore.get(i);
            JzRepoVersionHistory vh = v.getVersionHistory(comp, feedback);
            IVersionableHandle handle = (IVersionableHandle)vh.getItemHandle(feedback);
            map.put(handle, i);
            ++i;
        }
        ArrayList<IVersionable> results = new ArrayList<IVersionable>(inputCount);
        IVersionableHandle[] rootVersionHandles = new IVersionableHandle[inputCount];
        IComponentHandle componentHandle = comp.getComponentItemHandle(feedback.nest(20));
        IItemManager itemManager = provider.getRepo().itemManager();
        IWorkspaceManager workspaceManager = comp.getWorkspaceManager();
        try {
            int i2 = 0;
            while (i2 < inputCount && !map.isEmpty()) {
                IVersionableHandle versionableHandle = (IVersionableHandle)map.keySet().iterator().next();
                List<IChangeSetHandle> changeSets = JzRepoRootVersion.findChangeSets(workspaceManager, versionableHandle, componentHandle, 1, feedback);
                int size = changeSets.size();
                int counter = 0;
                for (IChangeSetHandle changeSetHandle : changeSets) {
                    int done = JzProvider.FB_BASE(31, 100, ++counter, size);
                    IChangeSet changeSet = (IChangeSet)itemManager.fetchCompleteItem((IItemHandle)changeSetHandle, 1, JzProvider.getMonitor(feedback, done));
                    List changes = changeSet.changes();
                    for (IChange change : changes) {
                        IVersionableHandle changeItem = change.item();
                        Integer index = (Integer)map.get(changeItem);
                        if (index == null) continue;
                        IVersionableHandle beforeState = change.beforeState();
                        IVersionableHandle afterStateHandle = change.afterState();
                        if (beforeState != null || afterStateHandle == null) continue;
                        rootVersionHandles[index.intValue()] = afterStateHandle;
                        map.remove(changeItem);
                    }
                    if (map.isEmpty()) break;
                }
                ++i2;
            }
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
        if (!map.isEmpty()) {
            throw new IllegalStateException("optimization failed: could not find change sets for root versions.  Try using unoptimized method.");
        }
        List<IVersionable> versions = JzRepoRootVersion.fetchCompleteStates(provider, Arrays.asList(rootVersionHandles), feedback);
        for (IVersionable version : versions) {
            results.add(version == null ? null : (IVersionable)version.getWorkingCopy());
        }
        return results;
    }

    @Override
    public IVersionable getWorkingCopy(SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        ITeamRepository repo = provider.getRepo();
        JzRepoVersionHistory vh = this.getVersionHistory(null, feedback);
        IVersionableHandle versionableHandle = (IVersionableHandle)vh.getItemHandle(feedback.nest(10));
        IComponentHandle componentHandle = vh.getJzRepoComponent(feedback.nest(15)).getComponentItemHandle(feedback.nest(20));
        try {
            List<IChangeSetHandle> changeSets = JzRepoRootVersion.findChangeSets(this.getWorkspaceManager(), versionableHandle, componentHandle, 0, feedback);
            int size = changeSets.size();
            int count = 0;
            for (IChangeSetHandle changeSetHandle : changeSets) {
                int done = JzProvider.FB_BASE(31, 100, ++count, size);
                IChangeSet changeSet = (IChangeSet)repo.itemManager().fetchCompleteItem((IItemHandle)changeSetHandle, 1, JzProvider.getMonitor(feedback, done));
                List changes = changeSet.changes();
                IVersionableHandle result = null;
                for (IChange change : changes) {
                    IVersionableHandle afterStateHandle;
                    if (!change.item().sameItemId((IItemHandle)versionableHandle) || (result = change.beforeState()) != null || (afterStateHandle = change.afterState()) == null) continue;
                    IVersionable rootVersion = JzRepoRootVersion.fetchCompleteState(provider, afterStateHandle, feedback);
                    return (IVersionable)rootVersion.getWorkingCopy();
                }
            }
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
        throw new WvcmException(NLS.bind((String)Messages.JzRepoRootVersion_ERROR_FIND_ANY_STATE_OF_VERSIONABLE_FAILED_WITH_VH_LOCSTRING, (Object)vh.location().string(), (Object[])new Object[0]), WvcmException.ReasonCode.FORBIDDEN);
    }

    private static List<IChangeSetHandle> findChangeSets(IWorkspaceManager workspaceManager, IVersionableHandle versionableHandle, IComponentHandle componentHandle, int flags, SrvcFeedback feedback) throws TeamRepositoryException {
        IChangeSetSearchCriteria criteria = IChangeSetSearchCriteria.FACTORY.newInstance();
        criteria.setComponent(componentHandle);
        criteria.setItem(versionableHandle);
        if (flags != 0) {
            criteria.setChangeType(flags);
        }
        List changeSets = workspaceManager.findChangeSets(criteria, 512, JzProvider.getMonitor(feedback, 30));
        return changeSets;
    }

    public JzLocation getComponentLocation() throws WvcmException {
        return this.location().getVersionHistoryLocation().getComponentLocation();
    }
}

