/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.model;

import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.internal.common.model.AbstractModel;
import com.ibm.team.process.internal.common.model.BuildContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public abstract class AbstractElement
extends ModelElement {
    private AbstractElement fParent;
    private List fChildElements = new ArrayList();
    private String fName;
    private String fNamespaceURI;
    private int fStartOffset = -1;
    private int fStartTagEndOffset = -1;
    private int fEndOffset = -1;
    private int fSelectionStartOffset = -1;
    private int fSelectionLength = -1;
    protected final Map fAttributes;
    private String fCharacterData;

    protected AbstractElement(AbstractElement parent, String namespaceURI, String name, Attributes attributes) {
        this.fParent = parent;
        this.fName = name;
        this.fNamespaceURI = namespaceURI;
        this.fAttributes = this.createAttributeCache(attributes);
    }

    public void setOffsetsForStart(BuildContext context) {
        AbstractElement root;
        if (context != null && (root = context.getContextRootElement()) instanceof AbstractModel) {
            AbstractModel model = (AbstractModel)root;
            Locator locator = context.getLocator();
            int lineNumber = locator.getLineNumber() - 1;
            int columnNumber = locator.getColumnNumber();
            if (lineNumber < 0) {
                lineNumber = 0;
            }
            IDocument document = model.getCurrentDocument();
            try {
                int currentLine = lineNumber;
                int length = -1;
                while (currentLine >= 0) {
                    int lineOffset = document.getLineOffset(currentLine);
                    String line = document.get(lineOffset, length = currentLine == lineNumber && columnNumber > 0 ? columnNumber : document.getLineLength(currentLine) - 1);
                    int index = this.findStartTagIndex(line, this.getName());
                    if (index >= 0) {
                        this.setStartOffset(lineOffset + index);
                        if (columnNumber == -1) {
                            String elementText = document.get(this.fStartOffset, document.getLineOffset(lineNumber) + document.getLineLength(lineNumber));
                            this.setStartTagEndOffset(this.fStartOffset + elementText.indexOf(62));
                        } else {
                            this.setStartTagEndOffset(document.getLineOffset(lineNumber) + columnNumber - 2);
                        }
                        this.setSelectionStartOffset(this.getStartOffset() + 1);
                        this.setSelectionLength(0);
                        break;
                    }
                    --currentLine;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private int findStartTagIndex(String text, String tagName) {
        int currentIndex = text.lastIndexOf(tagName);
        while (currentIndex > 0) {
            char c;
            if ((c = text.charAt(--currentIndex)) == '<') {
                return currentIndex;
            }
            if (c == ':') {
                --currentIndex;
                do {
                    if ((c = text.charAt(currentIndex)) != '<') continue;
                    return currentIndex;
                } while (--currentIndex >= 0 && !Character.isWhitespace(c));
            }
            currentIndex = text.lastIndexOf(tagName, currentIndex);
        }
        return -1;
    }

    public void setOffsetsForEnd(BuildContext context) {
        this.setEndOffset(context);
    }

    public void setStartTagEndOffset(int offset) {
        this.fStartTagEndOffset = offset;
    }

    public void setStartOffset(int offset) {
        this.fStartOffset = offset;
    }

    public void setSelectionStartOffset(int offset) {
        this.fSelectionStartOffset = offset;
    }

    public void setSelectionLength(int length) {
        this.fSelectionLength = length;
    }

    public void setEndOffset(int offset) {
        this.fEndOffset = offset;
    }

    public void setEndOffset(BuildContext context) {
        AbstractElement contextRoot;
        if (context != null && (contextRoot = context.getContextRootElement()) instanceof AbstractModel) {
            AbstractModel model = (AbstractModel)contextRoot;
            IDocument currentDocument = model.getCurrentDocument();
            Locator locator = context.getLocator();
            int lineNumber = locator.getLineNumber() - 1;
            int columnNumber = locator.getColumnNumber();
            try {
                if (lineNumber < 0) {
                    lineNumber = 0;
                }
                if (columnNumber < 0) {
                    columnNumber = currentDocument.getLineLength(lineNumber);
                }
                this.setEndOffset(currentDocument.getLineOffset(lineNumber) + columnNumber - 1);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    @Override
    public int getStartOffset() {
        return this.fStartOffset;
    }

    @Override
    public int getStartTagEndOffset() {
        return this.fStartTagEndOffset;
    }

    public int getSelectionStartOffset() {
        return this.fSelectionStartOffset;
    }

    public int getSelectionLength() {
        return this.fSelectionLength;
    }

    @Override
    public int getEndOffset() {
        return this.fEndOffset;
    }

    public AbstractElement addChildElement(AbstractElement child) {
        this.fChildElements.add(child);
        return child;
    }

    @Override
    public AbstractElement getParentElement() {
        return this.fParent;
    }

    public void setParent(AbstractElement parent) {
        this.fParent = parent;
    }

    @Override
    public List getChildElements() {
        return this.fChildElements;
    }

    public boolean clearChildElements() {
        if (this.fChildElements.isEmpty()) {
            return false;
        }
        this.fChildElements.clear();
        return true;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    public void appendElement(Element parent, Document document) {
        Element element = document.createElement(this.fName);
        this.addAttributes(element);
        parent.appendChild(element);
        Iterator childIter = this.getChildElements().iterator();
        while (childIter.hasNext()) {
            ((AbstractElement)childIter.next()).appendElement(element, document);
        }
    }

    @Override
    public String getNamespaceURI() {
        return this.fNamespaceURI;
    }

    private Map createAttributeCache(Attributes attributes) {
        if (attributes == null) {
            return new HashMap(0);
        }
        int cacheSize = attributes.getLength();
        ConcurrentHashMap<String, Attribute> cache = new ConcurrentHashMap<String, Attribute>(cacheSize, 1.0f, 1);
        int i = 0;
        while (i < cacheSize) {
            Attribute attribute = new Attribute();
            attribute.qName = attributes.getQName(i);
            attribute.type = attributes.getType(i);
            attribute.value = attributes.getValue(i);
            cache.put(attribute.qName, attribute);
            ++i;
        }
        return cache;
    }

    @Override
    public String getAttribute(String name) {
        Attribute attribute;
        if (name != null && (attribute = (Attribute)this.fAttributes.get(name)) != null) {
            return attribute.value;
        }
        return null;
    }

    public void modifyAttribute(String name, String value) {
        if (name != null) {
            Attribute attribute = (Attribute)this.fAttributes.get(name);
            if (attribute != null) {
                attribute.value = value;
            } else {
                attribute = new Attribute();
                attribute.qName = name;
                attribute.value = value;
                this.fAttributes.put(name, attribute);
            }
        }
    }

    public String[] getAttributeNames() {
        Set keys = this.fAttributes.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    protected void addAttributes(Element element) {
        for (Map.Entry entry : this.fAttributes.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((Attribute)entry.getValue()).value;
            element.setAttribute(key, value);
        }
    }

    public String getCharacterData() {
        return this.fCharacterData;
    }

    public void setCharacterData(String characters) {
        this.fCharacterData = characters;
    }

    public final String toXML(String prefix, String lineDelimiter) {
        if (prefix == null) {
            prefix = "";
        }
        if (lineDelimiter == null) {
            lineDelimiter = "";
        }
        StringBuilder sb = new StringBuilder();
        this.toXML(prefix, lineDelimiter, sb, false);
        return sb.toString();
    }

    public final void toXML(String prefix, String lineDelimiter, StringBuilder sb) {
        if (prefix == null) {
            prefix = "";
        }
        if (lineDelimiter == null) {
            lineDelimiter = "";
        }
        this.toXML(prefix, lineDelimiter, sb, true);
    }

    protected void toXML(String prefix, String lineDelimiter, StringBuilder sb, boolean appendPrefix) {
        this.toXML(prefix, lineDelimiter, null, sb, appendPrefix, false);
    }

    protected final void toXML(String prefix, String lineDelimiter, String idAttribute, StringBuilder sb, boolean appendPrefix) {
        this.toXML(prefix, lineDelimiter, new String[]{idAttribute}, sb, appendPrefix, false);
    }

    protected final void toXML(String prefix, String lineDelimiter, String[] attributeNames, StringBuilder sb, boolean appendPrefix, boolean allowSelfTerminating) {
        if (appendPrefix) {
            sb.append(prefix);
        }
        sb.append('<').append(this.getName());
        if (attributeNames != null) {
            String[] stringArray = attributeNames;
            int n = attributeNames.length;
            int n2 = 0;
            while (n2 < n) {
                String attributeName = stringArray[n2];
                this.appendXmlAttribute(attributeName, sb);
                ++n2;
            }
        }
        if (this.getChildElements().isEmpty() && allowSelfTerminating) {
            sb.append("/>").append(lineDelimiter);
        } else {
            sb.append(">").append(lineDelimiter);
            this.childrenToXML(prefix, lineDelimiter, sb);
            sb.append(prefix).append("</").append(this.getName()).append(">").append(lineDelimiter);
        }
    }

    protected final void appendXmlAttribute(String attributeName, StringBuilder sb) {
        if (attributeName != null) {
            this.appendXmlAttribute(attributeName, this.getAttribute(attributeName), sb);
        }
    }

    protected final void appendXmlAttribute(String attributeName, String attributeValue, StringBuilder sb) {
        if (attributeName != null && attributeValue != null) {
            sb.append(' ').append(attributeName).append("=\"").append(this.escapeXML(attributeValue)).append('\"');
        }
    }

    protected final void childrenToXML(String prefix, String lineDelimiter, StringBuilder sb) {
        String childPrefix = String.valueOf(prefix) + '\t';
        for (AbstractElement child : this.getChildElements()) {
            child.toXML(childPrefix, lineDelimiter, sb);
        }
    }

    protected String escapeXML(String plainText) {
        if (plainText == null) {
            return plainText;
        }
        String xmlText = plainText;
        xmlText = xmlText.replace("&", "&amp;");
        xmlText = xmlText.replace("\"", "&quot;");
        xmlText = xmlText.replace("<", "&lt;");
        xmlText = xmlText.replace(">", "&gt;");
        xmlText = xmlText.replace("\r\n", "&#10;");
        xmlText = xmlText.replace("\n", "&#10;");
        xmlText = xmlText.replace("\r", "&#13;");
        xmlText = xmlText.replace("\u00a0", "&#160;");
        return xmlText;
    }

    public String toString() {
        return this.toXML(null, null);
    }

    protected static class Attribute {
        String qName;
        String type;
        String value;

        protected Attribute() {
        }
    }
}

