/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.urelease.plugin.rtc;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.Application;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthServiceProvider;
import net.oauth.client.OAuthClient;
import net.oauth.client.httpclient4.HttpClient4;
import org.apache.log4j.Logger;
import org.apache.wink.client.ClientConfig;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.RestClient;
import org.eclipse.lyo.client.oslc.OAuthRedirectException;
import org.eclipse.lyo.client.oslc.OslcOAuthClient;
import org.eclipse.lyo.oslc4j.provider.jena.JenaProvidersRegistry;

public class OslcOAuthDefaultClient
extends OslcOAuthClient {
    private static Logger LOGGER = Logger.getLogger(OslcOAuthDefaultClient.class);
    private OAuthAccessor accessor;
    private String oauth_real_name;

    public OslcOAuthDefaultClient(OAuthAccessor accessor, OAuthServiceProvider provider) {
        super(accessor.requestToken, accessor.accessToken, provider.requestTokenURL, provider.accessTokenURL, accessor.consumer.consumerKey, accessor.consumer.consumerSecret);
        this.accessor = accessor;
    }

    public ClientResponse getResource(String url, String mediaType) throws IOException, OAuthException, URISyntaxException {
        OAuthMessage message = this.getResourceInternal(url, "GET", false);
        String realm = "Jazz";
        if (this.oauth_real_name != null) {
            realm = this.oauth_real_name;
        }
        String authHeader = message.getAuthorizationHeader(realm);
        ClientConfig config = this.getClientConfig();
        Application app = new Application(){

            @Override
            public Set<Class<?>> getClasses() {
                HashSet classes = new HashSet();
                classes.addAll(JenaProvidersRegistry.getProviders());
                return classes;
            }
        };
        config = config.applications(app);
        RestClient restClient = new RestClient(config);
        return restClient.resource(url).accept(mediaType).header("Authorization", authHeader).header("OSLC-Core-Version", "2.0").get();
    }

    public ClientResponse getResource(String url, String mediaType, String version2) throws IOException, OAuthException, URISyntaxException {
        OAuthMessage message = this.getResourceInternal(url, "GET", false);
        String realm = "Jazz";
        if (this.oauth_real_name != null) {
            realm = this.oauth_real_name;
        }
        String authHeader = message.getAuthorizationHeader(realm);
        ClientConfig config = this.getClientConfig();
        Application app = new Application(){

            @Override
            public Set<Class<?>> getClasses() {
                HashSet classes = new HashSet();
                classes.addAll(JenaProvidersRegistry.getProviders());
                return classes;
            }
        };
        config = config.applications(app);
        RestClient restClient = new RestClient(config);
        return restClient.resource(url).accept(mediaType).header("Authorization", authHeader).header("OSLC-Core-Version", version2).get();
    }

    private OAuthMessage getResourceInternal(String url, String httpMethod, boolean restart) throws IOException, OAuthException, URISyntaxException {
        OAuthClient client = new OAuthClient(new HttpClient4(this.getClientPool()));
        if (this.accessor.requestToken == null) {
            client.getRequestToken(this.accessor);
            System.out.println("Enter this URL in a browser and run again: " + this.accessor.consumer.serviceProvider.userAuthorizationURL + "?oauth_token=" + this.accessor.requestToken);
            throw new OAuthRedirectException(this.accessor.consumer.serviceProvider.userAuthorizationURL, this.accessor);
        }
        if (this.accessor.accessToken == null) {
            try {
                client.getAccessToken(this.accessor, "POST", null);
            }
            catch (OAuthException e) {
                LOGGER.debug("OAuthException caught: " + e.getMessage());
                if (restart) {
                    LOGGER.error("Failed to get access key.");
                    e.printStackTrace();
                }
                this.accessor.accessToken = null;
                this.accessor.requestToken = null;
                return this.getResourceInternal(url, httpMethod, true);
            }
        }
        OAuthMessage message = this.accessor.newRequestMessage(httpMethod, url, null);
        return message;
    }

    public ClientResponse updateResource(String url, Object artifact, String mediaType, String acceptType, String ifMatch) throws IOException, OAuthException, URISyntaxException {
        OAuthMessage message = this.getResourceInternal(url, "PUT", false);
        String realm = "Jazz";
        if (this.oauth_real_name != null) {
            realm = this.oauth_real_name;
        }
        String authHeader = message.getAuthorizationHeader(realm);
        ClientConfig config = this.getClientConfig();
        Application app = new Application(){

            @Override
            public Set<Class<?>> getClasses() {
                HashSet classes = new HashSet();
                classes.addAll(JenaProvidersRegistry.getProviders());
                return classes;
            }
        };
        config = config.applications(app);
        RestClient restClient = new RestClient(config);
        return restClient.resource(url).contentType(mediaType).accept(acceptType).header("Authorization", authHeader).header("If-Match", ifMatch).header("OSLC-Core-Version", "2.0").header("If-Match", ifMatch).put(artifact);
    }
}

