/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.registry.metadata;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import org.apache.wink.common.internal.registry.Injectable;
import org.apache.wink.common.internal.registry.metadata.AbstractMetadata;
import org.apache.wink.common.internal.registry.metadata.ConstructorMetadata;
import org.apache.wink.common.internal.registry.metadata.MethodMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMetadata
extends AbstractMetadata {
    private final Class<?> resourceClass;
    private String workspaceName;
    private String collectionTitle;
    private List<Class<?>> parents;
    private List<Object> parentInstances;
    private ConstructorMetadata constructor;
    private List<MethodMetadata> resourceMethods;
    private List<MethodMetadata> subResourceLocators;
    private List<MethodMetadata> subResourceMethods;
    private List<Injectable> injectableFields;
    private final BeanInfo beanInfo;

    ClassMetadata(Class<?> resourceClass) {
        this.resourceClass = resourceClass;
        this.constructor = null;
        this.parents = new ArrayList();
        this.resourceMethods = new ArrayList<MethodMetadata>();
        this.subResourceLocators = new ArrayList<MethodMetadata>();
        this.subResourceMethods = new ArrayList<MethodMetadata>();
        this.parentInstances = new ArrayList<Object>();
        this.injectableFields = new ArrayList<Injectable>();
        try {
            this.beanInfo = Introspector.getBeanInfo(resourceClass);
        }
        catch (IntrospectionException e) {
            throw new WebApplicationException(e);
        }
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public String getCollectionTitle() {
        return this.collectionTitle;
    }

    public void setCollectionTitle(String collectionTitle) {
        this.collectionTitle = collectionTitle;
    }

    public Class<?> getParent() {
        if (this.getParents().size() == 0) {
            return null;
        }
        return this.getParents().get(0);
    }

    public Object getParentInstance() {
        if (this.getParentInstances().size() == 0) {
            return null;
        }
        return this.getParentInstances().get(0);
    }

    public List<Class<?>> getParents() {
        return this.parents;
    }

    public List<Object> getParentInstances() {
        return this.parentInstances;
    }

    public ConstructorMetadata getConstructor() {
        return this.constructor;
    }

    public void setConstructor(ConstructorMetadata constructor) {
        this.constructor = constructor;
    }

    public List<MethodMetadata> getResourceMethods() {
        return this.resourceMethods;
    }

    public List<MethodMetadata> getSubResourceLocators() {
        return this.subResourceLocators;
    }

    public List<MethodMetadata> getSubResourceMethods() {
        return this.subResourceMethods;
    }

    public void setParentInstances(List<Object> parentResourceInstances) {
        this.parentInstances = parentResourceInstances;
    }

    public List<Injectable> getInjectableFields() {
        return this.injectableFields;
    }

    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    @Override
    public String toString() {
        return String.format("Class: %s", this.resourceClass.toString().replace("class ", ""));
    }
}

