/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.model.atom;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.wink.common.internal.model.AnyContentHandler;
import org.apache.wink.common.internal.model.ModelUtils;
import org.apache.wink.common.model.atom.AtomCommonAttributes;
import org.apache.wink.common.model.atom.AtomTextType;
import org.apache.wink.common.model.synd.SyndText;
import org.apache.wink.common.model.synd.SyndTextType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="atomText", propOrder={"any"})
public class AtomText
extends AtomCommonAttributes {
    @XmlTransient
    private List<Object> any;
    @XmlAttribute
    protected AtomTextType type;
    @XmlTransient
    private String savedValue = null;

    @XmlMixed
    @XmlAnyElement(lax=true, value=AnyContentHandler.class)
    List<Object> getAny() {
        ModelUtils.fixAnyContent(this.any, this.type == null ? null : this.type.name());
        return this.any;
    }

    void setAny(List<Object> any) {
        this.any = any;
    }

    public AtomText() {
    }

    public AtomText(String value) {
        this(value, AtomTextType.text);
    }

    public AtomText(String value, AtomTextType type) {
        this.setType(type);
        this.setValue(value);
    }

    public AtomText(SyndText value) {
        super(value);
        if (value == null) {
            return;
        }
        if (value.getType() != null) {
            this.setType(AtomTextType.valueOf(value.getType().toString()));
        }
        this.setValue(value.getValue(Object.class));
    }

    public SyndText toSynd(SyndText value) {
        if (value == null) {
            return value;
        }
        super.toSynd(value);
        if (this.getType() != null) {
            value.setType(SyndTextType.valueOf(this.getType().toString()));
        }
        value.setValue(this.getValue(Object.class));
        return value;
    }

    public void setValue(Object value) {
        this.any = value != null ? Arrays.asList(value) : null;
    }

    public String getValue() {
        return this.getValue(String.class);
    }

    public <T> T getValue(Class<T> cls) {
        try {
            return this.getValue(cls, cls, null, ModelUtils.EMPTY_ARRAY, ModelUtils.EMPTY_STRING_MAP, ModelUtils.determineMediaType(this.type == null ? null : this.type.name()));
        }
        catch (IOException e) {
            throw new WebApplicationException(e);
        }
    }

    public <T> T getValue(Class<T> cls, Type genericType, Providers providers, Annotation[] annotations, MultivaluedMap<String, String> httpHeaders, MediaType mediaType) throws IOException {
        return ModelUtils.readValue(this.getAny(), cls, providers, genericType, annotations, httpHeaders, mediaType);
    }

    public AtomTextType getType() {
        return this.type;
    }

    public void setType(AtomTextType type) {
        this.type = type;
    }

    void revertValue() {
        this.setValue(this.savedValue);
        this.savedValue = null;
    }

    String saveValue() {
        this.savedValue = this.getValue();
        this.setValue(null);
        return this.savedValue;
    }
}

