/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.core.query.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.lyo.core.query.ComparisonTerm;
import org.eclipse.lyo.core.query.CompoundTerm;
import org.eclipse.lyo.core.query.InTerm;
import org.eclipse.lyo.core.query.SimpleTerm;
import org.eclipse.lyo.core.query.impl.ComparisonTermInvocationHandler;
import org.eclipse.lyo.core.query.impl.InTermInvocationHandler;
import org.eclipse.lyo.core.query.impl.SimpleTermInvocationHandler;

public class CompoundTermInvocationHandler
extends SimpleTermInvocationHandler {
    private final CommonTree tree;
    private final boolean isTopLevel;
    private List<SimpleTerm> children = null;

    public CompoundTermInvocationHandler(CommonTree tree, boolean isTopLevel, Map<String, String> prefixMap) {
        super(isTopLevel ? null : tree, isTopLevel ? SimpleTerm.Type.TOP_LEVEL : SimpleTerm.Type.NESTED, prefixMap);
        this.tree = tree;
        this.isTopLevel = isTopLevel;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        boolean isChildren = methodName.equals("children");
        if (!isChildren && !methodName.equals("toString")) {
            return super.invoke(proxy, method, args);
        }
        if (this.children != null) {
            return this.children;
        }
        List treeChildren = this.isTopLevel ? this.tree.getChildren() : ((CommonTree)this.tree.getChild(1)).getChildren();
        this.children = new ArrayList<SimpleTerm>(treeChildren.size() - (this.isTopLevel ? 0 : 1));
        for (CommonTree child : treeChildren) {
            Object simpleTerm;
            switch (child.getToken().getType()) {
                case 4: {
                    simpleTerm = Proxy.newProxyInstance(ComparisonTerm.class.getClassLoader(), new Class[]{ComparisonTerm.class}, (InvocationHandler)new ComparisonTermInvocationHandler(child, this.prefixMap));
                    break;
                }
                case 5: {
                    simpleTerm = Proxy.newProxyInstance(InTerm.class.getClassLoader(), new Class[]{InTerm.class}, (InvocationHandler)new InTermInvocationHandler(child, this.prefixMap));
                    break;
                }
                case 6: {
                    simpleTerm = Proxy.newProxyInstance(CompoundTerm.class.getClassLoader(), new Class[]{CompoundTerm.class}, (InvocationHandler)new CompoundTermInvocationHandler(child, false, (Map<String, String>)this.prefixMap));
                    break;
                }
                default: {
                    throw new IllegalStateException("unimplemented type of simple term: " + child.getToken().getText());
                }
            }
            this.children.add((SimpleTerm)simpleTerm);
        }
        this.children = Collections.unmodifiableList(this.children);
        if (isChildren) {
            return this.children;
        }
        StringBuffer buffer = new StringBuffer();
        if (!this.isTopLevel) {
            buffer.append(((CompoundTerm)proxy).property().toString());
            buffer.append('{');
        }
        boolean first = true;
        for (SimpleTerm term : this.children) {
            if (first) {
                first = false;
            } else {
                buffer.append(" and ");
            }
            buffer.append(term.toString());
        }
        if (!this.isTopLevel) {
            buffer.append('}');
        }
        return buffer.toString();
    }
}

