/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.content;

import com.ibm.team.repository.common.transport.TeamServiceCallContextImpl;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpMethod;
import org.eclipse.core.runtime.IProgressMonitor;

public class ReleasingAndAbortingCancellableInputStream
extends InputStream {
    private HttpMethod method;
    private final IProgressMonitor monitor;
    private TeamServiceCallContextImpl ctx;
    private Thread ctxThread;
    private InputStream in;
    private boolean eofReached;

    public ReleasingAndAbortingCancellableInputStream(HttpMethod method, TeamServiceCallContextImpl ctx, IProgressMonitor monitor) throws IOException {
        this.in = method.getResponseBodyAsStream();
        this.monitor = monitor;
        this.method = method;
        this.ctx = ctx;
        this.ctxThread = ctx == null ? null : Thread.currentThread();
    }

    protected void pushContext() {
        if (this.ctx != null) {
            boolean mustPop = true;
            TeamServiceCallContextImpl.getCurrentStack().push(this.ctx);
            try {
                if (Thread.currentThread() != this.ctxThread) {
                    TeamServiceCallContextImpl.tearDownCall();
                    this.ctx = null;
                    TeamServiceCallContextImpl.popCallContext();
                    mustPop = false;
                    TeamServiceCallContextImpl.pushCallContext((IProgressMonitor)this.monitor);
                    mustPop = true;
                    this.ctx = TeamServiceCallContextImpl.getCurrent();
                    this.ctxThread = Thread.currentThread();
                    TeamServiceCallContextImpl.setUpCall((HttpMethod)this.method);
                }
                mustPop = false;
            }
            finally {
                if (mustPop) {
                    TeamServiceCallContextImpl.popCallContext();
                }
            }
        }
    }

    protected void popContext() {
        if (this.ctx != null) {
            TeamServiceCallContextImpl.popCallContext();
        }
    }

    protected void readError(IOException e) throws IOException {
        throw e;
    }

    @Override
    public int read() throws IOException {
        this.pushContext();
        while (true) {
            try {
                int bytesRead = this.in.read();
                this.eofReached = bytesRead == -1;
                int n = bytesRead;
                return n;
            }
            catch (IOException e) {
                this.eofReached = false;
                this.readError(e);
                continue;
            }
            break;
        }
        finally {
            this.popContext();
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.pushContext();
        while (true) {
            try {
                int bytesRead = this.in.read(b, off, len);
                this.eofReached = bytesRead == -1;
                int n = bytesRead;
                return n;
            }
            catch (IOException e) {
                this.eofReached = false;
                this.readError(e);
                continue;
            }
            break;
        }
        finally {
            this.popContext();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        this.pushContext();
        while (true) {
            try {
                long skipped = this.in.skip(n);
                if (skipped != 0L) {
                    this.eofReached = false;
                }
                long l = skipped;
                return l;
            }
            catch (IOException e) {
                this.eofReached = false;
                this.readError(e);
                continue;
            }
            break;
        }
        finally {
            this.popContext();
        }
    }

    @Override
    public int available() throws IOException {
        this.pushContext();
        try {
            int n = this.in.available();
            return n;
        }
        finally {
            this.popContext();
        }
    }

    protected void cleanupMethod() throws IOException {
        try {
            if (!this.eofReached) {
                this.method.abort();
            } else {
                this.in.close();
            }
        }
        finally {
            this.method.releaseConnection();
        }
    }

    protected void resetStream(HttpMethod method) throws IOException {
        this.cleanupMethod();
        this.in = method.getResponseBodyAsStream();
        this.method = method;
        this.eofReached = false;
    }

    @Override
    public void close() throws IOException {
        this.pushContext();
        try {
            this.cleanupMethod();
        }
        finally {
            if (this.ctx != null) {
                try {
                    TeamServiceCallContextImpl.tearDownCall();
                    this.ctx = null;
                }
                finally {
                    TeamServiceCallContextImpl.popCallContext();
                }
            }
        }
    }

    @Override
    public void mark(int readlimit) {
        this.pushContext();
        try {
            this.in.mark(readlimit);
        }
        finally {
            this.popContext();
        }
    }

    @Override
    public void reset() throws IOException {
        this.pushContext();
        try {
            this.in.reset();
        }
        finally {
            this.popContext();
        }
    }

    @Override
    public boolean markSupported() {
        this.pushContext();
        try {
            boolean bl = this.in.markSupported();
            return bl;
        }
        finally {
            this.popContext();
        }
    }
}

