/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.IChangeHistoryDescriptor;
import com.ibm.team.scm.client.internal.ClientChangeHistoryProxy;
import com.ibm.team.scm.client.internal.ClientChangeSetEntry;
import com.ibm.team.scm.client.internal.Connection;
import com.ibm.team.scm.common.IChangeHistoryEntryChange;
import com.ibm.team.scm.common.internal.ChangeHistoryEntry;
import com.ibm.team.scm.common.internal.ChangeHistoryHandle;
import com.ibm.team.scm.common.internal.ComponentHandle;
import com.ibm.team.scm.common.internal.dto.EraDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClientEraDescriptor
implements IChangeHistoryDescriptor {
    private final List<IChangeHistoryEntryChange> entries;
    private final ChangeHistoryHandle previous;
    private final Connection connection;
    private final ComponentHandle component;

    public ClientEraDescriptor(EraDescriptor descriptor, Connection connection, ComponentHandle component) {
        this.previous = descriptor.getPreviousEra();
        this.connection = connection;
        this.component = component;
        this.entries = new ArrayList<IChangeHistoryEntryChange>(descriptor.getRecentEntries().size());
        for (ChangeHistoryEntry e : descriptor.getRecentEntries()) {
            this.entries.add(new ClientChangeSetEntry(e));
        }
    }

    @Override
    public IChangeHistory previousHistory() throws TeamRepositoryException {
        if (this.previous == null) {
            return null;
        }
        ClientChangeHistoryProxy history = new ClientChangeHistoryProxy(this.connection, this.component, false);
        history.setHistoryHandle(this.previous, false);
        return history;
    }

    @Override
    public List<IChangeHistoryEntryChange> recent() throws TeamRepositoryException {
        return Collections.unmodifiableList(this.entries);
    }
}

