/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Cache<K, V> {
    private final ReferenceQueue<V> dereferencedKeys = new ReferenceQueue();
    private final ConcurrentMap<K, Reference<V>> cache = new ConcurrentHashMap<K, Reference<V>>();

    private void pruneEmptyReferences() {
        Reference<V> ref;
        while ((ref = this.dereferencedKeys.poll()) != null) {
            KeyedReference cRef = (KeyedReference)((Object)ref);
            this.cache.remove(cRef.getKey(), ref);
        }
    }

    protected boolean shouldRemoveFromCache(V existingEntry) {
        return false;
    }

    protected boolean shouldReplaceEntry(V oldValue, V newValue) {
        return false;
    }

    protected boolean cache(K key, V value) {
        this.pruneEmptyReferences();
        Reference<V> ref = this.createReference(key, value, this.dereferencedKeys);
        Reference<V> existingRef = this.cache.putIfAbsent(key, ref);
        if (existingRef != null) {
            V existingEntry = existingRef.get();
            if (existingEntry != null && !this.shouldReplaceEntry(existingEntry, value)) {
                return false;
            }
            return this.cache.replace(key, existingRef, ref);
        }
        return true;
    }

    protected V getCacheEntry(K lookupKey) {
        Object cacheEntry;
        Reference cachedRef;
        block3: {
            boolean removed;
            this.pruneEmptyReferences();
            do {
                if ((cachedRef = (Reference)this.cache.get(lookupKey)) == null) {
                    return null;
                }
                cacheEntry = cachedRef.get();
                if (cacheEntry == null) {
                    return null;
                }
                if (!this.shouldRemoveFromCache(cacheEntry)) break block3;
            } while (!(removed = this.cache.remove(lookupKey, cachedRef)));
            return null;
        }
        Reference newRef = this.createReference(lookupKey, cacheEntry, this.dereferencedKeys);
        this.cache.replace(lookupKey, cachedRef, newRef);
        return (V)cacheEntry;
    }

    protected void invalidateMatchingKeys(IKeyMatcher matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException("The matcher must not be null");
        }
        Set entrySet = this.cache.entrySet();
        Iterator iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object lookupKey = entry.getKey();
            if (!matcher.doesKeyMatch(lookupKey)) continue;
            iterator.remove();
        }
    }

    protected Reference<V> createReference(K key, V value, ReferenceQueue<V> queue) {
        return new CustomReference<K, V>(key, value, queue);
    }

    private static class CustomReference<K, V>
    extends SoftReference<V>
    implements KeyedReference<K> {
        private final K key;

        CustomReference(K key, V entry, ReferenceQueue<V> queue) {
            super(entry, queue);
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }
    }

    protected static interface IKeyMatcher<K> {
        public boolean doesKeyMatch(K var1);
    }

    protected static interface KeyedReference<K> {
        public K getKey();
    }
}

