/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.content;

import com.ibm.team.repository.common.internal.content.RandomAccessContentSource;
import com.ibm.team.repository.common.internal.nls.Messages;
import java.io.IOException;

public class ByteArrayContentSource
implements RandomAccessContentSource {
    protected byte[] bytes;

    public ByteArrayContentSource(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public void copyBytes(byte[] toArray, long offset, int length) throws IOException {
        this.offsetCopyBytes(toArray, 0, offset, length);
    }

    @Override
    public void offsetCopyBytes(byte[] toArray, int targetOffset, long offset, int length) throws IOException {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        if (offset + (long)length > (long)this.bytes.length) {
            throw new IOException(Messages.getServerString("ByteArrayContentSource.ErrorOutOfRange"));
        }
        System.arraycopy(this.bytes, (int)offset, toArray, targetOffset, length);
    }

    @Override
    public byte getByte(long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        if (position > (long)this.bytes.length) {
            throw new IOException(Messages.getServerString("ByteArrayContentSource.ErrorPosition"));
        }
        return this.bytes[(int)position];
    }

    @Override
    public byte[] getBytes(long offset, int length) throws IOException {
        byte[] result = new byte[length];
        this.offsetCopyBytes(result, 0, offset, length);
        return result;
    }

    @Override
    public long getLength() throws IOException {
        return this.bytes.length;
    }

    @Override
    public void close() {
    }
}

