/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.content.util;

import com.ibm.team.repository.common.internal.content.util.CachedDiskBackedHashMap;
import com.ibm.team.repository.common.utils.UnsynchronizedByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class PartialTarEntryCachedDiskBackedHashMap<K, V>
extends CachedDiskBackedHashMap<K, V> {
    private static final int UUID_CHAR_LENGTH = 23;

    public PartialTarEntryCachedDiskBackedHashMap(long initialCapacity) {
        super(initialCapacity);
    }

    @Override
    protected long writeObject(Object o, int flags) throws IOException {
        if (this.isKey(flags)) {
            return this.writeKeyObject(o, flags);
        }
        return this.writeValueObject(o, flags);
    }

    private long writeKeyObject(Object o, int flags) throws IOException {
        if (!(o instanceof String)) {
            throw new IllegalArgumentException("keys must be Strings");
        }
        String st = (String)o;
        if (st.length() != 23) {
            throw new IllegalArgumentException("key is wrong length:  " + st);
        }
        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream();
        try {
            long l;
            ObjectOutputStream objOut = new ObjectOutputStream(out);
            try {
                objOut.writeBytes(st);
                objOut.flush();
                long offset = this.heap.allocate(out.size());
                out.writeTo(this.heap.getOutputStream(offset));
                l = offset;
            }
            catch (Throwable throwable) {
                objOut.close();
                throw throwable;
            }
            objOut.close();
            return l;
        }
        finally {
            out.close();
        }
    }

    private long writeValueObject(Object o, int flags) throws IOException {
        if (!(o instanceof Long[])) {
            throw new IllegalArgumentException("values must be arrays of Long of length 2");
        }
        Long[] longs = (Long[])o;
        if (longs.length != 2) {
            throw new IllegalArgumentException("values must be arrays of Long of length 2");
        }
        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream();
        try {
            long l;
            ObjectOutputStream objOut = new ObjectOutputStream(out);
            try {
                objOut.writeLong(longs[0]);
                objOut.writeLong(longs[1]);
                objOut.flush();
                long offset = this.heap.allocate(out.size());
                out.writeTo(this.heap.getOutputStream(offset));
                l = offset;
            }
            catch (Throwable throwable) {
                objOut.close();
                throw throwable;
            }
            objOut.close();
            return l;
        }
        finally {
            out.close();
        }
    }

    @Override
    protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
        if (this.isKey(flags)) {
            return this.readKeyObject(in, flags);
        }
        return this.readValueObject(in, flags);
    }

    private Object readKeyObject(InputStream in, int flags) throws IOException {
        ObjectInputStream objIn = new ObjectInputStream(in);
        byte[] b = new byte[23];
        objIn.readFully(b);
        return new String(b);
    }

    private Object readValueObject(InputStream in, int flags) throws IOException {
        Long[] longs = new Long[2];
        ObjectInputStream objIn = new ObjectInputStream(in);
        longs[0] = objIn.readLong();
        longs[1] = objIn.readLong();
        return longs;
    }

    private boolean isKey(int flags) {
        return (flags & 1) > 0;
    }
}

