/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.transport;

import com.ibm.team.repository.common.transport.ICancelableRunnable;
import com.ibm.team.repository.common.transport.TeamServiceCallContextImpl;
import java.lang.reflect.Field;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.SubMonitor;

public class CancelableCaller {
    public static void call(IProgressMonitor progressMonitor, ICancelableRunnable runnable) {
        boolean real = CancelableCaller.isReal(progressMonitor);
        if (real) {
            TeamServiceCallContextImpl.pushCallContext(progressMonitor);
        }
        try {
            runnable.run(progressMonitor);
        }
        finally {
            if (real) {
                TeamServiceCallContextImpl.popCallContext();
            }
        }
    }

    private static boolean isReal(IProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            return false;
        }
        boolean real = true;
        IProgressMonitor outer = progressMonitor;
        while (outer != null) {
            if (outer instanceof NullProgressMonitor) {
                real = false;
                outer = null;
                continue;
            }
            if (outer instanceof ProgressMonitorWrapper) {
                outer = ((ProgressMonitorWrapper)outer).getWrappedProgressMonitor();
                continue;
            }
            if (outer instanceof SubMonitor) {
                try {
                    Field f = SubMonitor.class.getDeclaredField("root");
                    f.setAccessible(true);
                    Object rootInfo = f.get(outer);
                    f = rootInfo.getClass().getDeclaredField("root");
                    f.setAccessible(true);
                    outer = (IProgressMonitor)f.get(rootInfo);
                }
                catch (Exception exception) {
                    outer = null;
                }
                continue;
            }
            outer = null;
        }
        return real;
    }

    private CancelableCaller() {
    }
}

