/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.streams;

import java.io.IOException;
import java.io.OutputStream;

public class LengthCountingOutputStream
extends OutputStream {
    private final OutputStream out;
    private long size;

    public LengthCountingOutputStream(OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException();
        }
        this.out = out;
    }

    public long getContentSize() {
        return this.size;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.size;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.size += (long)len;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

