/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.model.specification;

import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.internal.common.model.AbstractElement;
import com.ibm.team.process.internal.common.model.settings.ProcessConfigurationElement;
import java.util.Arrays;
import java.util.List;
import org.xml.sax.Attributes;

public class ConfigurationDataElement
extends AbstractElement
implements IProcessConfigurationData {
    private boolean fIsFinal;
    private boolean fIsInheritedFromProcessProvider = false;

    public ConfigurationDataElement(AbstractElement parent, String namespaceURI, String localName, Attributes attributes) {
        super(parent, namespaceURI, localName, attributes);
        if (attributes != null) {
            this.processAttributes(attributes);
        }
    }

    private void processAttributes(Attributes attributes) {
        this.fIsFinal = Boolean.parseBoolean(attributes.getValue("final"));
    }

    @Override
    public String getId() {
        return this.getAttribute("id");
    }

    @Override
    public IProcessConfigurationElement[] getElements() {
        List children = this.getChildElements();
        return children.toArray(new IProcessConfigurationElement[children.size()]);
    }

    public boolean isInheritedFromProcessProvider() {
        return this.fIsInheritedFromProcessProvider;
    }

    public void setIsInheritedFromProcessProvider(boolean isInheritedFromProcessProvider) {
        this.fIsInheritedFromProcessProvider = isInheritedFromProcessProvider;
    }

    @Override
    protected void toXML(String prefix, String lineDelimiter, StringBuilder sb, boolean appendPrefix) {
        if (appendPrefix) {
            sb.append(prefix);
        }
        String name = this.getName();
        sb.append('<').append(name);
        Object[] attributeNames = this.getAttributeNames();
        Arrays.sort(attributeNames);
        Object[] objectArray = attributeNames;
        int n = attributeNames.length;
        int n2 = 0;
        while (n2 < n) {
            Object attributeName = objectArray[n2];
            this.appendXmlAttribute((String)attributeName, sb);
            ++n2;
        }
        IProcessConfigurationElement[] children = this.getElements();
        String characterData = this.getCharacterData();
        if (children.length == 0 && characterData == null) {
            sb.append("/>").append(lineDelimiter);
        } else {
            sb.append('>').append(lineDelimiter);
            if (characterData != null) {
                characterData = this.escapeXML(characterData);
                sb.append(String.valueOf(prefix) + '\t').append(characterData).append(lineDelimiter);
            }
            int i = 0;
            while (i < children.length) {
                IProcessConfigurationElement child = children[i];
                ((ProcessConfigurationElement)child).toXML(String.valueOf(prefix) + '\t', lineDelimiter, sb);
                ++i;
            }
            sb.append(prefix).append("</").append(name).append('>').append(lineDelimiter);
        }
    }

    public boolean isFinal() {
        return this.fIsFinal;
    }

    public void setIsFinal(boolean isFinal) {
        this.fIsFinal = isFinal;
    }
}

