/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.common.service.ProcessDataValidationException;
import com.ibm.team.process.internal.common.model.AbstractElement;
import com.ibm.team.process.internal.common.model.settings.ProcessConfigurationElement;
import com.ibm.team.process.internal.common.model.specification.AddElement;
import com.ibm.team.process.internal.common.model.specification.AdditionElement;
import com.ibm.team.process.internal.common.model.specification.ConfigurationDataDeltaElement;
import com.ibm.team.process.internal.common.model.specification.ConfigurationDataElement;
import com.ibm.team.process.internal.common.model.specification.ModifyElement;
import com.ibm.team.process.internal.common.model.specification.PathElement;
import com.ibm.team.process.internal.common.model.specification.RemoveAttribute;
import com.ibm.team.process.internal.common.model.specification.SetAttribute;
import com.ibm.team.process.internal.common.model.specification.SetText;
import com.ibm.team.process.internal.common.util.Messages;
import com.ibm.team.process.internal.common.util.ProcessDelta;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ProcessDifferentiator {
    private static final String CANNOT_CREATE_DELTA_FOR_THESE_INPUTS = Messages.getCommonString("ProcessDifferentiator.cannotCreateDelta");
    private ConfigurationDataElement fBaseConfig;
    private ConfigurationDataElement fCustomConfig;
    private List<AbstractElement> fDifferences = new ArrayList<AbstractElement>();
    private static final int GOOD_MATCH = 0;
    private static final int ACCEPTABLE_MATCH = 12;
    private static final int UNACCEPTABLE_MATCH = 13;
    private static final int ATTRIBUTE_MISMATCH = 5;
    private static final int CHILDREN_MISMATCH = 2;
    private static final int CHARACTER_DATA_MISMATCH = 3;

    public ConfigurationDataDeltaElement computeDelta(ConfigurationDataElement baseConfiguration, ConfigurationDataElement customConfiguration) throws ProcessDataValidationException {
        this.fBaseConfig = baseConfiguration;
        this.fCustomConfig = customConfiguration;
        if (baseConfiguration == null && customConfiguration == null) {
            return null;
        }
        if (customConfiguration == null) {
            throw new ProcessDataValidationException(CANNOT_CREATE_DELTA_FOR_THESE_INPUTS);
        }
        if (baseConfiguration == null) {
            this.convertConfigDataToDelta(customConfiguration);
        } else {
            this.visit(this.fBaseConfig, this.fCustomConfig);
        }
        if (this.fDifferences.size() == 0) {
            return null;
        }
        ConfigurationDataDeltaElement delta = new ConfigurationDataDeltaElement(null, "", "configuration-data-delta", null);
        delta.modifyAttribute("configuration-data-id", customConfiguration.getAttribute("id"));
        for (AbstractElement nextChild : this.fDifferences) {
            nextChild.setParent(delta);
            delta.addChildElement(nextChild);
        }
        return delta;
    }

    private void convertConfigDataToDelta(ConfigurationDataElement configData) {
        List childElements = configData.getChildElements();
        this.generateAddition(configData, childElements.size(), childElements);
    }

    private void visit(AbstractElement baseElement, AbstractElement customElement) throws ProcessDataValidationException {
        this.modifyIfNeeded(baseElement, customElement);
        List baseChildren = baseElement.getChildElements();
        List customChildren = customElement.getChildElements();
        int requiredAdditions = customChildren.size() - baseChildren.size();
        if (requiredAdditions < 0) {
            throw new ProcessDataValidationException(CANNOT_CREATE_DELTA_FOR_THESE_INPUTS);
        }
        int additionsCreated = 0;
        int baseIndex = 0;
        while (baseIndex < baseChildren.size()) {
            int bestMatchScore = 13;
            int bestMatchOffset = 0;
            AbstractElement baseChild = (AbstractElement)baseChildren.get(baseIndex);
            int offset = additionsCreated;
            while (bestMatchScore > 0 && offset <= requiredAdditions) {
                AbstractElement customChild = (AbstractElement)customChildren.get(baseIndex + offset);
                int score = this.quantifyMismatches(baseChild, customChild);
                if (score < bestMatchScore) {
                    bestMatchScore = score;
                    bestMatchOffset = offset;
                }
                ++offset;
            }
            if (bestMatchScore > 12) {
                throw new ProcessDataValidationException(CANNOT_CREATE_DELTA_FOR_THESE_INPUTS);
            }
            if (bestMatchOffset > additionsCreated) {
                ArrayList<AbstractElement> elementsToAdd = new ArrayList<AbstractElement>();
                int additionIndex = additionsCreated;
                while (additionIndex < bestMatchOffset) {
                    elementsToAdd.add((AbstractElement)customChildren.get(baseIndex + additionIndex));
                    ++additionIndex;
                }
                this.generateAddition(baseElement, baseIndex - 1, elementsToAdd);
                additionsCreated = bestMatchOffset;
            }
            this.visit(baseChild, (AbstractElement)customChildren.get(baseIndex + additionsCreated));
            ++baseIndex;
        }
        if (requiredAdditions > additionsCreated) {
            ArrayList<AbstractElement> elementsToAdd = new ArrayList<AbstractElement>();
            int baseChildCount = baseElement.getChildElements().size();
            int additionIndex = additionsCreated;
            while (additionIndex < requiredAdditions) {
                elementsToAdd.add((AbstractElement)customChildren.get(baseChildCount + additionIndex));
                ++additionIndex;
            }
            this.generateAddition(baseElement, baseChildCount - 1, elementsToAdd);
        }
    }

    private void modifyIfNeeded(AbstractElement baseElement, AbstractElement customElement) throws ProcessDataValidationException {
        ModifyElement modifyElement = null;
        ArrayList<String> baseAttributes = new ArrayList<String>();
        baseAttributes.addAll(Arrays.asList(baseElement.getAttributeNames()));
        ArrayList<String> customAttributes = new ArrayList<String>();
        customAttributes.addAll(Arrays.asList(customElement.getAttributeNames()));
        for (String name : customAttributes) {
            String baseValue = baseElement.getAttribute(name);
            String customValue = customElement.getAttribute(name);
            if (!customValue.equals(baseValue)) {
                if (modifyElement == null) {
                    modifyElement = this.createModifyElement(baseElement);
                }
                SetAttribute setAttribute = new SetAttribute(modifyElement, "set-attribute", "set-attribute", null);
                setAttribute.modifyAttribute("name", name);
                setAttribute.modifyAttribute("value", customValue);
                modifyElement.addChildElement(setAttribute);
            }
            baseAttributes.remove(name);
        }
        for (String name : baseAttributes) {
            if (modifyElement == null) {
                modifyElement = this.createModifyElement(baseElement);
            }
            RemoveAttribute removeAttribute = new RemoveAttribute(modifyElement, "remove-attribute", "remove-attribute", null);
            removeAttribute.modifyAttribute("name", name);
            modifyElement.addChildElement(removeAttribute);
        }
        if (this.characterDataChanged(baseElement, customElement)) {
            if (modifyElement == null) {
                modifyElement = this.createModifyElement(baseElement);
            }
            SetText setText = new SetText(modifyElement, "set-text", "set-text", null);
            setText.setCharacterData(customElement.getCharacterData());
            modifyElement.addChildElement(setText);
        }
        if (modifyElement != null) {
            this.fDifferences.add(modifyElement);
        }
    }

    private boolean characterDataChanged(AbstractElement baseElement, AbstractElement customElement) {
        if (baseElement.getCharacterData() == null) {
            return customElement.getCharacterData() != null;
        }
        return !baseElement.getCharacterData().equals(customElement.getCharacterData());
    }

    private ModifyElement createModifyElement(AbstractElement baseElement) {
        ModifyElement modifyElement = new ModifyElement(null, null, "modify-element", null);
        AbstractElement ancestorPath = null;
        AbstractElement parent = baseElement;
        while (parent instanceof ProcessConfigurationElement) {
            ProcessConfigurationElement pathSegment = new ProcessConfigurationElement(null, null, parent.getName(), null);
            if (ancestorPath != null) {
                pathSegment.addChildElement(ancestorPath);
                ancestorPath.setParent(pathSegment);
            }
            String[] stringArray = parent.getAttributeNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                pathSegment.modifyAttribute(name, parent.getAttribute(name));
                ++n2;
            }
            pathSegment.setCharacterData(parent.getCharacterData());
            ancestorPath = pathSegment;
            parent = parent.getParentElement();
        }
        if (ancestorPath != null) {
            PathElement path = new PathElement(modifyElement, null, "path", null);
            path.addChildElement(ancestorPath);
            ancestorPath.setParent(path);
            modifyElement.addChildElement(path);
        }
        return modifyElement;
    }

    private int quantifyMismatches(AbstractElement left, AbstractElement right) {
        int score = 0;
        if (!left.getName().equals(right.getName())) {
            return 13;
        }
        ArrayList<String> leftAttributes = new ArrayList<String>();
        leftAttributes.addAll(Arrays.asList(left.getAttributeNames()));
        ArrayList<String> rightAttributes = new ArrayList<String>();
        rightAttributes.addAll(Arrays.asList(right.getAttributeNames()));
        for (String name : leftAttributes) {
            String rightValue;
            String leftValue = left.getAttribute(name);
            if (!leftValue.equals(rightValue = right.getAttribute(name))) {
                score += 5;
            }
            rightAttributes.remove(name);
        }
        score += rightAttributes.size() * 5;
        String leftCharData = left.getCharacterData();
        String rightCharData = right.getCharacterData();
        if (leftCharData == null) {
            if (rightCharData != null) {
                score += 3;
            }
        } else if (!leftCharData.equals(rightCharData)) {
            score += 3;
        }
        if (left.getChildElements().size() != right.getChildElements().size()) {
            score += 2;
        }
        return score;
    }

    private void generateAddition(AbstractElement baseElement, int insertAfterIndex, List<AbstractElement> elementsToAdd) {
        int n;
        AddElement addElement = new AddElement(null, null, "add-element", null);
        AdditionElement addition = new AdditionElement(addElement, "addition", "addition", null);
        addElement.addChildElement(addition);
        int index = 0;
        while (index < elementsToAdd.size()) {
            this.copyChild(addition, (ProcessConfigurationElement)elementsToAdd.get(index));
            ++index;
        }
        AbstractElement ancestorPath = null;
        ProcessConfigurationElement insertAfterInPath = null;
        if (insertAfterIndex < 0) {
            addition.modifyAttribute("location", "first-child");
        } else if (insertAfterIndex >= baseElement.getChildElements().size()) {
            addition.modifyAttribute("location", "last-child");
        } else {
            addition.modifyAttribute("location", "after");
            AbstractElement afterElement = (AbstractElement)baseElement.getChildElements().get(insertAfterIndex);
            insertAfterInPath = new ProcessConfigurationElement(null, null, afterElement.getName(), null);
            String[] stringArray = afterElement.getAttributeNames();
            n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                insertAfterInPath.modifyAttribute(name, afterElement.getAttribute(name));
                ++n2;
            }
            insertAfterInPath.setCharacterData(afterElement.getCharacterData());
            ancestorPath = insertAfterInPath;
        }
        AbstractElement parent = baseElement;
        while (parent instanceof ProcessConfigurationElement) {
            ProcessConfigurationElement pathSegment = new ProcessConfigurationElement(null, null, parent.getName(), null);
            if (ancestorPath != null) {
                pathSegment.addChildElement(ancestorPath);
                ancestorPath.setParent(pathSegment);
            }
            String[] stringArray = parent.getAttributeNames();
            int n3 = stringArray.length;
            n = 0;
            while (n < n3) {
                String name = stringArray[n];
                pathSegment.modifyAttribute(name, parent.getAttribute(name));
                ++n;
            }
            pathSegment.setCharacterData(parent.getCharacterData());
            ancestorPath = pathSegment;
            parent = parent.getParentElement();
        }
        if (ancestorPath != null) {
            PathElement path = new PathElement(addElement, null, "path", null);
            path.addChildElement(ancestorPath);
            ancestorPath.setParent(path);
            addElement.addChildElement(path);
        }
        if (insertAfterInPath != null) {
            int index2 = 0;
            while (index2 < insertAfterIndex) {
                if (ProcessDelta.nameAndAttributesMatch((AbstractElement)baseElement.getChildElements().get(index2), insertAfterInPath)) {
                    this.copyChild(insertAfterInPath.getParentElement(), insertAfterInPath);
                }
                ++index2;
            }
        }
        this.fDifferences.add(addElement);
    }

    private void copyChild(AbstractElement parent, ProcessConfigurationElement child) {
        ProcessConfigurationElement createdElement = new ProcessConfigurationElement(parent, parent.getNamespaceURI(), child.getName(), null);
        String[] stringArray = child.getAttributeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeName = stringArray[n2];
            createdElement.modifyAttribute(attributeName, child.getAttribute(attributeName));
            ++n2;
        }
        if (child.getCharacterData() != null) {
            createdElement.setCharacterData(child.getCharacterData());
        }
        parent.addChildElement(createdElement);
        this.copyChildren(child, createdElement);
    }

    private void copyChildren(ProcessConfigurationElement copySource, AbstractElement copyTarget) {
        for (Object child : copySource.getChildElements()) {
            ProcessConfigurationElement abstractChild = (ProcessConfigurationElement)child;
            this.copyChild(copyTarget, abstractChild);
        }
    }
}

