/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.common.ITeamData;
import com.ibm.team.process.internal.common.InternalProcessCommon;
import com.ibm.team.process.internal.common.ItemHandleAwareHashMap;
import com.ibm.team.process.internal.common.ProcessFactory;
import com.ibm.team.process.internal.common.TeamDataRecord;
import com.ibm.team.process.internal.common.impl.ProcessAreaImpl;
import com.ibm.team.process.internal.common.util.Messages;
import com.ibm.team.process.internal.common.util.TeamDataRecordsListener;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TeamData
implements ITeamData {
    private ProcessAreaImpl fProcessAreaImpl;
    private ItemHandleAwareHashMap fContributorMap;
    private TeamDataRecordsListener fListener;

    public TeamData(ProcessAreaImpl impl) {
        this.fProcessAreaImpl = impl;
    }

    @Override
    public String getContributorData(IContributorHandle contributor, String key) {
        this.initialize();
        Map contributorData = (Map)this.fContributorMap.get(contributor);
        if (contributorData != null) {
            return (String)contributorData.get(key);
        }
        return null;
    }

    @Override
    public void setContributorData(IContributorHandle contributor, String key, String value) {
        this.initialize();
        String oldValue = value == null ? this.removeContributorData(contributor, key) : this.internalSetContributorData(contributor, key, value);
        this.updateTeamDataRecords(contributor, key, oldValue, value);
    }

    @Override
    public void clear() {
        this.initialize();
        this.uninstallChangeListener();
        try {
            if (this.fContributorMap != null) {
                this.fContributorMap.clear();
            }
            this.fProcessAreaImpl.getTeamDataRecords().clear();
        }
        finally {
            this.installChangeListener();
        }
    }

    public void flush() {
        if (this.fContributorMap != null) {
            this.uninstallChangeListener();
            this.fContributorMap = null;
        }
    }

    private String removeContributorData(IContributorHandle contributor, String key) {
        Map contributorData = (Map)this.fContributorMap.get(contributor);
        if (contributorData != null) {
            return (String)contributorData.remove(key);
        }
        return null;
    }

    private void initialize() {
        if (this.fContributorMap == null) {
            this.fContributorMap = new ItemHandleAwareHashMap();
            List teamDataRecords = this.fProcessAreaImpl.getTeamDataRecords();
            for (TeamDataRecord record : teamDataRecords) {
                String obsoleteValue = record.getValue();
                if (obsoleteValue != null && obsoleteValue.length() > 0) {
                    this.internalSetContributorData(record.getContributor(), record.getKey(), obsoleteValue);
                    continue;
                }
                this.internalSetContributorData(record.getContributor(), record.getKey(), record.getValue2());
            }
            this.installChangeListener();
        }
    }

    private void installChangeListener() {
        if (this.fListener == null) {
            this.fListener = new TeamDataRecordsListener(this);
        }
        this.fProcessAreaImpl.eAdapters().add((Object)this.fListener);
    }

    private void uninstallChangeListener() {
        if (this.fListener != null) {
            this.fProcessAreaImpl.eAdapters().remove((Object)this.fListener);
        }
    }

    private String internalSetContributorData(IContributorHandle contributor, String key, String value) {
        ConcurrentHashMap<String, String> contributorData = (ConcurrentHashMap<String, String>)this.fContributorMap.get(contributor);
        if (contributorData == null) {
            contributorData = new ConcurrentHashMap<String, String>(16, 0.75f, 1);
            this.fContributorMap.put(contributor, contributorData);
        }
        return contributorData.put(key, value);
    }

    private void updateTeamDataRecords(IContributorHandle contributor, String key, String oldValue, String value) {
        block10: {
            this.uninstallChangeListener();
            try {
                if (oldValue == null) {
                    if (value == null) {
                        return;
                    }
                    TeamDataRecord record = ProcessFactory.eINSTANCE.createTeamDataRecord();
                    record.setContributor(contributor);
                    record.setKey(key);
                    record.setValue2(value);
                    this.fProcessAreaImpl.getTeamDataRecords().add(record);
                    break block10;
                }
                List records = this.fProcessAreaImpl.getTeamDataRecords();
                Iterator e = records.iterator();
                while (e.hasNext()) {
                    TeamDataRecord record = (TeamDataRecord)e.next();
                    if (!contributor.sameItemId((IItemHandle)record.getContributor()) || !key.equals(record.getKey()) || !oldValue.equals(record.getValue2())) continue;
                    if (value != null) {
                        record.setValue2(value);
                    } else {
                        e.remove();
                    }
                    return;
                }
                RuntimeException x = new RuntimeException(Messages.getCommonString("TeamData.0"));
                InternalProcessCommon.log(x);
                throw x;
            }
            finally {
                this.installChangeListener();
            }
        }
    }
}

