/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common;

import com.ibm.team.fulltext.common.Messages;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class IndexConfig {
    private static Log LOGGER = LogFactory.getLog(IndexConfig.class);
    public static final String TEST_PROPERTY_DEFAULT_PATH_HAS_FILES = String.valueOf(IndexConfig.class.getName()) + ".testProp.defaultPathHasFiles";
    public static final String FULLTEXT_INDEX_NAME = "fulltext_index";
    public static final boolean USE_MULTIPLE_INDEXES = true;
    public static final int OPTIMIZE_INTERVAL = 300;
    public static final int MAX_TOKENS_PER_FIELD = 100000;
    private static String fgIndexLocation = null;
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final char FILE_SEPARATOR_ESCAPE_CHAR = '_';

    public static synchronized void setIndexBaseLocation(String indexBaseLocation) {
        if (indexBaseLocation == null || System.getProperty("JAZZ_HOME") == null || new File(indexBaseLocation).isAbsolute()) {
            LOGGER.debug((Object)String.format("No need to calculate an absolute path. indexBaseLocation: %s. JAZZ_HOME: %s. isAbsolute: %s", indexBaseLocation, System.getProperty("JAZZ_HOME"), indexBaseLocation != null ? Boolean.valueOf(new File(indexBaseLocation).isAbsolute()) : null));
            fgIndexLocation = indexBaseLocation;
        } else {
            fgIndexLocation = IndexConfig.calculateCorrectAbsolutePath(indexBaseLocation);
        }
        LOGGER.debug((Object)String.format("Set fgIndexLocation to %s", fgIndexLocation));
    }

    private static String calculateCorrectAbsolutePath(String relativeIndexBaseLocation) {
        boolean useExpectedPath;
        LOGGER.debug((Object)String.format("Calculating an absolute path. relativeIndexBaseLocation: %s", relativeIndexBaseLocation));
        boolean defaultPathIsExpectedPath = IndexConfig.pathsAreSame(IndexConfig.getDefaultPath(relativeIndexBaseLocation), IndexConfig.getExpectedPath(relativeIndexBaseLocation));
        boolean bl = useExpectedPath = defaultPathIsExpectedPath || !IndexConfig.hasFiles(IndexConfig.getDefaultPath(relativeIndexBaseLocation)) && !Boolean.getBoolean(TEST_PROPERTY_DEFAULT_PATH_HAS_FILES);
        if (useExpectedPath) {
            return IndexConfig.getExpectedPath(relativeIndexBaseLocation);
        }
        LOGGER.warn((Object)NLS.bind((String)Messages.getString("IndexConfig.UsingUnexpectedPath"), (Object)IndexConfig.getDefaultPath(relativeIndexBaseLocation), (Object[])new Object[]{IndexConfig.getExpectedPath(relativeIndexBaseLocation)}));
        return IndexConfig.getDefaultPath(relativeIndexBaseLocation);
    }

    private static String getDefaultPath(String relativeIndexBaseLocation) {
        return new File(relativeIndexBaseLocation).getAbsolutePath();
    }

    private static boolean hasFiles(String path) {
        File file = new File(path);
        boolean hasFiles = file.exists() && file.isDirectory() && file.listFiles().length != 0;
        LOGGER.debug((Object)String.format("hasFiles: %s. path: %s. exists: %s. isDirectory: %s. listFiles: %s", hasFiles, path, file.exists(), file.isDirectory(), file.isDirectory() ? Arrays.asList(file.listFiles()) : null));
        return hasFiles;
    }

    private static boolean pathsAreSame(String pathString1, String pathString2) {
        String p1 = IndexConfig.getPath(pathString1).toString();
        String p2 = IndexConfig.getPath(pathString2).toString();
        return p1.equals(p2);
    }

    private static IPath getPath(String pathString) {
        String device;
        Path path = new Path(pathString);
        if (IndexConfig.isWindows() && (device = path.getDevice()) != null) {
            path = path.setDevice(path.getDevice().toUpperCase());
        }
        return path;
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    private static String getExpectedPath(String relativeIndexBaseLocation) {
        String jazzHome = System.getProperty("JAZZ_HOME");
        try {
            jazzHome = new File(new URL(jazzHome).toURI()).getCanonicalPath();
        }
        catch (Exception e) {
            LOGGER.trace((Object)String.format("Failed to url-decode the value of JAZZ_HOME=\"%s\" - %s", jazzHome, e.getMessage()), (Throwable)e);
        }
        Path jhPath = new Path(jazzHome);
        if (jhPath.lastSegment().equalsIgnoreCase("conf")) {
            String jazzServerPath = jhPath.removeLastSegments(1).toOSString();
            LOGGER.trace((Object)String.format("Removed 'conf' from JAZZ_HOME %s. Result: %s", jazzHome, jazzServerPath));
            LOGGER.trace((Object)String.format("Adding relativeIndexBaseLocation %s to jazzServerPath %s", relativeIndexBaseLocation, jazzServerPath));
            return String.valueOf(jazzServerPath) + FILE_SEPARATOR + relativeIndexBaseLocation;
        }
        LOGGER.error((Object)String.format("JAZZ_HOME is set to an unexpected value. It should be of the form 'JazzInstallDir/server/conf' but it is '%s'", jazzHome));
        return String.valueOf(jazzHome) + FILE_SEPARATOR + relativeIndexBaseLocation;
    }

    public static String getIndexLocation(String type) {
        Path path;
        String rootIndexLocation = fgIndexLocation;
        if (rootIndexLocation != null) {
            path = new Path(rootIndexLocation);
            rootIndexLocation = path.append("fulltext_index/").toOSString();
        } else {
            rootIndexLocation = System.getProperty("com.ibm.team.repository.db.jdbc.location");
            if (rootIndexLocation != null && new File(rootIndexLocation).isDirectory()) {
                path = new Path(rootIndexLocation);
                path = path.removeTrailingSeparator().removeLastSegments(1);
                rootIndexLocation = path.append("fulltext_index/").toOSString();
            } else {
                path = new Path(System.getProperty("java.io.tmpdir"));
                rootIndexLocation = path.append("fulltext_index/").toOSString();
            }
        }
        if (type != null) {
            Path rootIndexPath = new Path(rootIndexLocation);
            String indexLocation = rootIndexPath.append(IndexConfig.escape(type)).toOSString();
            LOGGER.debug((Object)String.format("Returning indexLocation %s", indexLocation));
            return indexLocation;
        }
        LOGGER.debug((Object)String.format("Returning rootIndexLocation %s", rootIndexLocation));
        return rootIndexLocation;
    }

    private static String escape(String str) {
        if (str.contains(FILE_SEPARATOR)) {
            int i = 0;
            while (i < FILE_SEPARATOR.length()) {
                str = str.replace(FILE_SEPARATOR.charAt(i), '_');
                ++i;
            }
        }
        return str;
    }
}

