/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.jdt.internal;

import com.ibm.team.fulltext.common.IQueryProvider;
import com.ibm.team.fulltext.common.ITokenGroup;
import java.util.Arrays;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class JavaQueryProvider
implements IQueryProvider {
    @Override
    public Query createQuery(String tokenType, Analyzer analyzer, ITokenGroup tokenGroup) {
        boolean potentialStacktrace = tokenGroup.getTokenTypes().contains("<com.ibm.team.fulltext.jdt.METHOD_REFERENCE>");
        if ("<com.ibm.team.fulltext.jdt.METHOD_REFERENCE>".equals(tokenType)) {
            return this.createMethodReferenceQuery(tokenGroup);
        }
        if (!potentialStacktrace && "<com.ibm.team.fulltext.jdt.IDENTIFIER>".equals(tokenType)) {
            return this.createIdentifierQuery(tokenGroup);
        }
        return null;
    }

    private Query createMethodReferenceQuery(ITokenGroup tokenGroup) {
        BooleanQuery bQuery = new BooleanQuery();
        ITokenGroup subGroup = tokenGroup.getSubGroup("<com.ibm.team.fulltext.jdt.METHOD_REFERENCE>");
        int count = 0;
        for (Token token : subGroup) {
            Term methodRefTerm = new Term("_content", token.term().toLowerCase());
            TermQuery termQuery = new TermQuery(methodRefTerm);
            bQuery.add(new BooleanClause((Query)termQuery, BooleanClause.Occur.SHOULD));
            ++count;
        }
        return bQuery;
    }

    private Query createIdentifierQuery(ITokenGroup tokenGroup) {
        BooleanQuery bQuery = new BooleanQuery();
        ITokenGroup subGroup = tokenGroup.getSubGroup("<com.ibm.team.fulltext.jdt.IDENTIFIER>");
        for (Token identifierToken : subGroup) {
            DisjunctionMaxQuery identifierQuery = new DisjunctionMaxQuery(0.0f);
            ITokenGroup compoundGroup = tokenGroup.getSubGroup(identifierToken, Arrays.asList("<com.ibm.team.fulltext.jdt.IDENTIFIER_PART>"));
            ITokenGroup identifierParts = compoundGroup.getSubGroup("<com.ibm.team.fulltext.jdt.IDENTIFIER_PART>");
            TermQuery query = new TermQuery(new Term("_name", identifierToken.term()));
            query.setBoost(2.0f);
            identifierQuery.add((Query)query);
            query = identifierParts.toBooleanQuery("_name", BooleanClause.Occur.MUST, false);
            query.setBoost(2.0f);
            identifierQuery.add((Query)query);
            query = new TermQuery(new Term("_content", identifierToken.term()));
            identifierQuery.add((Query)query);
            query = identifierParts.toBooleanQuery("_content", BooleanClause.Occur.MUST, false);
            identifierQuery.add((Query)query);
            query = new PrefixQuery(new Term("_tags", identifierToken.term()));
            identifierQuery.add((Query)query);
            query = identifierParts.toBooleanQuery("_tags", BooleanClause.Occur.MUST, true);
            identifierQuery.add((Query)query);
            query = new TermQuery(new Term("_meta", identifierToken.term()));
            identifierQuery.add((Query)query);
            query = identifierParts.toBooleanQuery("_meta", BooleanClause.Occur.MUST, false);
            identifierQuery.add((Query)query);
            bQuery.add(new BooleanClause((Query)identifierQuery, BooleanClause.Occur.MUST));
        }
        return bQuery;
    }
}

