/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.dto;

import com.ibm.team.process.common.IAccessGroupHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.scm.common.internal.dto2.PermissionContextProvider;
import com.ibm.team.scm.common.internal.dto2.ScmDto2Factory;

public interface IPermissionContextProvider {
    public static final int SET_READ_CONTEXT = 1;
    public static final int CLEAR_READ_CONTEXT = 2;
    public static final IPermissionContextProviderFactory FACTORY = new IPermissionContextProviderFactory(){

        @Override
        public IPermissionContextProvider create(IContributorHandle handle) {
            if (handle == null) {
                throw new IllegalArgumentException();
            }
            PermissionContextProvider p = ScmDto2Factory.eINSTANCE.createPermissionContextProvider();
            p.setFlags(1);
            p.setReadContext((IAuditableHandle)handle);
            return p;
        }

        @Override
        public IPermissionContextProvider create(IProcessAreaHandle handle) {
            if (handle == null) {
                throw new IllegalArgumentException();
            }
            PermissionContextProvider p = ScmDto2Factory.eINSTANCE.createPermissionContextProvider();
            p.setFlags(1);
            p.setReadContext((IAuditableHandle)handle);
            return p;
        }

        @Override
        public IPermissionContextProvider createClear() {
            PermissionContextProvider p = ScmDto2Factory.eINSTANCE.createPermissionContextProvider();
            p.setFlags(2);
            return p;
        }

        @Override
        public IPermissionContextProvider create(IAccessGroupHandle handle) {
            if (handle == null) {
                throw new IllegalArgumentException();
            }
            PermissionContextProvider p = ScmDto2Factory.eINSTANCE.createPermissionContextProvider();
            p.setFlags(1);
            p.setReadContext((IAuditableHandle)handle);
            return p;
        }
    };

    public IAuditableHandle getReadContext();

    public static interface IPermissionContextProviderFactory {
        public IPermissionContextProvider create(IProcessAreaHandle var1);

        public IPermissionContextProvider create(IContributorHandle var1);

        public IPermissionContextProvider create(IAccessGroupHandle var1);

        public IPermissionContextProvider createClear();
    }
}

