/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.registry;

import com.ibm.team.build.internal.common.registry.AbstractBuildExtension;
import com.ibm.team.build.internal.common.registry.Messages;
import com.ibm.team.repository.common.LogFactory;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractBuildExtensionManager {
    protected AbstractBuildExtensionManager() {
    }

    protected List<AbstractBuildExtension> loadExtensions() {
        LinkedList<AbstractBuildExtension> extensions = new LinkedList<AbstractBuildExtension>();
        IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint(this.getExtensionPointId());
        if (extensionPoint != null) {
            IConfigurationElement[] configurationElements = this.getConfigurationElements(extensionPoint);
            int i = 0;
            while (i < configurationElements.length) {
                IConfigurationElement configElement = configurationElements[i];
                try {
                    AbstractBuildExtension extension = this.createExtension(configElement);
                    if (!extensions.contains(extension)) {
                        extensions.add(extension);
                    } else {
                        this.handleDuplicateExtensions(configElement);
                    }
                }
                catch (IllegalArgumentException exception) {
                    this.handleIllegalArgumentException(exception, configElement);
                }
                ++i;
            }
        }
        return extensions;
    }

    protected abstract AbstractBuildExtension createExtension(IConfigurationElement var1);

    protected abstract String getExtensionPointId();

    protected IConfigurationElement[] getConfigurationElements(IExtensionPoint extensionPoint) {
        return extensionPoint.getConfigurationElements();
    }

    protected void handleDuplicateExtensions(IConfigurationElement configElement) {
        Object[] params = new String[]{this.getExtensionFQN(configElement), configElement.getAttribute("id"), configElement.getContributor().getName()};
        String message = NLS.bind((String)Messages.AbstractBuildExtensionManager_DUPLICATE_EXTENSION, (Object[])params);
        LogFactory.getLog((String)"com.ibm.team.build.common").error((Object)message);
    }

    protected void handleIllegalArgumentException(IllegalArgumentException exception, IConfigurationElement configElement) {
        Object[] params = new String[]{this.getExtensionFQN(configElement), configElement.getContributor().getName()};
        String message = NLS.bind((String)Messages.AbstractBuildExtensionManager_ILLEGAL_OR_MISSING_ATTRIBUTE, (Object[])params);
        LogFactory.getLog((String)"com.ibm.team.build.common").error((Object)(String.valueOf(message) + " " + exception.getMessage()));
    }

    protected String getExtensionFQN(IConfigurationElement configElement) {
        return String.valueOf(configElement.getNamespaceIdentifier()) + "." + configElement.getName();
    }
}

