/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.streams;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;

public class DigestComputingOutputStream
extends OutputStream {
    private MessageDigest digest;
    private final OutputStream out;
    private long size;

    public DigestComputingOutputStream(MessageDigest start, OutputStream out) {
        if (start == null) {
            throw new IllegalArgumentException();
        }
        if (out == null) {
            throw new IllegalArgumentException();
        }
        this.digest = start;
        this.out = out;
    }

    public byte[] getIntermediateDigest() throws IOException {
        try {
            return ((MessageDigest)this.digest.clone()).digest();
        }
        catch (CloneNotSupportedException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public byte[] getFinalDigest() {
        MessageDigest d = this.digest;
        this.digest = null;
        return d.digest();
    }

    public long getContentSize() {
        return this.size;
    }

    public MessageDigest getLiveDigest() {
        return this.digest;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.digest.update((byte)b);
        ++this.size;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.digest.update(b, off, len);
        this.size += (long)len;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

