/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.common;

import com.ibm.team.internal.repository.rcp.common.Messages;
import com.ibm.team.repository.rcp.common.IChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ChangeListenerList<SourceType, EventType> {
    private List<IChangeListener<SourceType, EventType>> listeners = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IChangeListener<SourceType, EventType> l) {
        ChangeListenerList changeListenerList = this;
        synchronized (changeListenerList) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<IChangeListener<SourceType, EventType>>();
            }
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        ChangeListenerList changeListenerList = this;
        synchronized (changeListenerList) {
            this.listeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IChangeListener<SourceType, EventType> l) {
        ChangeListenerList changeListenerList = this;
        synchronized (changeListenerList) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(l);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(SourceType source, EventType propertyId) {
        IChangeListener[] listenerArray;
        ChangeListenerList changeListenerList = this;
        synchronized (changeListenerList) {
            if (this.listeners == null) {
                return;
            }
            listenerArray = this.listeners.toArray(new IChangeListener[this.listeners.size()]);
        }
        int i = 0;
        while (i < listenerArray.length) {
            IChangeListener listener = listenerArray[i];
            try {
                listener.changed(source, propertyId);
            }
            catch (RuntimeException e) {
                Log logger = LogFactory.getLog((String)"com.ibm.team.repository.client");
                logger.error((Object)Messages.getString("ChangeListenerList.0"), (Throwable)e);
            }
            ++i;
        }
    }

    public boolean isEmpty() {
        return this.listeners == null;
    }
}

