/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.common.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SetDiff<T> {
    private static SetDiff emptyDiff = new SetDiff(Collections.emptySet(), Collections.emptySet());
    private Set<T> removals;
    private Set<T> additions;

    private SetDiff(Set<T> removals, Set<T> additions) {
        this.additions = additions;
        this.removals = removals;
    }

    public static <T> SetDiff<T> emptyDiff() {
        return emptyDiff;
    }

    public SetDiff<T> add(SetDiff<T> toAdd) {
        HashSet<T> combinedAdditions = new HashSet<T>();
        HashSet<T> combinedRemovals = new HashSet<T>();
        combinedAdditions.addAll(this.additions);
        combinedAdditions.addAll(toAdd.additions);
        combinedRemovals.addAll(this.removals);
        combinedRemovals.addAll(toAdd.removals);
        combinedAdditions.removeAll(combinedRemovals);
        combinedRemovals.removeAll(toAdd.additions);
        combinedRemovals.removeAll(this.additions);
        return new SetDiff(combinedRemovals, combinedAdditions);
    }

    public static <T> SetDiff<T> createSingletonAddition(T addition) {
        return SetDiff.create(Collections.emptySet(), Collections.singleton(addition));
    }

    public static <T> SetDiff<T> createSingletonRemoval(T removal) {
        return SetDiff.create(Collections.singleton(removal), Collections.emptySet());
    }

    public static <T> SetDiff<T> createAddition(Collection<T> additions) {
        return SetDiff.create(Collections.emptySet(), additions);
    }

    public static <T> SetDiff<T> createRemoval(Collection<T> removals) {
        return SetDiff.create(removals, Collections.emptySet());
    }

    public static <T> SetDiff<T> create(Collection<T> removals, Collection<T> additions) {
        return new SetDiff<T>(SetDiff.toSet(removals), SetDiff.toSet(additions));
    }

    private static <T> Set<T> toSet(Collection<T> input) {
        if (input instanceof Set) {
            return (Set)input;
        }
        HashSet<T> result = new HashSet<T>(input);
        return result;
    }

    public void applyTo(Collection<T> toModify) {
        toModify.removeAll(this.removals);
        toModify.addAll(this.additions);
    }

    public static <T> SetDiff<T> computeDiff(Collection<T> oldState, Collection<T> newState) {
        HashSet<T> additions;
        HashSet<T> removals = oldState != null ? new HashSet<T>(oldState) : Collections.EMPTY_SET;
        if (newState != null) {
            additions = new HashSet<T>(newState);
            removals.removeAll(additions);
        } else {
            additions = Collections.EMPTY_SET;
        }
        if (oldState != null) {
            Iterator<T> i = oldState.iterator();
            while (i.hasNext()) {
                additions.remove(i.next());
            }
        }
        return new SetDiff<T>(removals, additions);
    }

    public Set<T> getRemovals() {
        return this.removals;
    }

    public Set<T> getAdditions() {
        return this.additions;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.additions == null ? 0 : this.additions.hashCode());
        result = 31 * result + (this.removals == null ? 0 : this.removals.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetDiff other = (SetDiff)obj;
        if (this.additions == null ? other.additions != null : !this.additions.equals(other.additions)) {
            return false;
        }
        return !(this.removals == null ? other.removals != null : !this.removals.equals(other.removals));
    }

    public boolean isEmpty() {
        return this.additions.isEmpty() && this.removals.isEmpty();
    }
}

